// (c) Femte Gear Internet Software 1998
//************************************************************
//
// The Fish demo !
//
// to run this demo you'll need  :
//  - a web server
//  - a working DBDEMOS.BIOLIFE database available on the webserver.
//
//  see setup.txt for information about setting up a local webserver for testing.
//
// About this demo :
//
// This demo will demonstrate how a text/image database is created using Pixelpack.
// If you can't see the images in your browser, make sure that they are written the
// right place on your server. A normal problem is that they are written somewhere
// that browsers aren't allowed to read from. See the images properties in the
// browser to figure out where the browser is looking.


unit fishdemocode;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PxText, PxCustomImage, PxDBImage, PxCustomText, PxDBText, PxPanel,
  PxDBPanel, Db, DBTables, PxCustomTable, PxDBTable, PxComponent,
  PxVisibleComponent, PxContainer, PxPage,PxMiscTools,
  PxCGI;

type
  TForm1 = class(TForm)
    PxPage1: TPxPage;
    DataSource1: TDataSource;
    Table1: TTable;
    Table1SpeciesNo: TFloatField;
    Table1Category: TStringField;
    Table1Common_Name: TStringField;
    Table1SpeciesName: TStringField;
    Table1Lengthcm: TFloatField;
    Table1Length_In: TFloatField;
    Table1Notes: TMemoField;
    Table1Graphic: TGraphicField;
    PxDBPanel1: TPxDBPanel;
    PxDBText1: TPxDBText;
    PxDBText2: TPxDBText;
    PxDBImage1: TPxDBImage;
    PxPanel1: TPxPanel;
    PxDBText3: TPxDBText;
    PxText1: TPxText;
    PxDBTable1: TPxDBTable;
    PxPanel2: TPxPanel;
    PxText2: TPxText;
    PxCGI1: TPxCGI;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
                

implementation
{$R *.DFM}


procedure TForm1.FormCreate(Sender: TObject);
var
   i : integer;
begin
   // Set up the path that the browser must follow to find the images
     PxSetExternalImagePath('/images/');

     // Set up the path that the server must follow to find the images
     PxSetInternalImagePath('d:\prg\pi3web\images\');

     // delete all AG*.gif files ( max 100 ) on the internal image path older than 5 minutes
     PxCleanupTempResources(5,100);

     // get the requested index for the database and inform the Database panel
     PxDBPanel1.DBIndex:=strtoint(PxCGI1.FormVar('index','0'));

     // load the data for the database table
     PxDBTable1.DBLoadData;

     // now that the data is loaded, add links
     for i :=0 to PxDBTable1.NumberOfRows-1 do
       PxDBTable1.Items[0,i].link:='fish.exe?index='+inttostr(i);

     // all done, send it to the browser and exit
     PxCGI1.send(pxPage1.put);
     halt(0);
end;

end.
