/*****************************************************************************
* ComSoft Library -- io_irp.h     Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Dec. 25, 1985  04-17-88
*
* NAME:        io_irp.h -- include file for io request packets to obj_mgrs
*
* SYNOPSIS:
*              #INCLUDE "io_irp.h"
*
* FUNCTION:
*              This header file includes the io request packet structures
*                                        and definitions.
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


struct IRP                           /* one for each io request queued    */

{
    struct IRP *flink;               /* pointer to next IRP in chain      */
    struct IRP *blink;               /* pointer to prev IRP in chain      */
    int chan;                        /* channel gives access to CCB       */
    unsigned int func;               /* function request                  */
    unsigned long iosl;              /* io 32bit status                   */
    struct MSB *msptr;               /* pointer to mgr status block       */
    unsigned int call_uid;           /* uid of caller                     */
    unsigned int mgr_uid;            /* uid of object manager             */

    unsigned int evp_prvlev;         /* privilege level of EVP to deliver */
    unsigned long evflgmask;         /* event flag mask to set completion */
    unsigned long evflgstop;         /* event flag mask to set stopio     */
    unsigned int *evparg;            /* caller EVP parameters to pass     */

    BYTE tcur[2];                    /* current text cursor position      */
    int wintop;                      /* window top left row, column       */
    int winbot;                      /* window bottom right row, column   */

    unsigned int ihead;
    unsigned int itail;
    char *ibuffer;                   /* input buffer address              */
    unsigned int ibuflen;            /* length of input buffer            */
    unsigned int ohead;
    unsigned int otail;
    char *obuffer;                   /* output buffer address             */
    unsigned int obuflen;            /* length of output buffer           */

    int gcur[2];                     /* current graphics cursor position  */
    BYTE activepg;                   /* vio parameters                    */
    BYTE swappg;
    int color;
    BYTE mode;
    BYTE reserved;
    void (*callend)(char *);         /* caller EVP I/O completion routine */
};

#define IRPSIZ sizeof(struct IRP)


extern struct IRP *io0ps_irphead;

