/*****************************************************************************
* ComSoft Library -- $_config.h   Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Sept. 22, 1985  04-10-88
*
* NAME:        $_config.h -- include file for system configuration
*
* SYNOPSIS:
*              #INCLUDE "$_config.h"
*
* FUNCTION:
*              This header file includes system configuration
*                                        and external variables.
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


/* Configuration */

#define SYS_MAXPROC 10               /* total number of processes         */
#define SYS_MAXOBJ  35               /* total number of objects           */
#define SYS_MAXTYP  10               /* total number of object types      */
#define SYS_MAXTDB  10               /* total number of terminal types    */
#define SYS_MAXMGR  10               /* total number of object managers   */
#define SYS_MAXFUN  11               /* total number of driver functions  */
#define SYS_MAXCHAN 16               /* total number of channels          */
#define SYS_MAXLOCK 00               /* total number of interlocks        */
#define SYS_MAXSEM  00               /* total number of semaphores queues */
#define SYS_NPSTATE 18               /* total number of queued pstates    */
#define SYS_NOSTATE  2               /* total number of queued ostates    */
#define SYS_EXEPRI   2               /* system lowest priority adjust     */
#define SYS_MAXPRI  31               /* system highest priority           */
#define SYS_TABLEN  10               /* maximum entries in shell table    */
#define SYS_MAXTOK  10               /* total number of token tables      */
#define SYS_MAXARG  10               /* total number of argument tables   */
#define SYS_SHLBUF 128               /* shell command buffer size         */
#define SYS_SLICE    0               /* clock tick scheduler step         */
#define SYS_QUANTUM  0               /* preempt base count                */

#define SYS_VERSION " VMiX.286 1.32 unregistered encrypt       Copyright(C)\
 ComSoft 1986, 1987, 1988"


/* Declaration of I/O routines used */

extern SYSCALL ttyread();
extern SYSCALL ttywrite();
extern SYSCALL ttygetc();
extern SYSCALL ttyputc();
extern SYSCALL ttyinit();
extern SYSCALL ttycntl();
extern int ttyin_event();
extern int ttyout_event();
extern int kbd_event();
extern SYSCALL ionull();
extern SYSCALL ioerr();
extern SYSCALL diskread();
extern SYSCALL diskwrite();
extern SYSCALL diskseek();
extern SYSCALL diskinit();
extern SYSCALL diskopen();
extern SYSCALL diskcntl();
extern int disk_event();
extern SYSCALL fileread();
extern SYSCALL filewrite();
extern SYSCALL fileseek();
extern SYSCALL filegetc();
extern SYSCALL fileputc();
extern SYSCALL fileinit();
extern SYSCALL fileopen();
extern SYSCALL fileclose();


/* Configuration Global variables */

extern int ker0i_debug;
extern int ker0i_defdrv;
extern int ker0i_error;
extern int (**ker0pf_int09)();
extern int ker0i_p286;
extern int ker0i_remote;
extern int ker0i_rootshl;
extern int ker0i_shllev;
extern unsigned int ker0ui_shutcnt;

extern BYTE io0b_cgamode;
extern BYTE io0b_chrxsiz;
extern BYTE io0b_chrysiz;
extern BYTE io0b_colorbg;
extern BYTE io0b_colorfg;
extern BYTE io0b_colvmax;
extern BYTE io0b_rowvmax;
extern BYTE io0b_conbg;
extern BYTE io0b_confg;
extern BYTE io0b_conwn;
extern BYTE io0b_currtmod;
extern BYTE io0b_currvfnt;
extern BYTE io0b_currvmod;
extern BYTE io0b_stormode;
extern int io0i_bwinbot;
extern int io0i_bwintop;
extern int io0i_currvsiz;
extern int io0i_rtop;
extern int io0i_violine;

extern int sch0i_swapflg;

/* In-line driver function definitions */

#define get_pixx(x) ((x) * io0b_chrxsiz)           /* column to pixel     */
#define get_pixy(y) (6 + ((y) - 1) * io0b_chrysiz) /* row    to pixel     */

