PAGE 57, 132
TITLE sysgate.asm
COMMENT #

********************* Copyright 1987 by J. Anthony Borras ********************

DATE:     Nov. 05, 1986  10-25-87

NAME:     sysgate -- entry gate to priviledged kernel functions

USAGE:

FUNCTION:
          Prepares argument stack frame for proper entry into
          kernel via INT 15h.

          Execution gets here by       JMP sysgate
          from system service called.

          Include this object file, assembled with MASM, with your
          program link to access the system services described below.
          Must compile your C programs to be linked with this module
          with large model switch.
C - CALL:
          N/A

RETURNS:
          N/A

*****************************************************************************#

;	tell MASM 4.0 about 286 instructions

.286p

;	external C functions

;	global defines

	PUBLIC	_sys_chanreq
	PUBLIC	_sys_getccb
	PUBLIC	_sys_getpcb
	PUBLIC	_sys_getocb
	PUBLIC	_sys_getpid
	PUBLIC	_sys_getqkey
	PUBLIC	_sys_getqnext
	PUBLIC	_sys_getqueue
	PUBLIC	_sys_getstk
	PUBLIC	_sys_kill
	PUBLIC	_sys_memreq
	PUBLIC	_sys_numproc
	PUBLIC	_sys_pinput
	PUBLIC	_sys_spawn
	PUBLIC	_sys_system
	PUBLIC	_sys_sleep
	PUBLIC	_sys_wake
	PUBLIC	_sys_virtual
	PUBLIC	_sys_vprintf


		SUBTTL segments

SYS_TEXT	SEGMENT BYTE PUBLIC 'CODE'

;	Dynamic stack storage layout

dynstk	struc
oldbp	DW	?			;save caller's BP
oldsi	DW	?
retn	DD	?			;far return to caller
args	DW	?			;head of argument list
dynstk	ends

dynsiz	EQU	0


	assume	cs:SYS_TEXT,ds:nothing,es:nothing

sysgate		proc	far
	PUSH	SI
	PUSH	BP
	MOV	BP,SP
	MOV	SI,0Eh
	CMP	AL,07			;a maximum of 7 words of args
	JAE	short goarg
	MOV	SI,0
	CMP	AL,0
	JB	short goarg
	MOV	SI,AX
	AND	SI,0FFh
	ROL	SI,01			;byte length of stack argument list
goarg:
	DEC	SI
	DEC	SI
	JS	short gosvc
	PUSH	[BP+SI].args
	JMP	goarg
gosvc:
	INT	15h			;GO through the gate
	MOV	SP,BP
	POP	BP
	POP	SI
	RET
sysgate		endp


;	User external interface
;	AH = function number, presently 01h to 0Bh
;	AL = word count of arguments in the stack frame
;       followed by a JMP far sysgate.


;	These functions for use to call by name from your
;       own C language program.   They simulate VMiX own
;       internal call frames.


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_chanreq -- I/O channel Object Manager
|
| SYNOPSIS:
|              extern struct IRP *sys_chanreq(uid, action, args);
|
|              unsigned int uid;        object id of requestor
|              char *action;            method requested(see manual)
|              unsigned int args;       variable length args list
|
| FUNCTION:
|              Assigns or deassigns channels.
|              Prepares an IRP for delivery by send to object manager.
|
| RETURNS:
|              = (struct IRP *)irptr
|          or  = NULLPTR
|
|----------------------------------------------------------------------------#

_sys_chanreq	proc	far
	MOV	AX,0107h
	JMP	sysgate
_sys_chanreq	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_memreq -- Memory Object Manager
|
| SYNOPSIS:
|              extern BYTE *sys_memreq(uid, action, args);
|
|              unsigned int uid;        object id of requestor
|              char *action;            method requested(see manual)
|              unsigned int args;       variable length args list
|
| FUNCTION:
|              Assigns or deassigns memory.
|
| RETURNS:
|              = (BYTE *)blkptr
|          or  = NULLPTR
|
|----------------------------------------------------------------------------#

_sys_memreq	proc	far
	MOV	AX,0207h
	JMP	sysgate
_sys_memreq	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_pinput -- prompt and process console input
|
| SYNOPSIS:
|              extern int sys_pinput(msg, chr, length, inptr);
|
|              char *msg;           pointer to message string
|              char chr;            field outline character
|              int length;          length of input field (0 - 127)
|              char **inptr;        address of pointer to input string,
|                                   return is packed with trailing blanks.
|              int count;           number of characters input
|
| FUNCTION:
|              This function performs the processing of prompted input.
|              Uses function pointer fpin instead of getchar.
|              Uses function pointer fpout instead of putchar.
|              It checks for io0i_hascon and io0b_currvmod.
|
| RETURNS:
|              = (int)count
|
|----------------------------------------------------------------------------#

_sys_pinput	proc	far
	MOV	AX,0306h
	JMP	sysgate
_sys_pinput	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_vprintf -- formatted output to object stream
|
| SYNOPSIS:
|              extern void sys_vprintf(ctrl, args);
|
|              char *ctrl;            control string
|              unsigned int args;     array of arguments
|
| FUNCTION:
|              Formatted output directed to SRCSINK stream.
|              Uses (*obj_putc)(int), instead of putchar.
|
| RETURNS:
|              = VOID
|
|----------------------------------------------------------------------------#

_sys_vprintf	proc	far
	MOV	AX,0407h
	JMP	sysgate
_sys_vprintf	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getpid -- gets the id of the currently executing process
|
| SYNOPSIS:
|              extern int sys_getpid();
|
| FUNCTION:
|
| RETURNS:
|              = (int)pid
|
|----------------------------------------------------------------------------#

_sys_getpid	proc	far
	MOV	AX,0500h
	JMP	sysgate
_sys_getpid	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getpcb -- gets pointer to process control block
|
| SYNOPSIS:
|              extern struct PCB *sys_getpcb(pid);
|
|              unsigned int pid;      process id
|
| FUNCTION:
|
| RETURNS:
|              = (struct PCB *)pptr
|
|----------------------------------------------------------------------------#

_sys_getpcb	proc	far
	MOV	AX,0601h
	JMP	sysgate
_sys_getpcb	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getocb -- gets pointer to object control block
|
| SYNOPSIS:
|              extern struct OCB *sys_getocb(type);
|
|              unsigned int type;     object type
|
| FUNCTION:
|
| RETURNS:
|              = (struct OCB *)optr
|
|----------------------------------------------------------------------------#

_sys_getocb	proc	far
	MOV	AX,0701h
	JMP	sysgate
_sys_getocb	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getccb -- gets pointer to channel control block
|
| SYNOPSIS:
|              extern struct OCB *sys_getccb(chan);
|
|              int chan;              channel id
|
| FUNCTION:
|
| RETURNS:
|              = (struct CCB *)cptr
|
|----------------------------------------------------------------------------#

_sys_getccb	proc	far
	MOV	AX,0801h
	JMP	sysgate
_sys_getccb	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getqueue -- gets id of element queued
|
| SYNOPSIS:
|              extern unsigned int sys_getqueue(qid, queue);
|
|              int qid;               queue id
|                                       0 = process queue
|                                       1 = object  queue
|                                       2 = reserved
|                                       3 = type    queue
|
|              int queue;             subqueue id
|
| FUNCTION:
|
| RETURNS:
|              = (unsigned int)id
|
|----------------------------------------------------------------------------#

_sys_getqueue	proc	far
	MOV	AX,0902h
	JMP	sysgate
_sys_getqueue	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getqnext -- gets id of next queued element
|
| SYNOPSIS:
|              extern unsigned int sys_getqnext(qid, id);
|
|              int qid;               queue id
|                                       0 = process queue
|                                       1 = object  queue
|                                       2 = reserved
|                                       3 = type    queue
|
|              unsigned int id;       id of current element in queue chain
|
| FUNCTION:
|
| RETURNS:
|              = (unsigned int)nextid
|
|----------------------------------------------------------------------------#

_sys_getqnext	proc	far
	MOV	AX,0A02h
	JMP	sysgate
_sys_getqnext	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_numproc -- gets total number of active processes
|
| SYNOPSIS:
|              extern unsigned int sys_numproc();
|
| FUNCTION:
|
| RETURNS:
|              = (unsigned int)num
|
|----------------------------------------------------------------------------#

_sys_numproc	proc	far
	MOV	AX,0B00h
	JMP	sysgate
_sys_numproc	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getstk -- gets pointer to process TSS stack store
|
| SYNOPSIS:
|              extern unsigned short *sys_getstk(pid);
|
|              unsigned int pid;      process id
|
| FUNCTION:
|
| RETURNS:
|              = (unsigned short *)pptr
|
|----------------------------------------------------------------------------#

_sys_getstk	proc	far
	MOV	AX,0C01h
	JMP	sysgate
_sys_getstk	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_spawn -- starts a child process job shell
|
| SYNOPSIS:
|              extern int sys_spawn(cmdbuf);
|
|              char *cmdbuf;          ASCIIZ string starting with I/O channel
|                                     requested, followed by standard VMiX
|                                     shell delimited command string:
|                                     (i.e., "1 set video -m3/exec b:basica")
|                                     maximum string length = 127 + '\0'
|
| FUNCTION:
|
| RETURNS:
|              = SYS_OK
|          or  = SYS_ERROR
|
|----------------------------------------------------------------------------#

_sys_spawn	proc	far
	MOV	AX,0D02h
	JMP	sysgate
_sys_spawn	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_kill -- hard terminate a process
|
| SYNOPSIS:
|              extern int sys_kill(pid);
|
|              unsigned int pid;      process id
|
| FUNCTION:
|
| RETURNS:
|                  = SYS_OK
|              or  = SYS_ERROR
|
|----------------------------------------------------------------------------#

_sys_kill	proc	far
	MOV	AX,0E01h
	JMP	sysgate
_sys_kill	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_getqkey -- gets key field of queued element
|
| SYNOPSIS:
|              extern int sys_getqkey(qid, id);
|
|              int qid;               queue id
|                                       0 = process queue
|                                       1 = object  queue
|                                       2 = reserved
|                                       3 = type    queue
|
|              unsigned int id;       id of element in queue chain
|
| FUNCTION:
|
| RETURNS:
|              = (int)key
|
|----------------------------------------------------------------------------#

_sys_getqkey	proc	far
	MOV	AX,0F02h
	JMP	sysgate
_sys_getqkey	endp


COMMENT #
|-----------------------------------------------------------------------------
| NAME:        sys_virtual -- executes a conforming function
|                             in protected mode and returns to real mode
|
| SYNOPSIS:
|              extern int sys_virtual(pfun);
|
|              int (*pfun)();         pointer to function
|
| FUNCTION:
|              sys_virtual creates a global descriptor from the function's
|              physical code segment and a data descriptor that is an alias
|              to the code segment  (before entry to your function, the DS
|              data segment register is set to the code alias GDT selector
|              cs_data1 = 0040h). A descriptor is created for the current
|              physical stack segment at entry to sys_virtual (before entry
|              to your function the SS stack segment register is set to the
|              GDT stack descriptor selector ss_stack = 0020h and the SP is
|              maintained unchanged). On entry to your function, the ES
|              segment register contains 0, the null descriptor selector.
|              The GDT code segment descriptor assigned to your function's
|              physical segment is always cs_code1 = 0038h).
|
|              A conforming function is one where all segment load
|              instructions use selectors (ie., offsets into the gdt).
|
|              sys_memreq can be used to create additional global descriptor
|              entries in the VMiX gdt by using the method "assign gdt" in
|              the request to the VMiX memory object manager.
|              sys_memreq returns the assigned selector.
|
| RETURNS:
|              = (int)
|
|----------------------------------------------------------------------------#

_sys_virtual	proc	far
	MOV	AX,1002h
	JMP	sysgate
_sys_virtual	endp


COMMENT #
/-----------------------------------------------------------------------------
| NAME:        sys_system -- do shell system commands
|
| SYNOPSIS:
|              extern int sys_system(cmdbuf);
|
|              char *cmdbuf;          ASCIIZ string containing any VMiX shell
|                                     request(s).  Accepts a shell format,
|                                     delimited command string:
|                                     (i.e., "set video -m3/dosjob b:basica")
|                                     maximum string length = 127 + '\0'
|
| FUNCTION:
|
| RETURNS:
|              = SYS_OK
|          or  = SYS_ERROR
|
|----------------------------------------------------------------------------#

_sys_system	proc	far
	MOV	AX,1102h
	JMP	sysgate
_sys_system	endp


COMMENT #
/-----------------------------------------------------------------------------
| NAME:        sys_sleep -- sets a process PSTATE to hibernating
|
| SYNOPSIS:
|              extern int sys_sleep(pid);
|
|              unsigned int pid;      process id
|
| FUNCTION:
|
|
| RETURNS:
|              = SYS_OK
|          or  = SYS_ERROR
|
|----------------------------------------------------------------------------#

_sys_sleep	proc	far
	MOV	AX,1201h
	JMP	sysgate
_sys_sleep	endp


COMMENT #
/-----------------------------------------------------------------------------
| NAME:        sys_wake -- sets a hibernating process PSTATE to ready
|
| SYNOPSIS:
|              extern int sys_wake(pid);
|
|              unsigned int pid;      process id
|
| FUNCTION:
|
|
| RETURNS:
|              = SYS_OK
|          or  = SYS_ERROR
|
|----------------------------------------------------------------------------#

_sys_wake	proc	far
	MOV	AX,1301h
	JMP	sysgate
_sys_wake	endp

SYS_TEXT	ends
	end

