/*****************************************************************************
* ComSoft Library -- io_chan.h    Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Dec. 25, 1985  08-18-87
*
* NAME:        io_chan.h -- include file for io channels
*
* SYNOPSIS:
*              #INCLUDE "io_chan.h"
*
* FUNCTION:
*              This header file includes the io channel control structures
*                                        and definitions.
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


/* Channel status constants */

#define CCB_LOCAL     0x00000000L
#define CCB_CONSOLE   0x00000001L
#define CCB_FREE      0x00000100L
#define CCB_ASSIGNED  0x00000200L
#define CCB_VIRTUAL   0x00000400L
#define CCB_TERMINATE 0x00000800L
#define CCB_REMOTE    0x00008000L
#define CCB_COM1      0x00000000L
#define CCB_COM2      0x00010000L
#define CCB_COM3      0x00020000L
#define CCB_COM4      0x00030000L


/* IO channel Structure Declarations
   Channel Control Block in io data base                                  */

struct CCB                                     /* one for each channel    */

{
    struct CCB *flink;                         /* pointer to next in chain*/
    struct CCB *blink;                         /* pointer to prev in chain*/
    int chan;                                  /* CCB channel             */
    unsigned int prvlev;                       /* priv level of assign    */
    unsigned int uid;                          /* uid of channel object   */
    unsigned int call_uid;                     /* uid of caller           */
    unsigned long csl;                         /* channel 32bit status    */
    unsigned int refcnt;                       /* multiple channels to uid*/
    struct IRP *irptr;                         /* pointer to head IRP     */
};

extern struct CCB io0as_chantab[SYS_MAXCHAN];
#define CCBSIZ sizeof(struct CCB)


extern unsigned int io0ui_nextchan;


/* In-line channel function definitions */

#define is_badchan(x)  ((x) < 0 || (x) >= SYS_MAXCHAN)  /* invalid channel*/
#define is_freechan(x) (io0as_chantab[(x)].csl & CCB_FREE) /* free channel*/

