/*****************************************************************************
* ComSoft Library -- dstat.c
*
* DATE:        Feb. 23, 1987  02-12-88
*
* NAME:        dstat -- VMiX 286 device status
*
* SYNOPSIS:
*
* FUNCTION:
*
* RETURNS:
*              N/A
*
*****************************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "c_bios.h"
#include "$_kernel.h"
#include "$_config.h"
#include "$_proc.h"
#include "io_chan.h"
#include "io_irp.h"
#include "io_obj.h"


static char pstate[SYS_NPSTATE] [SYS_PNMLEN + 1] = {
            "current ", "ready   ", "locked  ", "evflag  ",
            "hibernat", "suspend ", "mwait   " };

static char otype[SYS_MAXTYP] [SYS_PNMLEN + 1] = {
            "process ", "terminal", "printer ", "        ", "file    ",
            "memory  ", "disk    ", "manager ", "mail    ", "network " };

static char ostate[SYS_NOSTATE + 1] [SYS_PNMLEN + 1] = {
            "free    ", "ready   ", "assigned" };


main(argc, argv)

int argc;
char *argv[];

{
        register unsigned int i, j;
        char chr, *buf, *status, device[SYS_PNMLEN + 1], buffer[2];
        int size, chan, line = 1, pq = 0, oq = 1, tq =3;
        int top = OSTATE_ASSIGNED, bottom = OSTATE_READY;
        unsigned int pid, uid, type, count = 0;
        struct CCB *cptr;
        struct OCB *optr;
        struct PCB *pptr;

        buf = &buffer[0];
        pid = (unsigned int)sys_getpid();      /* get ourselves first     */
        pptr = sys_getpcb(pid);
        cptr = sys_getccb(pptr->chan);         /* stdio channel           */
        size = (cptr->irptr->winbot >> 8) - (cptr->irptr->wintop >> 8) + 1;
        size = size > 0 ? size : 4;            /* size of display window  */

        for (i = 1; i < argc; i++)             /* parse all line arguments*/
             for (j = 0; chr = tolower(argv[i][j]); j++) {
                  switch (chr) {
                          case 'a':            /* assigned queue          */
                                  top = bottom = OSTATE_ASSIGNED;
                                  break;
                          case 'r':            /* ready queue             */
                                  top = bottom = OSTATE_READY;
                                  break;
                          case '-':
                                  break;
                          default:             /* syntax error            */
                                  break;
                  }
             }

        sys_vprintf(" uid  type     device   prvlev   owner    status   \
chan\r\n");

        for (i = top; i >= bottom ; i--) {
             uid = (unsigned int)sys_getqueue(oq, i);
             chan = sys_getqkey(oq, uid);

             while (!is_baduid(uid)) {
                    type = sys_getqkey(tq, uid);
                    cptr = sys_getccb(chan);
                    optr = sys_getocb(uid);
                    pptr = sys_getpcb(cptr->call_uid);

                    if (++line >= size) {
                        if ((count = sys_pinput("more... press any key",
                                                '\0', 1, &buf)) == SYS_ERROR)
                            break;
                        sys_vprintf(" uid  type     device   prvlev   \
owner    status   chan\r\n");
                        line = 1;
                    }

                    if (type == SRCSINK) {
                        if (cptr->csl & CCB_CONSOLE)
                            strcpy(device, "CONSOLE");
                        else {
                              strcpy(device, "COM");
                              device[3] = '1' + (BYTE)((cptr->csl &
                                                        CCB_COM4) >> 16);
                              device[4] = '\0';
                        }
                    }
                    else device[0] = '\0';

                    if (type == PROCESS) {
                        if (uid != cptr->call_uid) pptr = sys_getpcb(uid);
                        if (pptr->pstate < 7) status = pstate[pptr->pstate];
                        else status = ostate[0];
                    }
                    else status = ostate[i];

                    sys_vprintf("%3d   %-8.8s %-8.8s", uid, otype[type],
                                device);
                    sys_vprintf("    %-2d   %-8.8s %-8.8s", cptr->prvlev,
                                pptr->uname, status);
                    sys_vprintf("    %-2d\r\n", chan);

                    if (chan == EMPTY || (struct CCB *)cptr->flink == cptr) {
                        uid = (unsigned int)sys_getqnext(oq, uid);
                        chan = sys_getqkey(oq, uid);
                    }
                    else chan = cptr->flink->chan;
             }

             if (count == SYS_ERROR) break;
        }
        return(0);
}

