/*****************************************************************************
* ComSoft Library -- c_bios.h     Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Sept. 22, 1985  04-22-88
*
* NAME:        c_bios.h -- include file for I/O related functions
*
* SYNOPSIS:
*              #INCLUDE "c_bios.h"
*
* FUNCTION:
*              This header file includes general I/O structures
*                                                and definitions.
*
*              It uses the direct console Level 1 I/O functions:
*                              getch()
*                              putch(c)
*                              cgets(c)
*                              cputs(c)
*                              cscanf(cs,args...)
*                              cprintf(cs,args...)
*
*
*              Main program should include the following files:
*                              #include "stdio.h"
*                              #include "c_bios.h"
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


#undef getchar
#undef putchar
#undef vprintf
#undef vsprintf
#undef EOF
#undef NULL


/*----------------------------------------------------------------------------
| The following definitions specify the particular C compiler being used.
|
|  BDS     BDS C compiler
|  BELL    Bell Labs C compiler
|  HIGHC   MetaWare C compiler
|  MANX    MANX Aztec C compiler
|  MSC     Microsoft 3.0+ C compiler
|  LATTICE Lattice 2.0+ C compiler
|  TURBOC  Borland C compiler
|---------------------------------------------------------------------------*/

#define IBMPC 1
#define MSDOS 1
#define MSC 1

/*----------------------------------------------------------------------------
| The following symbols define which processor is being used.
|
|  I8080   Intel 8080
|  I8085   Intel 8085
|  I8086   Intel 8086 or 8088
|  I80286  Intel 80286 (also sets I8086)
|  I80386  Intel 80386 (also sets I8086)
|  IBMPC   IBM Personal Computer (also sets I8086)
|  IBMAT   IBM Personal Computer (also sets I8086 AND I80286)
|  M680X0  Motorola 680X0
|  Z80     Zilog Z80
|---------------------------------------------------------------------------*/

#if defined(IBMPC)
#define I8086 1
#endif

#if defined(IBMAT)
#define I80286 1
#define I8086 1
#endif

#if defined(I8086)
#if defined(LATTICE)
#include "m8086.h"
#endif
#endif


/*----------------------------------------------------------------------------
| The following symbols specify which operating system is being used.
|
|  CPM     Any CP/M OS
|  CPM80   CP/M for Intel 8080 or Zilog Z80
|  CPM86   CP/M for Intel 8086
|  CPM68   CP/M for Motorola 68000
|  MSDOS   Microsoft's MSDOS
|
| Note: CPM will be set to 1 for any of the above.
|
|  UNIX    "Standard" UNIX
|  QUNIX   Quantum's QUNIX OS
|  XENIX   Microsoft's XENIX OS
|---------------------------------------------------------------------------*/

#if defined(CPM80)
#define CPM 1
#endif

#if defined(CPM86)
#define CPM 1
#endif

#if defined(CPM68)
#define CPM 1
#endif

#if defined(MSDOS)
#define CPM 1
#endif


/*----------------------------------------------------------------------------
| Define the equivalance for direct console I/O functions to
| their corresponding Level 2 I/O standard functions.
| Must be included so that the more standard names may be used.
|---------------------------------------------------------------------------*/

#define getchar     getch
#define putchar     putch
#define gets        cgets
#define puts        cputs
#define scanf       cscanf
#define printf      cprintf

typedef unsigned char BYTE;          /* byte type                         */
typedef unsigned char BOOL;          /* boolean type                      */


/*----------------------------------------------------------------------------
| The following structure is a File Control Block.  Operating systems
| with CPM-like characteristics use the FCB to store information about
| a file while it is open.
|---------------------------------------------------------------------------*/

struct FCB

{
    BYTE fcbdrv;                               /* drive code              */
    char fcbnam[8];                            /* file name               */
    char fcbext[3];                            /* file name extension     */
#if defined(MSDOS)
    unsigned short fcbcb;                      /* current block number    */
    unsigned short fcblrs;                     /* logical record size     */
    unsigned long fcblfs;                      /* logical file size       */
    unsigned short fcbdat;                     /* create/change date      */
    BYTE fcbsys[10];                           /* reserved                */
    BYTE fcbcr;                                /* current record number   */
    unsigned long fcbrec;                      /* random record number    */
#else
    BYTE fcbexn;                               /* extent number           */
    BYTE fcbs1;                                /* reserved                */
    BYTE fcbs2;                                /* reserved                */
    BYTE fcbrc;                                /* record count            */
    BYTE fcbsys[16];                           /* reserved                */
    BYTE fcbcr;                                /* current record number   */
    unsigned short fcbrec;                     /* random record number    */
    BYTE fcbovf;                               /* random record overflow  */
#endif
};

#define FCBSIZ sizeof(struct FCB)
#define SECSIZ 512                             /* disk sector size        */


/*----------------------------------------------------------------------------
| The following symbols define the sizes of file names and node names.
|---------------------------------------------------------------------------*/

#if defined(CPM)
#define NODLEN 16                              /* maximum node name size  */
#define FNMLEN 16                              /* maximum file name size  */
#define DMA (char *)0x80                       /* disk buffer address     */
#endif

#if defined(MSDOS)
#undef NODLEN
#undef FNMLEN
#define NODLEN 16
#define FNMLEN 64
struct DOSERROR

{
    unsigned int exterror;
    BYTE class, action, locus;
};
#endif

#if defined(UNIX)
#define FNSIZE 16	
#define FMSIZE 64
#endif


/*----------------------------------------------------------------------------
| The following symbols define tty communications parameters
| for the National Semiconductor 8250 UART.
|---------------------------------------------------------------------------*/

#define BAUD110 0
#define BAUD150 32
#define BAUD300 64
#define BAUD600 96
#define BAUD120 128
#define BAUD240 160
#define BAUD480 192
#define BAUD960 224

#define NOPAR  0
#define ODDPAR 8
#define EVNPAR 24

#define STOPONE 0
#define STOPTWO 4

#define BIT7 2
#define BIT8 3


/*----------------------------------------------------------------------------
| The following structures define the 8086 registers that are passed to
| various low-level operating system service functions.
|---------------------------------------------------------------------------*/

#if defined(I80386)
struct LONGREGS

{
    unsigned long eflags;
    unsigned long eax,ecx,edx,ebx;
    unsigned long esp,ebp,esi,edi;
    unsigned short es,cs,ss,ds,fs,gs;
};

struct SHORTREGS

{
    unsigned short ef,flags;
    unsigned short ae,ax,ce,cx,de,dx,be,bx;
    unsigned short se,sp,bep,bp,sep,si,dep,di;
    unsigned short es,cs,ss,ds,fs,gs;
};

struct BYTEREGS

{
    unsigned short ef,flags;
    unsigned short ae;
    BYTE al,ah;
    unsigned short ce;
    BYTE cl,ch;
    unsigned short de;
    BYTE dl,dh;
    unsigned short be;
    BYTE bl,bh;
    unsigned short se,sp,bep,bp,sep,si,dep,di;
    unsigned short es,cs,ss,ds,fs,gs;
};

union WORDREGS                       /* overlays word and byte registers  */

{
    struct SHORTREGS ex;
    struct BYTEREGS eh;
};

union REGS                           /* overlays long, word, and byte regs*/

{
    struct LONGREGS e;
    union WORDREGS x;
};

struct SREGS

{
    unsigned short es,cs,ss,ds,fs,gs;
};
#else
#if defined(I8086)
struct SHORTREGS

{
    unsigned short flags;
    unsigned short ax,cx,dx,bx,sp,bp;
    unsigned short si,di;
    unsigned short es,cs,ss,ds;
};

struct BYTEREGS

{
    unsigned short flags;
    BYTE al,ah,cl,ch,dl,dh,bl,bh;
    unsigned short sp,bp,si,di;
    unsigned short es,cs,ss,ds;
};

union REGS                           /* overlays word and byte registers  */

{
    struct SHORTREGS x;
    struct BYTEREGS h;
};

struct SREGS

{
    unsigned short es,cs,ss,ds;
};

struct POINTER

{
    unsigned short offset,segment;
};

union ADDRESS                        /* overlays far ptrs, offset/segment */

{
    struct POINTER fp;
    unsigned int *fptr;
};
#endif
#endif


#define NULL 0L                      /* null pointer value                */
#define NULLPTR (char *)0            /* null pointer                      */
#define FALSE 0
#define TRUE 1
#define EMPTY (-1)                   /* list empty code                   */
#define EOF (-1)                     /* end-of-file code                  */
#define EOS '\0'                     /* end-of-string                     */
#define SYS_BUFFER 256
#define SYS_OK 1                     /* returned when syscall ok          */
#define SYS_ERROR (-1)               /* returned when syscall fails       */

#define TAB       '\t'               /* definition of ASCII tab number    */
#define CR        '\r'               /* definition of ASCII cr            */
#define NEWLINE   '\n'               /* definition of ASCII newline       */
#define BSP       '\b'               /* definition of ASCII backspace     */
#define BELL      '\7'               /* definition of ASCII bell          */
#define BREAK     '\3'               /* definition of Ctrl Break          */
#define ESC       '\33'              /* definition of Escape              */
#define BLANK     ' '                /* definition of ASCII whitespace    */

#define ROW_VMAX 24                  /* ID of last row on PC video        */
#define COL_VMAX 79                  /* ID of last column on PC video     */
#define EGA_SEG  0xA000              /* ega graphics adapter refresh seg  */
#define EGA_PORT 0x3CE
#define EGA_LINE 350
#define EGP_LINE 480
#define MDA_SEG  0xB000              /* monochrome adapter refresh seg    */
#define MDA_PORT 0x3B4
#define MDA_LINE 200
#define CGA_SEG  0xB800              /* color graphics adapter refresh seg*/
#define CGA_PORT 0x3D4
#define CGA_LINE 200
#define BYTES_40 2048                /* number of bytes on page of 40 cols*/
#define BYTES_80 4096                /* number of bytes on page of 80 cols*/


/* in-line function definitions */

#define abs(x)    ((x) < 0 ? -(x):(x))         /* absolute value function */
#define min(x,y)  ((x) <= (y) ? (x):(y))       /* minimum value function  */
#define max(x,y)  ((x) >= (y) ? (x):(y))       /* maximum value function  */
#define is_odd(x) (1 & (int)(x))               /* test for odd integer    */
#define is_white(c)   ((c) == BLANK || (c) == TAB)
#define is_delimit(c) (is_white((c)) || (c) == ',' || (c) == '/')
#define make_int(x,y) (((int)(y) << 8) | ((int)(x) & 0xFF))

