/*****************************************************************************
* ComSoft Library -- $_proc.h     Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Sept. 29, 1985  03-27-88
*
* NAME:        $_proc.h -- include file for scheduler process control
*
* SYNOPSIS:
*              #INCLUDE "$_proc.h"
*
* FUNCTION:
*              This header file includes the process structures
*                                            and definitions.
*
*              process state definitions
*              process protection modes
*              hardware context structures
*              process control block PCB
*              event process EVP
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


/* Process state constants */

#define PSTATE_CURR     0            /* process currently running         */
#define PSTATE_READY    1            /* process on ready queue            */
#define PSTATE_LOCK     2            /* process waiting for lock          */
#define PSTATE_EVFLG    3            /* process waiting for event         */
#define PSTATE_HIBER    4            /* process hibernating               */
#define PSTATE_SUSPD    5            /* process suspended                 */
#define PSTATE_IOWAT    6            /* process in iowait state           */

                                     /* PROCESS OUTSWAPPED STATES         */ 
#define PSTATE_READYX   7            /* process on ready queue            */
#define PSTATE_LOCKX    8            /* process waiting for lock          */
#define PSTATE_EVFLGX   9            /* process waiting for event         */
#define PSTATE_HIBERX  10            /* process hibernating               */
#define PSTATE_SUSPDX  11            /* process suspended                 */
#define PSTATE_IOWATX  12            /* process in iowait state           */

                                               /* PAGING SUPPORT STATES   */
#define PSTATE_FPW     13                      /* free page wait          */
#define PSTATE_PFW     14                      /* page fault wait         */
#define PSTATE_CPW     15                      /* collided page wait      */

#define PSTATE_INVALID 16                      /* process invalid, if >=  */
#define PSTATE_FREE    17                      /* process slot is free    */
#define PSTATE_CREATE  18                      /* process being created   */


/* Process current privilege levels */

#define CPL_KERNEL      0
#define CPL_EXEC        1
#define CPL_SUPR        2
#define CPL_USER        3


/* Process status constants */

#define PSL_CONSOLE   0x00000001L              /* process uses console    */
#define PSL_INFDOS    0x00000002L              /* process in foreign DOS  */
#define PSL_EXEC      0x00000010L              /* process in exec call    */
#define PSL_STKFD     0x00000020L              /* process using DOS stack */
#define PSL_NESTED    0x00000040L              /* process in nested shell */
#define PSL_FREE      0x00000100L
#define PSL_ACTIVE    0x00000200L
#define PSL_VMODE3    0x00030000L
#define PSL_VMODE6    0x00060000L


/* Intel Task State Segment
   Included in Process Control Block in scheduler data base               */

struct TSS                                     /* one for each process    */

{
    unsigned short tssblink;                   /* task nesting blink      */
    unsigned short pstk[SYS_PRVSTKS][2];       /* off seg of prvlge stacks*/
    unsigned short ip;                         /* instruction pointer     */
    union REGS procregs;                       /* task state registers    */
    unsigned short ldt;                        /* task local descrp table */
};


/* Process Structure Declarations
   Process Control Block in scheduler data base                           */

struct PCB                                     /* one for each process    */

{
    unsigned int pstate;                       /* process state           */
    unsigned int prvlev;                       /* process privilege level */
    int base_pprio;                            /* base priority (0-31)    */
    int curr_pprio;                            /* current = base +- adjust*/
    unsigned long psl;                         /* process 32bit status    */

    int chan;                                  /* assigned I/O channel    */
    unsigned int uid;                          /* object I.D. code        */
    unsigned int parent;                       /* parent pid, 0 for none  */
    char pname[SYS_PNMLEN + 2];                /* process name            */
    char uname[SYS_PNMLEN + 2];                /* user login name         */
    char iname[SYS_INMLEN + 2];                /* image name for subproc  */

    int topshl;                                /* cli active flag         */
    SYSCALL (*cli)();                          /* pointer to cmd interp   */
    unsigned int pargs;                        /* number of args in stack */
    unsigned short imagenv;                    /* image environment seg   */
    unsigned short imagaddr;                   /* image code offset       */
    unsigned short imagseg;                    /* image code segment      */
    unsigned short mcbhead;                    /* exec memory chain head  */

    int psem;                                  /* process lock semaphore  */
    int p_hasmsg;                              /* true, if pmsg valid     */
    BYTE *pmsg;                                /* message for process     */

    unsigned int evpenabl[4];                  /* enabled EVP's by setevp */
    unsigned int evphead[4];                   /* EVP queues process head */
    unsigned int evptail[4];                   /* EVP queues process tail */
    unsigned int evpblock[4];                  /* blocks nested EVP's     */
    unsigned int evplev;                       /* nesting level of EVP's  */

    unsigned long evflg;                       /* 32bit event flag        */
    unsigned long evflgmask;                   /* wait for masked bits    */
    unsigned long evflgexit;                   /* set parent mask flags on
                                                  subprocess deletion     */

    unsigned short msw;                        /* machine status word     */
    unsigned short procsp;                     /* process stack pointer   */
    unsigned short procss;                     /* process stack segment   */
    unsigned int pstklen[4];                   /* stack lengths           */
    unsigned short pstkseg[4];                 /* stack segments          */
    unsigned short pstklim[4];                 /* lowest limit of stacks  */

    unsigned int icnt;                         /* interrupt count         */
    unsigned int *baseaddr;                    /* from address            */
    unsigned int wcnt;                         /* word swap count         */
    unsigned int *swapaddr;                    /* from address            */
    int (*kbd_event)();                        /* kbd_io service routine  */
    int (*kbd_bufio)();                        /* kbd_bufio serv routine  */
    unsigned int intswap[256];                 /* INT  store area         */
    unsigned int memswap[128];                 /* swap store area         */
    unsigned int stkswap[256];                 /* swap store area         */

    struct TSS tss;                            /* INTEL type TSS          */
};

extern struct PCB sch0as_proctab[SYS_MAXPROC];
#define PCBSIZ sizeof(struct PCB)


extern unsigned int sch0ui_currpid;  /* current process id                */
extern unsigned int sch0ui_nextpid;  /* next available pq slot            */
extern unsigned int sch0ui_numproc;  /* number of active processes in pq  */


/* In-line process function definitions */

#define is_badpid(x) ((x) < 0 || (x) >= SYS_MAXPROC)  /* invalid pid      */
#define is_activepid(x) (sch0as_proctab[(x)].psl & PSL_ACTIVE)  /* active */
#define is_client(x)    (!(sch0as_proctab[(x)].psl & PSL_FREE)) /* valid  */

