/*****************************************************************************
* ComSoft Library -- $_mem.h      Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Oct. 7, 1985  04-27-87
*
* NAME:        $_mem.h -- include file for memory management functions
*
* SYNOPSIS:
*              #INCLUDE "$_mem.h"
*
* FUNCTION:
*              This header file includes the memory control structures
*                                            and definitions.
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


/* MCB types */

#define MCB_MSDOS 'M'
#define MCB_VMiX  'V'
#define MCB_END   'Z'


/* MSDOS MCB chain anchor offsets
   from NUL driver chain head                                             */

#define MEMD21 25
#define MEMD30 42
#define MEMD31 36
#define MEMD32 36
#define MEMD33 36


/* Page status constants */
 
#define PSW_LOCKED   0x0001                    /* page is locked in memory*/
#define PSW_NONPG    0x0002                    /* page is in nonpaged pool*/
#define PSW_STACK    0x0010                    /* page assigned to stack  */
#define PSW_IMAGE    0x0020                    /* page assigned to image  */
#define PSW_IRP      0x0040                    /* page assigned to IRP    */
#define PSW_SYSTEM   0x0080                    /* system page             */
#define PSW_FREE     0x0100                    /* page is not in use      */
#define PSW_ASSIGNED 0x0200                    /* page assigned           */
#define PSW_SWAP     0x1000                    /* page has swap           */
#define PSW_ERROR    0x8000                    /* page has errors         */


/* Descriptor access byte */

#define CODE_SEG_ACCESS 0x9B                   /* descriptor access byte  */
#define DATA_SEG_ACCESS 0x93                   /* descriptor access byte  */


/* Memory Structure Declarations
   Memory Control Block in memory data base                               */

struct MCB

{
    char type;                                 /* id byte 'M' 'V' or 'Z'  */
    BYTE psp[2];                               /* program segment prefix  */
    BYTE size[2];                              /* block size (para)       */
    BYTE empty;
    int space[2];
    unsigned int call_uid;                     /* uid of owner            */
    BYTE *mptr;                                /* pointer to memory block */
};

#define MCBSIZ sizeof(struct MCB)

 
struct PGE

{
    unsigned int nextblk;                      /* next page not in block  */
    unsigned int psw;                          /* page 16bit status       */
    unsigned int call_uid;                     /* uid of owner            */
    unsigned int protmask;                     /* protection mask         */
    unsigned short selector;                   /* segment LDT descriptor  */
};

extern struct PGE mem0as_pgetab[SYS_MAXPGE];
#define PGESIZ sizeof(struct PGE)


struct DESCRIPTOR

{
    unsigned short limit_lo_word;              /* segment size =< 64k     */
    unsigned short base_lo_word;               /* 24 bit physical address */
    BYTE base_hi_byte;                         /*        which 64k base   */
    BYTE access_rights;                        /* access byte             */
    BYTE limit_hi_byte;                        /* segment size =< 16 Mbyte*/
    BYTE base_top_byte;                        /* 32 bit physical address */
                                               /*        which 16 Mb base */
};

extern unsigned int mem0ui_nextgdt;  /* next available gdt descriptor slot*/
#define DESCRIPTORSIZ sizeof(struct DESCRIPTOR)


struct PARA                                    /* paragraph structure     */

{
    BYTE mem[16];
};


extern struct MCB *mem0ps_mcbhead;             /* head of alloc mem list  */
extern struct MCB *mem0ps_mcbtail;             /* end  of alloc mem list  */
extern unsigned int mem0ui_maxpge;             /* max. pages in pool      */


/* In-line memory management definitions */

#define roundeb(x)  (((x) + 1) & 0xFFFE)       /* round up to even byte   */
#define trunceb(x)  ((x) & 0xFFFE)             /* truncate to even byte   */
#define roundpar(x) (((x) + 15) & 0xFFF0)      /* round up to paragraph   */ 
#define roundpge(x) (((x) + SYS_PAGE - 1) & 0xFFE0)  /* round up to page  */ 

