/*****************************************************************************
* ComSoft Library -- ps.c
*
* DATE:        Nov. 11, 1986  01-14-88
*
* NAME:        ps -- VMiX 286 processes status
*
* SYNOPSIS:
*
* FUNCTION:
*
* RETURNS:
*              N/A
*
*****************************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "c_bios.h"
#include "$_kernel.h"
#include "$_config.h"
#include "$_proc.h"
#include "io_chan.h"
#include "io_irp.h"
#include "io_obj.h"


static char pstate[SYS_NPSTATE + 1] [SYS_PNMLEN + 1] = {
            "current ", "ready   ", "locked  ", "evflag  ",
            "hibernat", "suspend ", "mwait   " };

main(argc, argv)

int argc;
char *argv[];

{
        register unsigned int i, j;
        char chr, *buf, buffer[2];
        int size, np, line = 1;
        unsigned int pid, count = 0;
        struct CCB *cptr;
        struct PCB *pptr;

        buf = &buffer[0];
        pid = (unsigned int)sys_getpid();      /* get ourselves first     */
        pptr = sys_getpcb(pid);
        cptr = sys_getccb(pptr->chan);         /* stdio channel           */
        size = (cptr->irptr->winbot >> 8) - (cptr->irptr->wintop >> 8) + 1;
        size = size > 0 ? size : 4;            /* size of display window  */
        np = sys_numproc();                    /* how many processes      */

        for (i = 1; i < argc; i++)             /* parse all line arguments*/
             for (j = 0; chr = tolower(argv[i][j]); j++) {
                  switch (chr) {
                          case '-':
                                  break;
                          default:             /* syntax error            */
                                  break;
                  }
             }

        sys_vprintf(" pid  user     state    process  image    prio     \
chan\r\n");

        for (i = 0 ; i < np; i++) {
             pptr = sys_getpcb(i);
             if (pptr->pstate != PSTATE_FREE) {
                 if (++line >= size) {
                     if ((count = sys_pinput("more... press any key",
                                             '\0', 1, &buf)) == SYS_ERROR)
                         break;
                     sys_vprintf(" pid  user     state    process  image    \
prio     chan\r\n");
                     line = 1;
                 }

                 sys_vprintf("%3d   %-8.8s %-8.8s", i, pptr->uname,
                             pstate[pptr->pstate]);
                 sys_vprintf(" %-8.8s %-8.8s %-6d", pptr->pname,
                             pptr->iname, pptr->curr_pprio);
                 sys_vprintf("    %-2d\r\n", pptr->chan);
             }
             else np++;
        }
        return(0);
}

