/*****************************************************************************
* ComSoft Library -- io_obj.h     Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Sept. 22, 1985  02-28-88
*
* NAME:        io_obj.h -- include file for object types
*
* SYNOPSIS:
*              #INCLUDE "io_obj.h"
*
* FUNCTION:
*              This header file includes the object type structures
*                                        and definitions.
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


/* Object type name definitions */

#define PROCESS 0                    /* type proc                         */
#define SRCSINK 1                    /* type tty terminal                 */
#define CHRSINK 2                    /* type prn printer                  */
#define DSKFILE 4                    /* type df                           */
#define MSTRUCT 5                    /* type mf                           */
#define BLKSINK 6                    /* type dsk disk                     */
#define MANAGER 7                    /* type sys proc                     */
#define MAILBOX 8                    /* type mbox                         */
#define DATLINK 9                    /* type dlc data link layer          */


/* Object ostate constants */

#define OSTATE_FREE     0            /* object available                  */
#define OSTATE_READY    1            /* object available                  */
#define OSTATE_ASSIGNED 2            /* channel assigned to object        */


/* Object status constants */

#define OCB_CHAR     0x00000001L
#define OCB_BLOCK    0x00000002L
#define OCB_SPOOL    0x00000004L
#define OCB_MOUNT    0x00000008L
#define OCB_PROC     0x00000010L
#define OCB_MBOX     0x00000020L
#define OCB_NET      0x00000040L
#define OCB_FREE     0x00000100L
#define OCB_ALLOC    0x00000200L
#define OCB_MAYALLOC 0x00000400L
#define OCB_OFFLINE  0x00000800L
#define OCB_SHARE    0x00001000L
#define OCB_SYSTEM   0x00002000L
#define OCB_FOD      0x00004000L
#define OCB_MGR      0x00008000L


/* Control queue sizes */

#define SYS_NTTY 5
#define SYS_NPRN 2
#define SYS_NDSK 4
#define SYS_NDF  4
#define SYS_VOM  10

/* Object Structure Declarations
   Object Manager Status Block in io data base                            */

struct MSB

{
    int status;                      /* obj_mgr return code               */
    unsigned int length;             /* number of bytes processed         */
};


/* Object Structure Declarations
   Object Control Block in io data base                                   */

struct OCB                           /* one for each object type          */

{
    unsigned int type;               /* object type                       */
    unsigned int prvlev;             /* privilege level for allocate      */
    char *eqvname;                   /* object name                       */
    unsigned int mach;
    unsigned int index; 
    unsigned long osl;               /* object 32bit status               */
    unsigned int csr;                /* object hardware port address      */
    unsigned int *ivec;              /* interrupt vector address          */
    unsigned int *ovec;              /* interrupt vector address          */
    unsigned int minor;              /* multiple object copies            */
    unsigned int refcnt;             /* multiple channels serviced        */
    unsigned int mgr_uid;            /* uid of object manager             */
    void (*obj_mgr)(struct IRP *);   /* strategy entry for obj driver     */
    unsigned int *sblock;            /* pointer to MSB status block       */
    unsigned int *irphead;           /* io request packet queue head      */
    unsigned int *irptail;           /* io request packet queue tail      */
    SYSCALL (*obj_read)();           /* manager high level function       */
    SYSCALL (*obj_write)();          /* manager high level function       */
    SYSCALL (*obj_seek)();           /* manager high level function       */
    SYSCALL (*obj_getc)();           /* manager high level function       */
    SYSCALL (*obj_putc)();           /* manager high level function       */
    SYSCALL (*obj_init)();           /* manager high level function       */
    SYSCALL (*obj_open)();           /* manager high level function       */
    SYSCALL (*obj_close)();          /* manager high level function       */
    SYSCALL (*obj_cntl)();           /* manager high level function       */
    int (*obj_ievent)();             /* interrupt dispatch routine        */
    int (*obj_oevent)();             /* interrupt dispatch routine        */
};

extern struct OCB io0as_objtab[SYS_MAXTYP];
#define OCBSIZ sizeof(struct OCB)


/* Object Structure Declarations
   Terminal Description Block in io data base                             */

struct TDB                           /* one for each terminal type        */

{
    unsigned long home;              /* home cursor                       */
    unsigned long clear;             /* clear screen                      */
    unsigned long eos;               /* erase to end of screen            */
    unsigned long eol;               /* erase to end of line              */
    unsigned long position;          /* position cursor                   */
    unsigned long window;            /* window scroll                     */
    unsigned long reserve1;
    unsigned long reserve2;
};


extern char io0ac_objnam[SYS_MAXTYP] [SYS_PNMLEN + 1];
extern unsigned int io0ui_nextuid;


/* In-line object function definitions */

#define is_baduid(x) ((x) < 0 || (x) >= SYS_MAXOBJ)  /* invalid uid       */

