/*****************************************************************************
* ComSoft Library -- $_kernel.h   Copyright (C)1986,1987 by J. Anthony Borras
*
* DATE:        Sept. 22, 1985  04-16-88
*
* NAME:        $_kernel.h -- include file for kernel functions
*
* SYNOPSIS:
*              #INCLUDE "$_kernel.h"
*
* FUNCTION:
*              This header file includes the kernel definitions
*                                        and external variables.
*
* RETURNS:
*              = N/A
*
*****************************************************************************/


/* Initialization constants */

#define SYS_INITARG   0
#define SYS_INITPRI   4
#define SYS_INITREG   0x0000
#define SYS_INITMSW   0x0000
#define SYS_INITFLAG  0x0200
#define SYS_INITNAME  "shell"
#define SYS_INITSTK   2048           /* new process default stack size    */
#define SYS_NULLSTK   512            /* NULL process stack size (bytes)   */
#define SYS_MINSTK    512            /* minimum process stack size (bytes)*/
#define SYS_PAGE      512            /* size of memory page (bytes)       */
#define SYS_MAXPGE    1024           /* max. pages in page table          */
#define SYS_MAXGDT    32             /* max. descriptors in GDT table     */
#define SYS_MAXLDT    32             /* max. descriptors in LDT table     */
#define SYS_PRVSTKS   4              /* TSS number of priviledged stacks  */
#define SYS_PNMLEN    8              /* process name maximum length       */
#define SYS_INMLEN FNMLEN            /* executable image name length      */

#define SCHYES  TRUE                 /* call vm_resched                   */
#define SCHNO   FALSE                /* do not call vm_resched            */
#define MININT -32768
#define MAXINT  32767
#define NULLPID 0                    /* NULL process id                   */
#define NULLUID 0                    /* NULL object id                    */
#define INT00PTR (int (**)())0       /* INT00 div_zero  pointer           */
#define INT09PTR (int (**)())36      /* INT09 kbd_event pointer           */
#define INT10PTR (int (**)())64      /* INT10 ttyout    pointer           */
#define INT16PTR (int (**)())88      /* INT16 kbd_bufio pointer           */
#define INT1FPTR (BYTE **)124        /* INT1F user font pointer           */
#define INT20PTR (int (**)())128     /* INT20 terminate pointer           */
#define INT21PTR (int (**)())132     /* INT21 DOS func  pointer           */
#define INT86PTR (int (**)())536     /* INT86 basic's interrupts pointer  */

typedef int SYSCALL;                 /* system call declaration           */
typedef int LIBRARY;                 /* c_libfun function declaration     */
#define LOCAL static;                /* local declaration                 */


/* External assembly language declarations */

extern unsigned short _psp;
extern BYTE io0b_activepg;
extern unsigned short io0us_addr6845;
extern int io0ai_addrcomm[4];
extern unsigned short ker0us_asmcode;
extern unsigned short ker0us_asmdata;
extern unsigned int sch0ui_clkcnt;
extern unsigned int sch0ui_clkdiff;
extern int sch0i_clkflg;
extern unsigned int sch0ui_clktick;
extern unsigned short ker0us_code;
extern unsigned int io0ui_comm;
extern unsigned int io0ui_commax;
extern int io0ai_commbuf[4];
extern int ker0i_crtc6845;
extern BYTE io0b_crtpalett;
extern unsigned short sch0us_ctxoff;
extern unsigned short sch0us_ctxseg;
extern int io0i_currtsiz;
extern char *io0pc_currvbuf;
extern unsigned short ker0us_data;
extern int ker0i_dos;
extern int ker0i_dosnest;
extern unsigned short ker0us_dosseg;
extern BYTE *io0ap_fontab[4];
extern int io0i_gcurx;
extern int io0i_gcury;
extern struct DESCRIPTOR *mem0as_gdt;
extern int io0i_hascon;
extern int io0i_hwpriv;
extern int ker0i_inbios;
extern int ker0i_infdos;
extern int ker0i_inio;
extern unsigned short ker0us_initoff;
extern unsigned short ker0us_initseg;
extern int ker0i_inkbd;
extern unsigned short ker0us_intsp;
extern unsigned short ker0us_intss;
extern unsigned short ker0us_intds;
extern unsigned short ker0us_kersp;
extern unsigned short ker0us_kerss;
extern unsigned short ker0us_kerds;
extern struct DESCRIPTOR *mem0as_ldt;
extern int ker0i_lockbios;
extern int ker0i_lockfdos;
extern int ker0i_lockfstk;
extern unsigned int mem0ui_maxlloc;
extern unsigned int mem0ui_maxpara;
extern unsigned short mem0us_memfree;
extern unsigned short mem0us_page0;
extern unsigned int sch0ui_preempt;
extern unsigned short sch0us_procsp;
extern unsigned short sch0us_procss;
extern unsigned int io0ui_regenbuf;
extern unsigned int io0ui_regenlen;
extern union REGS *ker0ps_savregs;
extern unsigned int ker0ui_stathw;
extern int io0i_statlin;
extern BYTE io0b_statmod;
extern struct IRP *io0ps_stdirp;
extern int ker0i_stkfd;
extern unsigned char io0b_tcurx;
extern unsigned char io0b_tcury;
extern struct TDB *io0as_tdb;
extern int io0i_term;
extern unsigned int io0ui_termmax;
extern int sch0i_tmqempty;
extern int sch0i_tmqhdkey;
extern unsigned short mem0us_topseg;
extern struct IRP *io0ps_vioirp;
extern unsigned char io0b_vmode;


/* External assembly language functions */

extern void beep();
extern void blkmov(unsigned int *, unsigned int *, unsigned int);
extern int bytein(unsigned int);
extern void byteout(unsigned int, BYTE);
extern void clearline(int, BYTE);
extern void clearpix(BYTE);
extern void clk_event();
extern void clkoff();
extern void clkon();
extern void disable();
extern void enable();
extern void end_remote();
extern int getch();
extern void gregs(union REGS *);
extern int init286();
extern int initasm();
extern int initstk(union REGS *, int (*)());
extern unsigned long int2long(unsigned short, unsigned short);
extern int *long2ptr(unsigned long, unsigned short);
extern void mscurrpsp();
extern int mslodx(char *, char *, BYTE);
extern void proc_event();
extern int putch(int);
extern void scrollwin(int, int, BYTE);
extern unsigned int sint(int, union REGS *);

extern struct IRP *sys_chanreq(unsigned int, char *,...);
extern struct CCB *sys_getccb(int);
extern struct PCB *sys_getpcb(unsigned int);
extern int sys_getpid();
extern struct OCB *sys_getocb(unsigned int);
extern int sys_getqkey(int, unsigned int);
extern int sys_getqnext(int, unsigned int);
extern int sys_getqueue(int, int);
extern unsigned short *sys_getstk(unsigned int);
extern int sys_kill(unsigned int);
extern struct MCB *sys_memreq(unsigned int, char *,...);
extern int sys_numproc();
extern int sys_pinput(char *, char, int, char **);
extern int sys_spawn(char *);
extern int sys_system(char *);
extern int sys_sleep(unsigned int);
extern int sys_wake(unsigned int);
extern int sys_virtual(int (*)());
extern void sys_vprintf(char *,...);

extern void terminate(int);
extern void vm_resched();
extern int vm_virtual(int (*)());
extern void writepix();


/* Interrupt map table */

struct EVENT

{
    int (*objin_event)();            /* address of event service routine */
    unsigned int access_byte;

     /*--------------------------------------------------------------------:
     :                                                bit: 7 6 5 4 3 2 1 0 :
     : access_byte                                        |P|D|P|0|T|Y|P|X|:
     :                                                     | ___ | _______ :
     :                           Segment Present___________|  |  |    |    :
     :                            0 = not present             |  |    |    :
     :                            1 = present in phys mem     |  |    |    :
     :                             Descriptor Privilege_______|  |    |    :
     :                              00 = kernel                  |    |    :
     :                              01 = executive               |    |    :
     :                              10 = supervisor              |    |    :
     :                              11 = user                    |    |    :
     :                                Segment____________________|    |    :
     :                                 0 = control descriptor         |    :
     :                                   Control descriptor type______|    :
     :                                    0000 invalid                     :
     :                                     Three types permitted in        :
     :                                     Interrupt Descriptor Table      :
     :                                    0101 task gate                   :
     :                                    0110 interrupt gate              :
     :                                    0111 trap gate                   :
     :--------------------------------------------------------------------*/

    unsigned int *inargs;            /* pointer to args passed           */
};


/* PSP (Program Segment Prefix) */

struct PSP

{
    unsigned int int20;              /* INT 20h instruction for exit      */
    unsigned short topmem;           /* segment of top of image           */
    char reserved_1;                 /* RESERVED                          */
    BYTE msdosfar;                   /* opcode to call DOS in FAR call    */
    unsigned short msdosoff;         /* offset of DOS entry ptr           */
    unsigned short msdosseg;         /* segment of DOS entry ptr          */
    unsigned short termoff;          /* offset of terminate routine ptr   */
    unsigned short termseg;          /* segment of terminate routine ptr  */
    void (*breakaddr)();             /* control break exit address        */
    void (*erroraddr)();             /* critical error exit address       */
    unsigned short parent;           /* segment of parent psp             */
    char fhandle[20];                /* file handles                      */
    unsigned short envseg;           /* segment of MSDOS process environ  */
    unsigned short sp;               /* process sp store by MSDOS         */
    unsigned short ss;               /* process ss store by MSDOS         */
    char reserved_2[30];             /* RESERVED                          */
    unsigned int int21;              /* INT 21h DOS call instruction      */
    char reserved_3[10];             /* RESERVED                          */
    BYTE pspfcb1[16];                /* first FCB                         */
    BYTE pspfcb2[20];                /* second FCB                        */
    BYTE paramlen;                   /* size of param string              */
    BYTE param[127];                 /* parameters w/leading space        */
};

extern struct PSP ker0s_vmpsp, *ker0ps_vmpsp;
extern unsigned short *ker0ps_currpsp;


/* EXEHD (Exe image header) */

struct EXEHD

{
    unsigned int msig;               /* MS-LINK's signature == 4D5Ah      */
    unsigned int mod512;             /* image length modulus 512 bytes    */
    unsigned int imalen;             /* image + hdr length (512 pages)    */
    unsigned int nreloc;             /* number of relocatable items       */
    unsigned int hdrlen;             /* size of header (para)             */
    unsigned int minalloc;           /* minimum paragraphs above image    */
    unsigned int maxalloc;           /* maximum paragraphs above image    */
    unsigned int ssdisp;             /* displ. of SS within module (para)
                                        if csdisp = 0, displ. from CS     */
    unsigned int sp;                 /* offset put in SP                  */
    unsigned int chksum;             /* sum of all words in file          */
    unsigned int ip;                 /* offset put in IP                  */
    unsigned int csdisp;             /* displ. of CS within module (para) */
    unsigned int reloctab;           /* offset to 1st reloc ptr in table  */
    unsigned int ovlnum;             /* overlay no. (0 = resident)        */
};

