/*------------------------------------------------
   MULHELP.C -- Extension DLL for E! - version 1.0

   To compile: nmake /f mulhelp.mak

   Once compiled, copy MULHELP.EWD to your USER directory.

   MULHELP is a simple EWD allowing use of multiple help files from within
   E!. There are many situations where you have to refer to multiple help
   files. For example, when writing Visual C++ source code with E!, you may
   want to refer to the Windows 3.1 SDK, the MFC 2.0 and the C/C++ language
   help files. It would be nice to load one of this file at will when the
   cursor is located on a keyword.

   With MULHELP you can.

   The first thing you have to do is to create a new section in EW.INI:
   [extended help]. Then, list in that section the help files you want
   to use, as follows:

   HelpName1=file1.hlp
   HelpName2=file2.hlp
   HelpName3=file3.hlp

   and so on...

   Second, you should load MULHELP from the User menu (you can also install
   MULHELP as an autoloaded EWD). MULHELP.EWD must reside in your USER
   diretectory. This step is not mandatory since EW always checks if an
   Extension DLL is loaded when called from the User Menu or using a
   keystroke assignment. If not, EW loads it beofre proceeding.

   Third, open the Keyboard Assignment dialog box, select "Assign DLL" and
   MULHELP and assign MULHELP to, say, three different keystrokes, typing in
   each time a different Routine Id in the RoutineId field (1 for HelpName1, 2
   for HelpName2, ...).

   You may use any unsigned integer as a Routine Id as long as it reflects the
   HelpName entry (e.g. HelpName20 will be used with Routine ID 20).

   For example, I have setup MULHELP for my personal needs as follows:

   [extended help]
   HelpName1=win31wh.hlp
   HelpName2=mfc.hlp
   HelpName3=mscxx.hlp

   Key Assignments:

   MULHELP assigned to SHIFT+F1    with Routine Id 1
   MULHELP assigned to ALT+F1      with Routine Id 2
   MULHELP assigned to ALT+CTRL+F1 with Routine Id 3

   Now, when I hit SHIFT+F1 while the cursor is located on a keyword, EW opens
   the Windows 3.1 SDK help file (this is the standard behavior of E!). When
   I do the same with ALT+F1, EW opens the MFC help file with the same keyword.
   Ditto for ALT+CTRL+F1 with the C/C++ language help file.

   It's important to make SHIFT+F1 participate in this process because it is
   the default key for alternate help. Since MULHELP modifies the "alternatehelp"
   entry in ew.ini, it is preferable to keep SHIFT+F1 tied to the default
   alternate help file.

   Enjoy!

   Patrick Philippot
   07/08/93
  ------------------------------------------------*/

#include <windows.h>
#include "ewapi.h"
#include <stdlib.h>
#include <string.h>

int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
                        LPSTR lpszCmdLine)
{
  if (wHeapSize > 0)
    UnlockData (0) ;
  return 1 ;
}

  char HelpEntry[] = "HelpName";
  char HelpSection[] = "Extended Help";
  char Profile[] = "ew.ini";

int FAR PASCAL EWExecute(unsigned int RoutineId)
{
  char EntryValue[80];
  char IDStr[6];
  char HelpCurEntry[15];
  long CaretPos;

  _itoa(RoutineId, IDStr, 10);
  _fstrcat(_fstrcpy(HelpCurEntry, HelpEntry), IDStr);
  if (GetPrivateProfileString(HelpSection,
                              HelpCurEntry,
                              "",
                              EntryValue,
                              sizeof(EntryValue),
                              Profile) != 0)
  {
    WritePrivateProfileString("system", "alternatehelp", EntryValue, Profile);
    CaretPos = EWGetCaretPos();
    return (EWAlternateHelp(LOWORD(CaretPos), HIWORD(CaretPos)));
  }
  else
  {
    MessageBox(GetFocus(), "No such Entry.", HelpSection, MB_ICONEXCLAMATION);
    return(0);
  }
}
