#include "windows.h"
#include "sample.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>


HANDLE hInst;
HWND hMainWnd;
HWND hDlgModeless  = 0;             // handle for modeless dialogs.
HCURSOR hHourGlass;

long *dwM, *dwN, *dwIACK, *dwIPT, *dwABORT;

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
   MSG msg;

   hHourGlass = LoadCursor(NULL, IDC_WAIT);

   if (!hPrevInstance)                  // Other instances of app running?
      if (!InitApplication(hInstance)) // Initialize shared things
         return (FALSE);              // Exit if unable to initialize

   // Perform initializations that apply to a specific instance

   if (!InitInstance( hInstance, nCmdShow ))
      return( FALSE );
      
   // Get, translate, and dispatch messages until WM_QUIT is received


   // Message loop modified to work with modeless dialog box

   while (GetMessage(&msg, NULL, NULL, NULL)) {
      if (hDlgModeless == 0 || !IsDialogMessage(hDlgModeless, &msg)) {
         TranslateMessage(&msg);
         DispatchMessage(&msg);
      }
   }

   return( msg.wParam );
}

// Function: InitApplication
// Initialize the application: fill in the window-class structure
// and register the window class. Return TRUE on success, FALSE
// on failure.

BOOL InitApplication (HANDLE hInstance)
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = GetStockObject( WHITE_BRUSH );
    wc.lpszMenuName =  "MainMenu";
    wc.lpszClassName = "SampleWinClass";

    return (RegisterClass(&wc));

}

// Function: InitInstance
// Save the instance handle and create the main window for this instance.

BOOL InitInstance (HANDLE hInstance, int nCmdShow)
{
    HWND hWnd;

    hInst = hInstance;

    // Create a main window for this application instance.

    hWnd = CreateWindow("SampleWinClass", "DLL Example",
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT,
        NULL, NULL, hInstance, NULL);

    // If window could not be created, return "failure"

    if( !hWnd )
        return( FALSE );
    else
      hMainWnd = hWnd;     // save for future reference!

    // Make the window visible; update its client area; and return "success"

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return(TRUE);

}

// Function: MainWndProc
// Process messages sent to the main window. Display results
// when user clicks the "Ok" button on the "Multiply" dialog box.

long FAR PASCAL MainWndProc (HWND hWnd, unsigned message,
                             WORD wParam, LONG lParam)
{
   FARPROC lpProc;          // pointer to dialog-box functions
   static FARPROC lpfnSetAddrI;

   switch( message ) {
   case WM_CREATE:
      
      init_window(hWnd);
      
      lpfnSetAddrI = MakeProcInstance(SetAddrI, hInst);
      init_lpsetI(lpfnSetAddrI);
            
      setupDLL();
      if (!checkLinks(hWnd))
         SendMessage (hWnd, WM_QUIT, 0, 0L);
      break;   
    case WM_COMMAND:       // message: command from application menu
        switch( wParam ) {
        case IDM_ABOUT:
            lpProc = MakeProcInstance(AboutBoxFunc, hInst);
            DialogBox(hInst, "AboutBox", hWnd, lpProc);
            FreeProcInstance(lpProc);
            break;
        case IDM_EXIT:
           DestroyWindow (hWnd);
           return(0);
        case IDM_SETV:
            lpProc = MakeProcInstance(SetupFunc, hInst);
            DialogBox(hInst, "Setup", hWnd, lpProc);
            FreeProcInstance(lpProc);
            break;
         case IDM_DOIT:
            hDlgModeless = CreateDialog(hInst, "DoIt", hWnd,
                           MakeProcInstance(DoItFunc, hInst));
            break;
        default:
            return(DefWindowProc(hWnd, message, wParam, lParam));
        }
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;

    default:
        return(DefWindowProc(hWnd, message, wParam, lParam));
    }
    return(NULL);
}

BOOL FAR PASCAL AboutBoxFunc(
                      HWND hDlg,        // window handle of the dialog box
                      unsigned message, // type of message
                      WORD     wParam,  // message-specific information
                      LONG     lParam )
{
    switch( message )
    {

    case WM_INITDIALOG:             // message: initialize dialog box
        return( TRUE );

    case WM_COMMAND:                      // message: received a command
        if( wParam == IDOK                // "OK" box selected?
            || wParam == IDCANCEL)        // System menu close command?
        {
            EndDialog( hDlg, TRUE );      // Exits the dialog box
            return( TRUE );
        }
    break;
    }
    return( FALSE );               // Didn't process a message
} // AboutBoxFunc

BOOL FAR PASCAL SetupFunc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
   BOOL lpTrans;
   long n1,n2;
   
   switch (message) {
   case WM_INITDIALOG:
      SetDlgItemInt(hDlg, IDD_PARAM1, (WORD)*dwM, FALSE);
      SetDlgItemInt(hDlg, IDD_PARAM2, (WORD)*dwN, FALSE);
      return (TRUE);

   case WM_COMMAND:
      switch (wParam) { 
      case IDOK:
         n1 = (long) GetDlgItemInt (hDlg, IDD_PARAM1, &lpTrans, 0);
         if (!lpTrans) {
             MessageBox (hDlg, "Invalid value for first parameter",
                                 NULL, MB_ICONHAND | MB_OK);
             return(FALSE);
         }
         else
            *dwM = n1;
            
         n2 = (long) GetDlgItemInt (hDlg, IDD_PARAM2, &lpTrans, 0);
         if (!lpTrans) {
             MessageBox (hDlg, "Invalid value for second parameter",
                                 NULL, MB_ICONHAND | MB_OK);
             return(FALSE);
         }
         else
            *dwN = n2;
            
         EndDialog (hDlg, TRUE);
         return (TRUE);

      case IDCANCEL:
         EndDialog (hDlg, TRUE);
         return (TRUE);
      }
   break;
   }
   return (FALSE);
}

BOOL FAR PASCAL DoItFunc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
   static int exitAction = 0;
   BOOL bDoingSomething;
   char buff[255];
   HCURSOR hSaveCursor;
   
   switch (message) {
   case WM_COMMAND:
      switch (wParam) {
      case IDD_CANCEL:
         // if the user presses 'cancel' when we're doing a calculation,
         // tell the DLL and carry on...
         // If we're not doing anything, though, close the dialog window.
         
         if (bDoingSomething) {
         
            // the 'winabort' flag is raised when we want to exit from the
            // calculation, and is checked within the DLL every iteration.
            // If the DLL finds this flag is non-zero, it causes
            // an exit back up the call chain, eventually returning control
            // to the IDD_DOIT case, after the call to alloc().
            
            *dwABORT = 1;
         }
         else {
            *dwABORT = 0;
            DestroyWindow(hDlg);
            hDlgModeless = 0;
         }
         return (TRUE);

      // Perform the calculation... when done, it changes the button
      // text so the user can press it to exit.

      case IDD_DOIT:

         // if we're exiting, go and do it...

         if (exitAction == 1) {
            DestroyWindow(hDlg);
            hDlgModeless = 0;
            return (TRUE);
         }

         // do the allocation.... disable the button first...
         
         EnableWindow(GetDlgItem(hDlg, IDD_DOIT), FALSE);
         
         sprintf(buff,"Calculating...");
         SetDlgItemText (hDlg, IDD_MSG, buff);
         hSaveCursor = SetCursor(hHourGlass);
         bDoingSomething = TRUE;
         ackerman();
         SetCursor(hSaveCursor);
         bDoingSomething = FALSE;

         // done - so disable the 'cancel' button, and enable the
         // 'exit' button

         SetWindowText(GetDlgItem(hDlg, IDD_DOIT), "Exit");
         EnableWindow(GetDlgItem(hDlg, IDD_DOIT), TRUE);
         EnableWindow(GetDlgItem(hDlg, IDD_CANCEL), FALSE);
         
         if (*dwABORT == 1) {
            sprintf(buff,"Calculation was interrupted!");
            SetDlgItemText (hDlg, IDD_MSG, buff);
         }
         else {
            sprintf(buff,"Result: %ld",*dwIACK);
            SetDlgItemText (hDlg, IDD_MSG, buff);
         }

         exitAction = 1;
         
         SetFocus(hDlg);

         return(TRUE);
      }
      break;

   case WM_INITDIALOG:
      // set the flags - 
      // bDoingSomething is set when an allocation is in progress,
      // and affects the repainting and cancel behaviour.
      // dwABORT is a pointer to the DLLs abort flag; the DLL checks
      // this flag each time thru the iteration loop, and will bail out if 
      // it sees this set non-zero. SO it's important to set it to zero when
      // we start!
      // exitAction is a flag showing the state of the IDD_DOIT button, which
      // will show 'Do It!' on entry, and then 'Exit' when the calculation
      // has finished.
      
      bDoingSomething = FALSE;
      *dwABORT = 0;
      exitAction = 0;
      
      // pass the window handle to the DLL; this causes the c_update_window
      // routine in the DLL to update the right window....
         
      init_window(GetDlgItem(hDlg,IDD_MSG));

      return (TRUE);
   }
   return (FALSE);
}

// SetAddrI is a callback function which the DLL uses to pass over
// the addresses of ints

BOOL FAR PASCAL SetAddrI (LPSTR var, long *n)
{
   char szBuffer[128];

   // print out variable as a check
   wsprintf (szBuffer, "Variable to set = %s", var);
   MessageBox  (NULL, szBuffer, "SetAddrI", MB_OK);

   if (!lstrcmp(var, (LPSTR)"m")) {
      dwM = n;
      wsprintf (szBuffer, "m = %ld", *dwM);
      MessageBox (NULL, szBuffer, "SetAddrI", MB_OK);
   }
   else if (!lstrcmp(var, (LPSTR)"n")) {
      dwN = n;
      wsprintf (szBuffer, "n = %ld", *dwN);
      MessageBox (NULL, szBuffer, "SetAddrI", MB_OK);
   }
   else if (!lstrcmp(var, (LPSTR)"iack")) {
      dwIACK = n;
      wsprintf (szBuffer, "iack = %ld", *dwIACK);
      MessageBox (NULL, szBuffer, "SetAddrI", MB_OK);
   }
   else if (!lstrcmp(var, (LPSTR)"ipt")) {
      dwIPT = n;
      wsprintf (szBuffer, "ipt = %ld", *dwIPT);
      MessageBox (NULL, szBuffer, "SetAddrI", MB_OK);
   }
   else if (!lstrcmp(var, (LPSTR)"abort")) {
      dwABORT = n;
      wsprintf (szBuffer, "abort = %ld", *dwABORT);
      MessageBox (NULL, szBuffer, "SetAddrI", MB_OK);
   }
   else {
      wsprintf (szBuffer, "Unrecognised variable = %s", var);
      MessageBox (NULL, szBuffer, "SetAddrI", MB_OK);
   }
   
   return(TRUE);
}

// checkLinks does a check on all the pointers which should have been
// set up by the DLL calling back.... if any are still null, it'll
// complain.

BOOL checkLinks (HWND hWnd)
{
   BOOL bretval;
   char szVarName[80], szBuff[255];

   bretval = TRUE;

   // integers...

   if (dwM == NULL) {
      strcpy(szVarName,"M");
      bretval = FALSE;
   }
   if (dwN == NULL) {
      strcpy(szVarName,"N");
      bretval = FALSE;
   }
   if (dwIACK == NULL) {
      strcpy(szVarName,"IACK");
      bretval = FALSE;
   }
   if (dwIPT == NULL) {
      strcpy(szVarName,"IPT");
      bretval = FALSE;
   }
   if (dwABORT == NULL) {
      strcpy(szVarName,"ABORT");
      bretval = FALSE;
   }

   if (bretval == FALSE) {
      sprintf(szBuff,
        "Variable %s unlinked.\nThis is an internal program error.", 
        szVarName);
      MessageBox (hWnd, szBuff, "Fatal Data Link Error", MB_OK | MB_ICONSTOP);
   }

   return(bretval);
}
