// openfile.h RHS 3/31/91

#if !defined(OPENFILE_H)
#define OPENFILE_H

#include<windows.h>
#include<stdio.h>
#include<string.h>

#define OPENFILE_FILEOPEN   0x00
#define OPENFILE_FILESAVE   0x01

class OpenFileDlg
    {
private:
    static char filename[FILENAME_MAX];
    static char openname[FILENAME_MAX];
    static char defpath[FILENAME_MAX];
    static char defspec[13];
    static char default_extension[4];
    static char str[FILENAME_MAX*2];
    static unsigned hEditBox, hListBox, hPath;
    static char caption[20];
    static char buttontext[20];
    static char mode;
    static WORD attribute;

    static void UpdateListBox(HWND hDlg);
    static void ChangeDfExt(char *Ext, char *Name);
    static void SeparateFilePath(LPSTR lpDestPath,
            LPSTR lpDestFileName, LPSTR lpSrcFileName);
    static void AddExtension(char *Name, char *Ext);
    void SetDefaults(void)
        {
        hEditBox = hListBox = hPath = 0;
        }
public:
    OpenFileDlg(char *dspec = "*.TXT", char *dext = ".TXT")
        {
        SetDefaults();
        strcpy(defspec,dspec);
        strcpy(default_extension,dext);
        }
    OpenFileDlg(char *dspec, char *dext, char *newcap, char *btext)
        {
        OpenFileDlg(dspec,dext);
        SetCaption(newcap);
        SetButtonText(btext);
        }
    void Init(char *newext, char *newspec, 
            unsigned hEB, unsigned hLB, unsigned hPth, char newmode)
        {
        SetDefExtension(newext);
        SetDefSpec(newspec);
        hEditBox = hEB;
        hListBox = hLB;
        hPath = hPth;
        mode = newmode;
//        attr = attribute;
        }
    void SetDefExtension(char *newext)  
        {   
        strcpy(default_extension,newext);   
        }
    void SetDefSpec(char *newspec)  {   strcpy(defspec,newspec);    }
    char *GetFileName(void)         {   return filename;            }
    void SetCaption(char *newcap)   {   strcpy(caption,newcap);     }
    void SetButtonText(char *newtext){  strcpy(buttontext,newtext); }

    static BOOL CALLBACK DlgProc(HWND, UINT, WPARAM, LPARAM);
    };

#endif

