// editwin.h RHS 1/15/92

#if !defined(EDITWIN_H)
#define EDITWIN_H

#include"winapp.h"

class EditWin : public Window
    {
    void SetDefaults(void)
        {
        SetClassName("Edit");
        SetWinStyle(WS_CHILD | WS_VISIBLE);
        }

public:
    EditWin(Window *parent, WORD id)  : Window("")
        {
        SetParent(parent->GetHandle());
        SetDefaults();
        SetChildId(id);
        }

    EditWin(HWND parenthWnd, WORD id) : Window("")
        {
        SetParent(parenthWnd);
        SetDefaults();
        SetChildId(id);
        }
    ~EditWin()
        {
        if(GetHandle())
            DestroyWindow(GetHandle());
        }


    void SetChildId(WORD id)    {   SetWinMenu((HMENU)id);              }
    void SetParent(Window *w)   {   SetWinParent(w->GetHandle());              }
    void SetParent(HWND h)      {   SetWinParent(h);                    }
    void SetWinText(char *text) {   SetWinName(text);                   }

    void AddHScroll(void)       {   AddWinStyle(WS_HSCROLL);            }
    void AddVScroll(void)       {   AddWinStyle(WS_VSCROLL);            }
    void AddBorder(void)        {   AddWinStyle(WS_BORDER);             }
    void SetAutoHScroll(void)   {   AddWinStyle(ES_AUTOHSCROLL);        }
    void SetAutoVScroll(void)   {   AddWinStyle(ES_AUTOVSCROLL);        }
    void SetCenterText(void)    {   AddWinStyle(ES_CENTER);             }
    void SetLeftText(void)      {   AddWinStyle(ES_LEFT);               }
    void SetLowerCase(void)     {   AddWinStyle(ES_LOWERCASE);          }
    void SetMultiLine(void)     {   AddWinStyle(ES_MULTILINE);          }
    void SetNoHideSel(void)     {   AddWinStyle(ES_NOHIDESEL);          }
    void SetOemConvert(void)    {   AddWinStyle(ES_OEMCONVERT);         }
    void SetPassWord(void)      {   AddWinStyle(ES_PASSWORD);           }
    void SetRightText(void)     {   AddWinStyle(ES_RIGHT);              }
    void SetUpperCase(void)     {   AddWinStyle(ES_UPPERCASE);          }

    BOOL EMCANUNDO(void)
        {
        return (BOOL)SendMessage(hWnd,EM_CANUNDO,0,0L);
        }

    void EMCLEARMODIFY(void)
        {
        SendMessage(hWnd,EM_SETMODIFY,0,0L);
        }

    void EMEMPTYUNDOBUFFER(void)
        {
        SendMessage(hWnd,EM_EMPTYUNDOBUFFER,0,0L);
        }

    BOOL EMFMTLINES(WORD wParam)
        {
        return (BOOL)SendMessage(hWnd,EM_FMTLINES,wParam,0L);
        }

    HANDLE EMGETHANDLE(void)
        {
        return (HANDLE)SendMessage(hWnd,EM_GETHANDLE,0,0L);
        }

    WORD EMGETLINE(WORD wParam, LONG lParam)
        {
        return (WORD)SendMessage(hWnd,EM_GETLINE,wParam,lParam);
        }

    WORD EMGETLINECOUNT(void)
        {
        return (WORD)SendMessage(hWnd,EM_GETLINECOUNT,0,0L);
        }

    WORD EMGETMODIFY(void)
        {
        return (WORD)SendMessage(hWnd,EM_GETMODIFY,0,0L);
        }

    void EMGETRECT(LPRECT lParam)
        {
        SendMessage(hWnd,EM_GETRECT,0,(LONG)lParam);
        }

    LONG EMGETSEL(void)
        {
        return SendMessage(hWnd,EM_GETSEL,0,0L);
        }

    void EMLIMITTEXT(WORD wParam)
        {
        SendMessage(hWnd,EM_LIMITTEXT,wParam,0L);
        }

    WORD EMLINEFROMCHAR(WORD wParam)
        {
        return (WORD)SendMessage(hWnd,EM_LINEFROMCHAR,wParam,0L);
        }

    WORD EMLINEINDEX(WORD wParam)
        {
        return (WORD)SendMessage(hWnd,EM_LINEINDEX,wParam,0L);
        }

    WORD EMLINELENGTH(WORD wParam)
        {
        return (WORD)SendMessage(hWnd,EM_LINELENGTH,wParam,0L);
        }

    void EMLINESCROLL(LONG lParam)
        {
        SendMessage(hWnd,EM_LINESCROLL,0,lParam);
        }

    void EMREPLACESEL(LPSTR lParam)
        {
        SendMessage(hWnd,EM_REPLACESEL,0,(LONG)lParam);
        }

    void EMSETHANDLE(HANDLE wParam)
        {
        SendMessage(hWnd,EM_SETHANDLE,(WORD)wParam,0L);
        }

    void EMSETMODIFY(WORD wParam)
        {
        SendMessage(hWnd,EM_SETMODIFY,wParam,0L);
        }

    void EMSETMODIFY(void)
        {
        SendMessage(hWnd,EM_SETMODIFY,1,0L);
        }

    void EMSETPASSWORDCHAR(WORD wParam)
        {
        SendMessage(hWnd,EM_SETPASSWORDCHAR,wParam,0L);
        }

    void EMSETRECT(LPRECT lParam)
        {
        SendMessage(hWnd,EM_SETRECT,0,(LONG)lParam);
        }

    void EMSETRECTNP(LPRECT lParam)
        {
        SendMessage(hWnd,EM_SETRECTNP,0,(LONG)lParam);
        }

    void EMSETSEL(LONG lParam)
        {
        SendMessage(hWnd,EM_SETSEL,0,lParam);
        }

    BOOL EMSETTABSTOPS(WORD wParam, LPINT lParam)
        {
        return SendMessage(hWnd,EM_SETTABSTOPS,wParam,(LONG)lParam);
        }

    WORD EMSETWORDBREAK(FARPROC lParam)
        {
        return SendMessage(hWnd,EM_SETWORDBREAK,0,(LONG)lParam);
        }

    BOOL EMUNDO(void)
        {
        return SendMessage(hWnd,EM_UNDO,0,0L);
        }

    void WMCLEAR(void)
        {
        SendMessage(hWnd,WM_CLEAR,0,0L);
        }

    void WMCOPY(void)
        {
        SendMessage(hWnd,WM_COPY,0,0L);
        }

    void WMCUT(void)
        {
        SendMessage(hWnd,WM_CUT,0,0L);
        }

    void WMPASTE(void)
        {
        SendMessage(hWnd,WM_PASTE,0,0L);
        }

    void WMUNDO(void)
        {
        SendMessage(hWnd,WM_UNDO,0,0L);
        }

    BOOL Create(void)
        {
        SetWinInstance(GetInstance());
        SetWinClassName(lpszClassName);
        if(WHdl.Create())
            {
            hWnd = WHdl.GetHandle();
            return TRUE;
            }
        return FALSE;
        }
    };
#endif


