// notbad.cpp RHS 1/15/92

#include<stdio.h>
#include<memory.h>
#include<time.h>
#include<string.h>
#include<fcntl.h>
#include<sys\stat.h>
#include<io.h>
#include<ctype.h>
#include"stdwin.h"
#include"editwin.h"
#include"openfile.h"
#include"notbad.h"

char *szAppName = "NotBad";
char *szUntitled = "(untitled)";
HWND editWinHdl = NULL;
char findbuffer[50];
BOOL upperonly = FALSE;
BOOL forward = TRUE;

BOOL CALLBACK AboutDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM)
    {
    switch(message)
        {
        case WM_INITDIALOG:
            SetDlgItemInt(hDlg,4,GetWindowTextLength(editWinHdl),FALSE);
            return TRUE;

        case WM_COMMAND:
    	    if (wParam == IDOK || wParam == IDCANCEL)
                {
                EndDialog(hDlg, TRUE);
                return TRUE;
                }
            break;
        }
    return FALSE;
    }

BOOL CALLBACK FindDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM)
    {
    BOOL result;

    switch(message)
        {
        case WM_INITDIALOG:                        // message: initialize    
            SetDlgItemText(hDlg,IDM_FINDSPEC,findbuffer);
            CheckDlgButton(hDlg,IDM_CASEBUTTON,upperonly);
            CheckRadioButton(hDlg,IDM_FORBUTTON,IDM_BACKBUTTON,
                (forward ? IDM_FORBUTTON : IDM_BACKBUTTON));
            SetFocus(GetDlgItem(hDlg, IDM_FINDSPEC));
            return FALSE; // Indicates the focus is set to a control

        case WM_COMMAND:
            switch(wParam)
                {
                case IDM_CASEBUTTON:
                    CheckDlgButton(hDlg,IDM_CASEBUTTON,
                        !IsDlgButtonChecked(hDlg,IDM_CASEBUTTON));
                    upperonly = !upperonly;
                    return TRUE;
                case IDM_FORBUTTON:
                case IDM_BACKBUTTON:
                    CheckRadioButton(hDlg,IDM_FORBUTTON,IDM_BACKBUTTON,
                        (!IsDlgButtonChecked(hDlg,IDM_FORBUTTON) ? 
                            IDM_FORBUTTON : IDM_BACKBUTTON));
                    forward = !forward;
                    return TRUE;
                case IDC_CANCEL:
                    EndDialog(hDlg, FALSE);
                    return TRUE;
                case IDOK:
                    if(GetDlgItemText(hDlg,IDM_FINDSPEC,findbuffer,
                        sizeof(findbuffer)-1))
                        EndDialog(hDlg,TRUE);
                    else
                        MessageBox(hDlg,"Nothing to find!",NULL, 
                            MB_OK | MB_ICONHAND);
                    return TRUE;
                }
        }
    return FALSE;
    }

    // searches for 'str' from 'buf[len]' to buf
char *findrstr(char *buf, char *str, int len, int upperonly)
    {
    int buflen = strlen(buf);
    int slen = strlen(str);
    if(len < buflen)
        buflen = len;

    int i, j;
    if(upperonly)
        for( buflen--, slen-- ; buflen >= slen; buflen--)
            {
            if(buf[buflen] == str[slen])
                {
                for(i = slen-1, j = buflen-1; i >= 0; i--, j--)
                    if(buf[j] != str[i])
                        break;
                if(i < 0)
                    return &buf[j+1];
                }
            }
    else
        for( buflen--, slen-- ; buflen >= slen; buflen--)
            {
            if(toupper(buf[buflen]) == toupper(str[slen]))
                {
                for(i = slen-1, j = buflen-1; i >= 0; i--, j--)
                    if(toupper(buf[j]) != toupper(str[i]))
                        break;
                if(i < 0)
                    return &buf[j+1];
                }
            }

    return NULL;
    }

void GetDateTime(char *buf)
    {
    char *days[7] = 
        { 
        "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
        "Friday", "Saturday" 
        };
    char *months[12] = 
        {
        "January", "February", "March", "April", "May", "June",
        "July", "August", "September", "October", "November", "December"
        };
    int year,month,day,dow;
    int hour, minutes, seconds;

    _AH = 0x2A;
    asm int 0x21;

    dow = _AL;
    year = _CX;
    month = _DH;
    day = _DL;

    _AH = 0x2C;
    asm int 0x21;
    hour = _CH;
    minutes = _CL;
    seconds = _DH;

    BOOL pm = FALSE;

    if(hour > 12)
        {
        pm = TRUE;
        hour -= 12;
        }
    if(!hour)
        hour = 12;
    sprintf(buf,"%s, %s %d, %04d, %d:%02d:%02d%s",
        days[dow],months[month],day,year,hour,minutes,seconds,
        (pm ? "pm" : "am"));
    }

class myApp : public WinAppStdWindow
    {
    EditWin *editWin;
    HMENU myMenu;
    BOOL menusOff;
    BOOL wordWrap;
    int scrollMin, scrollMax;
    char filename[80];
    char newfile[80];
    char appName[10];
    HCURSOR hHourGlass;
    BOOL fileSaved;

public:
    myApp(char *name) : WinAppStdWindow(name)
        {
        editWin = NULL;
        myMenu = NULL;
        SetClassMenu("MENU_1");
        SetClassIcon("ICON_1");
        menusOff = TRUE;
        wordWrap = FALSE;
        strcpy(filename,szUntitled);
        strcpy(appName,szAppName);
        hHourGlass = LoadCursor(NULL,IDC_WAIT);
        *findbuffer = '\0';
        }
    void SetTitle(void)
        {
        if(!hWnd)
            return;
        char buf[100];
        sprintf(buf,"%s - %s",appName,filename);
        SetWindowText(hWnd,buf);
        }
    void CheckForChanges(void)
        {
        if(editWin->EMGETMODIFY())
            {
            char buf[50];
            sprintf(buf,"Save changes to %s?",strupr(filename));
            if(MessageBox(hWnd,buf,appName,MB_YESNO) == IDYES)
                SendMessage(hWnd,WM_COMMAND,IDM_SAVE,0L);
            }
        }
    void InitEditWindow(RECT *rect = NULL)
        {
        editWin = new EditWin(hWnd,IDM_CNTRL);
        if(!wordWrap)
            {
            editWin->AddHScroll();
            editWin->SetAutoHScroll();
            }
        if(rect)
            {
            editWin->SetWinX(0);
            editWin->SetWinY(0);
            editWin->SetWinWidth(rect->right-rect->left);
            editWin->SetWinHeight(rect->bottom-rect->top);
            }
        editWin->AddVScroll();
        editWin->SetAutoVScroll();
        editWin->AddBorder();
        editWin->SetLeftText();
        editWin->SetMultiLine();
        editWin->Create();
        editWinHdl = editWin->GetHandle();
        }

    void WMCREATE(void)
        {
        InitEditWindow();
        myMenu = GetMenu(hWnd);
        lstrcpy(newfile,GetCmdLine());
        if(*newfile)
            SendMessage(hWnd,WM_COMMAND,IDM_OPENARG,0L);
        SetTitle();
        }
        
    void WMSETFOCUS(void)
        {
        if(editWin)
            SetFocus(editWin->GetHandle());
        }
    void WMSIZE(void)
        {
        if(editWin)
            MoveWindow(editWin->GetHandle(),0,0,LOWORD(lParam)-0,
                HIWORD(lParam)-0,TRUE);
        }
    void WMINITMENU(void)
        {
        EnableMenuItem(myMenu,IDM_PASTE,
            IsClipboardFormatAvailable(CF_TEXT) ?
                (MF_BYCOMMAND | MF_ENABLED)     :
                (MF_BYCOMMAND | MF_GRAYED));

        LONG l = editWin->EMGETSEL();
        WORD diff = HIWORD(l)-LOWORD(l);
        EnableMenuItem(myMenu,IDM_CUT,
            diff ? (MF_BYCOMMAND | MF_ENABLED) : (MF_BYCOMMAND | MF_GRAYED));
        EnableMenuItem(myMenu,IDM_COPY,
            diff ? (MF_BYCOMMAND | MF_ENABLED) : (MF_BYCOMMAND | MF_GRAYED));
        EnableMenuItem(myMenu,IDM_DEL,
            diff ? (MF_BYCOMMAND | MF_ENABLED) : (MF_BYCOMMAND | MF_GRAYED));
        EnableMenuItem(myMenu,IDM_UNDO,
            editWin->EMCANUNDO() ? 
                (MF_BYCOMMAND | MF_ENABLED) : 
                (MF_BYCOMMAND | MF_GRAYED));
        }
    void WMDESTROY(void)    {   PostQuitMessage(0);     }
    void WMQUERYENDSESSION(void)
        {
        CheckForChanges();
        MsgReturnValue = -1;
        }

    void WMCLOSE(void)      
        {   
        CheckForChanges();
        DestroyWindow(hWnd);    
        }
    void WMCOMMAND(void);
    };


void myApp::WMCOMMAND(void)
    {
    switch(wParam)
        {
        case IDM_CNTRL:
            {
            switch(HIWORD(lParam))
                {
                case EN_CHANGE:
                    if(menusOff)
                        {
                        EnableMenuItem(myMenu,IDM_SELECTALL,
                            MF_BYCOMMAND | MF_ENABLED);
                        menusOff = FALSE;
                        }
                    break;
                case EN_ERRSPACE:
                    MessageBox(hWnd,"Cannot insert any more characters..."
                        "out of memory!",appName,MB_OK);
                    break;
                }
            }
            break;
        case IDM_UNDO:
            editWin->EMUNDO();
            break;
        case IDM_PASTE:
            editWin->WMPASTE();
            break;
        case IDM_COPY:
            editWin->WMCOPY();
            break;
        case IDM_CUT:
            editWin->WMCUT();
            break;
        case IDM_DEL:
            editWin->WMCLEAR();
            break;
        case IDM_EXIT:
            WMCLOSE();
            break;
        case IDM_TIMEDATE:
            {
            char buf[50];
            GetDateTime(buf);
            buf[strlen(buf)] = '\0';
            editWin->EMREPLACESEL(buf);
            }
            break;
        case IDM_SELECTALL:
            editWin->EMSETSEL(MAKELONG(0,
                GetWindowTextLength(editWin->GetHandle())));
            break;
        case IDM_ABOUT:
            DialogBox(GetInstance(), "ABOUTBOX", hWnd, ::AboutDlg);
            break;
        case IDM_NEW:
            CheckForChanges();
            strcpy(filename,szUntitled);
            SetTitle();
            SetWindowText(editWin->GetHandle(),"");
            break;
            
        case IDM_OPEN:
            {
            CheckForChanges();
            OpenFileDlg Ofile;
            Ofile.Init(".txt","*.txt",IDC_EDIT,IDC_LISTBOX,
                IDC_PATH,OPENFILE_FILEOPEN);
            Ofile.SetCaption("Open File");
            Ofile.SetButtonText("Open");
            if(DialogBox(GetInstance(), "FILEOPEN", hWnd, 
                    OpenFileDlg::DlgProc))
                strcpy(newfile,Ofile.GetFileName());
            else
                break;
            }
            // fall thru
        case IDM_OPENARG:
            {
            int fh = open(newfile,O_RDONLY);
            if(fh == -1)
                {
                MessageBox(hWnd,"Unable to open file.",appName,MB_OK);
                break;
                }
            long len;
            if((len = filelength(fh)) > 32767L)
                {
                MessageBox(hWnd,"File too big for NOTBAD buffer.",appName,
                    MB_OK);
                close(fh);
                break;
                }
            WORD bytesread;
            HANDLE hdl = GlobalAlloc(GMEM_MOVEABLE,len+1);
            LPSTR lp = (LPSTR)GlobalLock(hdl);
            if(!hdl || !lp)
                {
                MessageBox(hWnd,"Unable to allocate read-buffer for file.",
                    appName, MB_OK);
                if(hdl)
                    GlobalFree(hdl);
                break;
                }
            strcpy(filename,newfile);
            _lread(fh,lp,(WORD)len);           
            close(fh);
            lp[len] = '\0';
            SetTitle();
            SetWindowText(editWin->GetHandle(),lp);
            GlobalUnlock(hdl);
            GlobalFree(hdl);
            }
            break;

        case IDM_FIND:
            if(!DialogBox(GetInstance(), "FIND", hWnd, FindDlgProc))
                break;
            // fall thru
        case IDM_FINDNEXT:
            {
            char *p = (char  *)LocalLock(editWin->EMGETHANDLE());
            char *bufstart = p;
            int len = strlen(findbuffer);
            int offset = ((wParam == IDM_FINDNEXT) && forward) ? 
                HIWORD(editWin->EMGETSEL()) :
                LOWORD(editWin->EMGETSEL());
            char *q = NULL;
            if(forward)
                {
                if(upperonly)
                    q = strstr(&p[offset],findbuffer);
                else
                    {
                    int i;
                    p = &p[offset];
                    for(i = 0; i < strlen(p); i++)
                        if(!strncmpi(findbuffer,&p[i],len))
                            {
                            q = &p[i];
                            break;
                            }
                    }
                }
            else
                q = findrstr(p,findbuffer, offset,
                    (upperonly ? TRUE : FALSE));
            if(!q)
                MessageBox(hWnd,"Not found!",appName,MB_OK);
            else
                editWin->EMSETSEL(MAKELONG(q-bufstart,q+len-bufstart));
            
            LocalUnlock(editWin->EMGETHANDLE());
            }
            break;
                
        case IDM_SAVEAS:
            {
            char *p = strchr(filename,'.');
            OpenFileDlg Ofile;
            char buf[7];
            if(p)
                {
                strcpy(buf,"*");
                strcat(buf,p);
                }
            else
                strcpy(buf,"*.*");
            Ofile.Init(buf,filename,IDC_EDIT,IDC_LISTBOX,IDC_PATH,
                OPENFILE_FILESAVE);
            Ofile.SetCaption("Save As");
            Ofile.SetButtonText("Save File");
            if(DialogBox(GetInstance(), "FILEOPEN", 
                hWnd, OpenFileDlg::DlgProc))
                {
                char temp[80];
                strcpy(temp,filename);
                strcpy(filename,Ofile.GetFileName());
                SendMessage(hWnd,WM_COMMAND,IDM_SAVE,0L);
                if(editWin->EMGETMODIFY())
                    strcpy(filename,temp);
                else
                    SetTitle();
                }
            }
            break;
        case IDM_SAVE:
            if(!strcmp(filename,szUntitled))
                {
                SendMessage(hWnd,WM_COMMAND,IDM_SAVEAS,0L);
                break;
                }
                
            HCURSOR old = SetCursor(hHourGlass);
            {
            int fh = open(filename,O_WRONLY | O_CREAT | O_TRUNC | O_BINARY);
            if(fh == -1)
                {
                MessageBox(hWnd,"Unable to open file for writing.",
                    appName,MB_OK);
                break;
                }
            editWin->EMFMTLINES(0);
            HANDLE hdl = editWin->EMGETHANDLE();
            char *p = (char *)LocalLock(hdl);
            unsigned len = strlen(p);
            write(fh,p,len);
            close(fh);
            LocalUnlock(hdl);
            editWin->EMCLEARMODIFY();
            }
            SetCursor(old);
            break;
            
        case IDM_WORDWRAP:
            {
            RECT rect;
            GetWindowRect(editWin->GetHandle(),&rect);
            EditWin *oldEditWin = editWin;
            HANDLE oldHdl = oldEditWin->EMGETHANDLE();

            wordWrap = !wordWrap;

            ShowWindow(oldEditWin->GetHandle(),SW_HIDE);
            InitEditWindow(&rect);
            HANDLE newHdl = editWin->EMGETHANDLE();
            editWin->EMSETHANDLE(oldHdl);
            oldEditWin->EMSETHANDLE(newHdl);
            delete oldEditWin;

            CheckMenuItem(myMenu,IDM_WORDWRAP, wordWrap ? 
                    (MF_BYCOMMAND | MF_CHECKED) : 
                    (MF_BYCOMMAND | MF_UNCHECKED));
            }
            break;
        }
    }

int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
    {
    myApp MyWin(szAppName);
    MyWin.Display();                    // open the window
    return MyWin.Run();                 // process any messages
    }
