{ This is the trial interface for LZEXPAND.DLL, based on my
observations of the Windows 3.0 programs that called LZEXPAND. }


 unit LZExpand;
 
 interface
 
 uses WinTypes;
 
 function  LZCOPY (SourceHandle, 
                   DestHandle : Integer) : Longint;
   { LZCOPY takes the handle of a source file (opened with LZOPENFILE) and
     the handle of a destination file (opened via the OpenFile API). It
     expands the source file (if it's compressed) as it copies it to the
     destination. The result is positive and gives the number of bytes
     copied if the call succeeds; otherwise, it's negative. }
 function  LZOPENFILE (FileName : PChar;
                       var ReOpenBuff : TOFStruct;
                       Style : Word) : Integer;
   { LZOPENFILE is analogous to the Windows API function OpenFile, and acts
     identically if the file being opened is not compressed. If the file
     being opened is compressed, however, calls to LZREAD and LZSEEK
     automatically work on the compressed file. Note that Turbo's PChar
     type is equivalent to LPSTR in C, and a TOFStruct, passed as a var
     parameter, generates a pointer which is the equivalent of an LPOFSTRUCT.
     If the result is positive, it's the handle of the newly-opened file. }  
 function LZINIT (FileHandle : Integer) : Integer;
   { While this procedure is exported, I couldn't find a Windows application
     that called it; it was called by the library itself as needed. It
     appears to accept the handle of an open file and return a new handle
     if the file is compressed. }   
function LZSEEK (FileHandle : Integer;
                   Offset : Longint;
                   Origin : Integer) : Longint;
   { This is LZEXPAND's analogue of the _llseek function. It takes the same
     parameters and returns the same results, except that it works on all files
     accessed via the LZEXPAND library. }   
function  LZREAD (FileHandle : Integer;
                   Buffer : PChar;
                   Bytes : Integer) : Word;
  { This is LZEXPAND's analogue of the _lread function. It takes the same
    parameters and returns the same results, except that it works on all files
    accessed via the LZEXPAND library. }   
function  LZCLOSE (FileHandle : Integer) : Integer;
   { This is LZEXPAND's analogue of the _lclose function. It takes the same
     parameters and returns the same results: 0 if successful, -1 otherwise.
     It must be called when a program is finished acccessing a file via
     library. }
 
 function  LZSTART : Integer;
  { Must be called before copying a file via LZEXPAND. This routine appears
    to return a 1 if successful and a negative number if it's not. }  
 function COPYLZFILE (SourceHandle,
                       DestHandle : Integer) : Longint;
  { Must be called before accessing a file via LZEXPAND. This routine appears
    to return a 1 if successful and a negative number if it's not. }  
 procedure LZDONE;
  { This procedure must be called when a program is finished using the LZEXPAND
    library to copy files. }
 
 function  GETEXPANDEDNAME (FileName, ExpandedName : PChar) : Integer;
   { This procedure gives the name of the uncompressed version of the
     specified file. }
 
 implementation
 { Give the ordinal and the DLL name for each routine. }
 function  LZCOPY; external 'LZEXPAND' index 1;
 function  LZOPENFILE; external 'LZEXPAND' index 2;
 function  LZINIT; external 'LZEXPAND' index 3;
 function  LZSEEK; external 'LZEXPAND' index 4;
 function  LZREAD; external 'LZEXPAND' index 5;
 function  LZCLOSE; external 'LZEXPAND' index 6;
 function  LZSTART; external 'LZEXPAND' index 7;
 function  COPYLZFILE; external 'LZEXPAND' index 8;
 procedure LZDONE; external 'LZEXPAND' index 9;
 function  GETEXPANDEDNAME; external 'LZEXPAND' index 10;
 
 begin
 end.
