// STATDEMO.C   STATISTCS dialog box routines

/*   This module will display the analysis of
      the simulated data in our survey database. */


#include "survdemo.h"

 /* DEFINE OWNER-DRAW BUTTON BORDER THICKNESS */
#define THICKNESS   3


       /* GDI Handles Used Only In Statdemo.c */
HBRUSH hBrushBkGndStats;
HBITMAP hBitmapBkGndStats;
HBITMAP hBitmapSurvBtn1;

extern HICON hIconStats;
extern HWND  hDlgGraph;

extern struct
  {
  int idno;
  int fieldno;
  }
 checkbox[];


#define MAXRECS  45

#define nFields  45

// Array of stat data

STATDATA statdata[MAXRECS];

fakedataStats[nFields] =
  {
  6,10,6,1,1,
  4,11,8,1,0,
  4,9,8,3,0,
  5,9,6,2,0,
  5,10,5,2,2,
  7,10,2,3,2,
  7,8,5,2,2,
  3,12,5,2,1,
  6,11,6,1,0
  };




/**************************************************/
BOOL FAR PASCAL StatisticsDlgProc( HWND hDlg,
                     unsigned iMessage, WORD wParam,
                     LONG lParam )
  {
  WORD CtrlID; /* ID of DlgBox's child control */
  int type;
  int i,id;
  char buff[MAXFIELDSIZE];
  DWORD wMsgReturn,wMsgRet;
  double Recnum;
  static FARPROC lpfnGraphDlgProc;
  static HWND hCtrlHead401, hCtrlHead402;


    switch ( iMessage )
    {
    case WM_INITDIALOG:

      lpfnGraphDlgProc = MakeProcInstance
                            (GraphDlgProc, hInst );

      hBitmapBkGndStats  = LoadBitmap(hInst,
                                       "BkGndCyn");
      hBrushBkGndStats = CreatePatternBrush
                               (hBitmapBkGndStats);
      hBitmapSurvBtn1  = LoadBitmap(hInst,
                                       "SurvBtn1");

      // Test the use of WM_SETFONT

      hCtrlHead401 = GetDlgItem(hDlg, IDSTAT_401);
      SendMessage(hCtrlHead401,WM_SETFONT,
                                    hFontTimes,0);

      hCtrlHead402 = GetDlgItem(hDlg, IDSTAT_402);
      SendMessage(hCtrlHead402,WM_SETFONT,
                               hFontTimesSmall,0);

      MakeStats(hDlg);
      break;

    case WM_PAINT:
      if (IsIconic(hDlg))
        {
        PaintIcon(hDlg,hIconStats);
        break;
        }
      else
          PaintStats(hDlg);
          break;

    case WM_DRAWITEM:
      id = ((LPDRAWITEMSTRUCT)lParam)->CtlID;
      switch (id)
        {
        case IDSPB_PRINT9:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                              DT_CENTER,THICKNESS);
          return TRUE;

        case IDSPB_UPDATE8:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                              DT_CENTER,THICKNESS);
          return TRUE;

        case IDSPB_QUIT507:
          SetODButton((LPDRAWITEMSTRUCT)lParam,0,0,
                              DT_CENTER,THICKNESS);
          return TRUE;

        case IDSPB_MW11:
          SetODButton((LPDRAWITEMSTRUCT)lParam,
                         hBitmapSurvBtn1,0,
                         DT_CENTER,THICKNESS);
          return TRUE;

        default:
          break;
        }
      break;


    case WM_CTLCOLOR:
      type = HIWORD (lParam);
      CtrlID = GetWindowWord (LOWORD (lParam),
                                GWW_ID) ;
      switch (type)
        {
        case CTLCOLOR_DLG:
          return ((DWORD) hBrushBkGndStats);

        case CTLCOLOR_BTN:
          SetBkMode(wParam, TRANSPARENT);
          SetBkColor(wParam, GetSysColor
                                   (COLOR_WINDOW));
          switch(CtrlID)
            {
            case IDSPB_PRINT9:
              SetTextColor(wParam, YELLOW);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushDarkGreen);

            case IDSPB_UPDATE8:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushYellow);

            case IDSPB_QUIT507:
              SetTextColor(wParam, BLUE);
              SelectObject(wParam,hDarkGrayPen);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushRed);

            case IDSPB_MW11:
              SelectObject(wParam,hDarkGrayPen);
              return ((DWORD) hBrushRed);

            default:
              SetTextColor(wParam, GREEN);
              SelectObject(wParam,hFontTimesButton);
              return ((DWORD) hBrushMagenta);
            }

        case CTLCOLOR_STATIC:
          SetBkMode(wParam, TRANSPARENT);
          switch(CtrlID)
            {
            case IDSTAT_401:
              SetTextColor(wParam,RED);
            //  SelectObject(wParam,hFontTimes);
              return ((DWORD) hBrushBkGndStats);

            case IDSTAT_402:
              SetTextColor(wParam,BLUE);
            //  SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndStats);

            case IDSTAT_HEADING:
              SetTextColor(wParam,RED);
              SelectObject(wParam,hFontTimes);
              return ((DWORD) hBrushBkGndStats);

            case IDSTAT_TEXTBLUE:
              SetTextColor(wParam,BLUE);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndStats);

            case IDSTAT_TEXTGREEN:
              SetTextColor(wParam,BLACK);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndStats);

            case IDSTAT_TEXTMAGENTA:
              SetTextColor(wParam,DARKMAGENTA);
              SelectObject(wParam,hFontTimesSmall);
              return ((DWORD) hBrushBkGndStats);

            case IDSTAT_TEXTMAGENTASMALL:
              SetTextColor(wParam,DARKMAGENTA);
              SelectObject(wParam,hFontTimesVerySmall);
              return ((DWORD) hBrushBkGndSurvey);

            case IDSTAT_CATAGORY:
              SetTextColor(wParam,DARKMAGENTA);
              SelectObject(wParam,hFontTimes);
              return ((DWORD) hBrushBkGndStats);

            case IDSEX_HL1: case IDSEX_HL2:
            case IDSEX_HL3: case IDSEX_HL4:
            case IDSEX_HL5: case IDSEX_MWSA6:
            case IDSEX_MWA7: case IDSEX_MWNA8:
            case IDSEX_MWD9: case IDSEX_MWSD10:
            case IDSEX_QCSA11: case IDSEX_QCA12:
            case IDSEX_QCNA13: case IDSEX_QCD14:
            case IDSEX_QCSD15: case IDSEX_HISA16:
            case IDSEX_HIA17: case IDSEX_HINA18:
            case IDSEX_HID19: case IDSEX_HISD20:
            case IDSEX_LUSA21: case IDSEX_LUA22:
            case IDSEX_LUNA23: case IDSEX_LUD24:
            case IDSEX_LUSD25: case IDSEX_NISA26:
            case IDSEX_NIA27: case IDSEX_NINA28:
            case IDSEX_NID29: case IDSEX_NISD30:
            case IDSEX_HUSA31: case IDSEX_HUA32:
            case IDSEX_HUNA33: case IDSEX_HUD34:
            case IDSEX_HUSD35: case IDSEX_HBSA36:
            case IDSEX_HBA37: case IDSEX_HBNA38:
            case IDSEX_HBD39: case IDSEX_HBSD40:
            case IDSEX_OVSA41: case IDSEX_OVA42:
            case IDSEX_OVNA43: case IDSEX_OVD44:
            case IDSEX_OVSD45:
              SetTextColor(wParam, BLUE);
              return ((DWORD) hBrushBkGndStats);

            case IDSEX_HL1PC: case IDSEX_HL2PC:
            case IDSEX_HL3PC: case IDSEX_HL4PC:
            case IDSEX_HL5PC: case IDSEX_MWSA6PC:
            case IDSEX_MWA7PC: case IDSEX_MWNA8PC:
            case IDSEX_MWD9PC: case IDSEX_MWSD10PC:
            case IDSEX_QCSA11PC: case IDSEX_QCA12PC:
            case IDSEX_QCNA13PC: case IDSEX_QCD14PC:
            case IDSEX_QCSD15PC: case IDSEX_HISA16PC:
            case IDSEX_HIA17PC: case IDSEX_HINA18PC:
            case IDSEX_HID19PC: case IDSEX_HISD20PC:
            case IDSEX_LUSA21PC: case IDSEX_LUA22PC:
            case IDSEX_LUNA23PC: case IDSEX_LUD24PC:
            case IDSEX_LUSD25PC: case IDSEX_NISA26PC:
            case IDSEX_NIA27PC: case IDSEX_NINA28PC:
            case IDSEX_NID29PC: case IDSEX_NISD30PC:
            case IDSEX_HUSA31PC: case IDSEX_HUA32PC:
            case IDSEX_HUNA33PC: case IDSEX_HUD34PC:
            case IDSEX_HUSD35PC: case IDSEX_HBSA36PC:
            case IDSEX_HBA37PC: case IDSEX_HBNA38PC:
            case IDSEX_HBD39PC: case IDSEX_HBSD40PC:
            case IDSEX_OVSA41PC: case IDSEX_OVA42PC:
            case IDSEX_OVNA43PC: case IDSEX_OVD44PC:
            case IDSEX_OVSD45PC:
              SetTextColor(wParam, RED);
              return ((DWORD) hBrushBkGndStats);


            default:
              SetTextColor(wParam, DARKGREEN);
              SetBkMode(wParam, TRANSPARENT);
              return ((DWORD) hBrushBkGndStats);
            }

        default:

          SetTextColor(wParam, BLUE);
          SetBkMode(wParam, TRANSPARENT);
          return ((DWORD) hBrushBkGndStats);
        }



      case WM_COMMAND:
        switch ( wParam )
          {
          case IDSPB_UPDATE8:
            MakeStats(hDlg);
            break;


          case IDSPB_MW11:
            if(!hDlgGraph)
            hDlgGraph = CreateDialog (hInst, "Graph",
                          NULL, lpfnGraphDlgProc);
            break;


          case IDSPB_PRINT9:
            break;

          case IDSPB_QUIT507:
            SendMessage( hDlg, WMS_CLOSE, 0, 0L );
            break;

          default:
            return FALSE;
          }
        break;

      case WMS_CLOSE:
            /* Send a WM_DESTROY message. */
        DeleteObject (hBitmapBkGndStats);
        DeleteObject(hBrushBkGndStats);
        DeleteObject(hBitmapSurvBtn1);
        DestroyWindow( hDlg );
        hDlgStatistics= 0;
        break;


      default:
            return FALSE;
    }

    return FALSE;
  }



void MakeStats(HWND hDlg)
  {
  char buf[MAXFIELDSIZE];
  int i,j,k, tot;

    // MAKE FAKE STAT DATA AREA
  for (i=0;i<nFields;i++)
    statdata[i].itemtot = fakedataStats[i];

// GET PRESENT REC NUMBER ASSUMED TO BE FORMS TOTAL

  tot= 24;
  itoa((int)tot,buf,10);
  SetDlgItemText( hDlgStatistics, IDSEX_RECNO403,
                                              buf );

// make ave. and display

  for (j=0;j<nFields;j++)
    {
    statdata[j].itemave = 100*statdata[j].
                                     itemtot/tot;
    k = j + 1101;
    wsprintf((LPSTR)buf,"%3ld",statdata[j].itemtot);
    SetDlgItemText(hDlgStatistics, k, buf );
    wsprintf((LPSTR)buf,"/%2ld",statdata[j].itemave);
    k = j + 1201;
    SetDlgItemText(hDlgStatistics, k, buf );
    }
  }



void PaintStats(HWND hDlg)
  {
  char buf[MAXFIELDSIZE];
  int i,j,k,tot=24;

  for (i=0;i<nFields;i++)
    statdata[i].itemtot = fakedataStats[i];

// make ave. and display

  for (j=0;j<nFields;j++)
    {
    statdata[j].itemave = 100*statdata[j].itemtot
                                              /tot;
    k = j + 1101;
    wsprintf((LPSTR)buf,"%3ld",statdata[j].itemtot);
    SetDlgItemText(hDlgStatistics, k, buf );
    wsprintf((LPSTR)buf,"/%2ld",statdata[j].itemave);
    k = j + 1201;
    SetDlgItemText(hDlgStatistics, k, buf );
    }
  }


