/*  PMDDE.C
    Pete Davis
    Windows Programmer's Journal
    Volume 1 Number 1
    Copyright 1992

    This is the Program Manager DDE Window procedure.

*/

#include <windows.h>
#include "install.h"   /* Not included with WPJV1N1 */


long FAR PASCAL DDEWndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
   LPSTR           Command, TStr;      /* Used for building user commands */
   HANDLE          MemStuff;           /* Same as above                   */
   static BOOL     FirstAck;           /* Is the WM_DDE_ACK for the INIT? */
   ATOM            Topic, Application; /* Our PROGMAN Topic and App. atoms*/
   static HWND     hProgman;           /* Handle for Program Manager.     */

   switch(message)
   {

        case WM_CREATE:
                /* make sure that first Ack grabs hProgman */
                FirstAck    = TRUE;                   

                /* Setup Application and Topic atoms */
                Application = GlobalAddAtom("PROGMAN");
                Topic       = GlobalAddAtom("PROGMAN");

                /* Initiate the DDE conversation */
                SendMessage(-1,WM_DDE_INITIATE, hWnd, MAKELONG(Application, Topic));

                /* Don't need our atoms anymore */
                GlobalDeleteAtom(Application);
                GlobalDeleteAtom(Topic);
                break;


        case WM_DDE_ACK:
                if(FirstAck)    /* Gotta get hProgman */
                {
                        /* We only handle the DDE_ACK this way once. */
                        FirstAck=FALSE

                        /* Get rid of Program Manager's atoms. These are
                           set by Program Manager as to it's topic and
                           application. We already know what they are. */
                        GlobalDeleteAtom(LOWORD(lParam));
                        GlobalDeleteAtom(HIWORD(lParam));

                        /* Get the handle for Program Manager */
                        hProgman = wParam;
                }
                else
                {
                        /* Kill anything it's trying to return */
                        if (HIWORD(lParam))
                                GlobalFree(HIWORD(lParam));

                }
                break;

        case WM_CREATE_PMGRP:
                /* Just assume 80 chars as max for our string. */
                /* Allocate the block                          */
                MemStuff =GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE, 80);

                /* Lock it so we can use it */
                Command = GlobalLock(MemStuff);
                
                /* Set up our Program Manager Command */
                lstrcpy(Command, "[CREATEGROUP(");

                /* Get the users program group name */
                TStr = GlobalLock(wParam);

                /* Finish building Command */
                lstrcat(Command, TStr);
                lstrcat(Command, ")]");

                /* Unlock it so we can pass it off to Program Manager */
                GlobalUnlock(MemStuff);

                /* Have Program Manager execute the command */
                PostMessage(hProgman, WM_DDE_EXECUTE, hWnd, MAKELONG(0,MemStuff));

                /* Bang, we're done here */
                break;


        case WM_ADD_ITEM:
                /* Comments are the same as last message */
                MemStuff =GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE, 80);
                Command = GlobalLock(MemStuff);
                lstrcpy(Command, "[ADDITEM(");
                TStr = GlobalLock(wParam);
                lstrcat(Command, TStr);
                lstrcat(Command, ")]");
                GlobalUnlock(MemStuff);
                PostMessage(hProgman, WM_DDE_EXECUTE, hWnd, MAKELONG(0,MemStuff));
                break;


        /* And to end the DDE session */
        case WM_END_DDE:
                PostMessage(hProgMan, WM_DDE_TERMINATE, hWnd, 0L);
                break;

        default:
                return DefWindowProc(hWnd, message, wParam, lParam);
        }
        return(0L);
}

