/***************************************************************************
* EXAMPL6.C
* Simple graphics demo
* ****************************************************************************/
#ifdef NOWINDOWS
#include "borgraph.h"
#include <stdio.h>
#include <conio.h>
#else
#include <WinDosIO.h>
#endif
#include <stdlib.h>
#include <memory.h>

char userFill[] = {0x18,0x7e,0x42,0xc3,0xc3,0x42,0x7e,0x18};
short currentHandle;
int gdriver = VGA,gmode=VGAMED;
int midx, midy, x, y;
int poly[8];
int i,j;
int size;
char *bitmap;
char msg[80];
int hj, vj;
char *hjust[] = {"LEFT","CENTER","RIGHT"};
char *vjust[] = {"BOTTOM","CENTER","TOP"};
struct arccoordstype ac;

main()
  {
#ifndef NOWINDOWS
	WinDosIO(WD_SETTITLE,0,(long)"Graphics Demo");
#endif
	initgraph(&gdriver, &gmode, "");
	if (x = graphresult())
	  {
		printf("init graph error %d",x);
		getch();
		exit(1);
   	  }
	midx = getmaxx()/2;
	midy = getmaxy()/2;

	for (i = 0; i < 5; i++)
	 {
		for (j = 1; j < 10; j++)
		 {
			settextstyle(i,0,j);
			outtextxy(j * 40, i * 40,"A");
		 }
	 }
	if (getch() < 0) return -1;
	cleardevice();

	settextstyle(TRIPLEX_FONT,HORIZ_DIR,4);
	moveto(0, midy);
	outtext("Normal ");
	printf("AAA");
	settextstyle(TRIPLEX_FONT,HORIZ_DIR,0);
	setusercharsize(1,3,1,1);
	outtext("Short ");
	setusercharsize(3,1,1,1);
	outtext("Wide ");
	if (getch() < 0) return -1;
	cleardevice();
	outtextxy(80,90,"This text should go over the view port");
	setviewport(90,90,180,180,1);
	setcolor(4);
        outtextxy(0, 0, "This is a test, a test, yes a test.");
	setcolor(1);
	if (getch() < 0) return -1;
	clearviewport();
	if (getch() < 0) return -1;
        outtextxy(0, 0, "This is a test, a test, yes a test.");
	if (getch() < 0) return -1;
	setgraphmode(gmode);
	setactivepage(1);
	setcolor(2);
        outtextxy(midx, midy+40, "This is a test, a test, yes a test.");
	setcolor(3);
        outtextxy(midx, midy+60, "This is a test, a test, yes a test.");
	setactivepage(0);
	outtextxy(10,10,"Hit any key to see page #1");
	if (getch() < 0) return -1;
	setvisualpage(1);
	if (getch() < 0) return -1;
	setactivepage(1);
	/* Place grid in upper corner */
	for (x = 0; x < midx; x+= 10)
	 {
		moveto(x,0);
		lineto(x,midy);
	 }
	setwritemode(XOR_PUT); /* Cause intersections to show */
	setlinestyle(SOLID_LINE,0,THICK_WIDTH);
	for (y = 0; y < midy; y+= 10)
	 {
		moveto(0,y);
		lineto(midx,y);
	 }
	size = imagesize(10,10,40,50);
	bitmap = malloc(size);
	getimage(10,10,40,50,bitmap); 

	setwritemode(COPY_PUT);
	circle(midx+60,60,10);
	circle(midx+60,60,13);
	circle(midx+60,60,16);
	circle(midx+60,60,19);
	circle(midx+60,60,22);
	rectangle(midx+35,35,midx+85,85);
	if (getch() < 0) return -1;
	restorecrtmode();
	gotoxy(2,2);
	cprintf("Now in text mode");
	if (getch() < 0) return -1;
	setgraphmode(gmode);
	outtextxy(50,50,"Back in graphics mode");
	setviewport(130,130,230,230,1);
	circle(10,10,10);
	if (getch() < 0) return -1;
#ifndef NOWINDOWS
	WinDosIO(WD_DEFERPAINT,1,0);
#endif
	for (i = 0; i < 1000; i++)
	 {
		putpixel(random(100), random(100), random(16));
	 }
#ifndef NOWINDOWS
	WinDosIO(WD_DEFERPAINT,0,0);
#endif
	if (getch() < 0) return -1;
	setgraphmode(gmode);
	setbkcolor(EGA_YELLOW);
	bar3d(20,midy,40,midy+40,10,1);
	setfillstyle(SOLID_FILL,1);
	bar3d(60,midy,80,midy+40,20,0);
	setfillstyle(LINE_FILL,1);
	bar3d(100,midy,120,midy+40,30,1);
	setfillstyle(LTSLASH_FILL,1);
	bar(140,midy,160,midy+40);
	setfillstyle(SLASH_FILL,1);
	bar(180,midy,200,midy+40);
	setfillstyle(BKSLASH_FILL,1);
	bar(220,midy,240,midy+40);
	setfillstyle(LTBKSLASH_FILL,1);
	bar(260,midy,280,midy+40);
	setfillstyle(HATCH_FILL,1);
	bar(300,midy,320,midy+40);
	setfillstyle(XHATCH_FILL,1);
	bar(340,midy,360,midy+40);
	setfillstyle(INTERLEAVE_FILL,1);
	bar(380,midy,400,midy+40);
	setfillstyle(WIDE_DOT_FILL,1);
	bar(420,midy,440,midy+40);
	setfillstyle(CLOSE_DOT_FILL,1);
	bar(460,midy,480,midy+40);
	setfillpattern(userFill,1);
	bar(500,midy,520,midy+40);
	if (getch() < 0) return -1;
	setbkcolor(2);
	arc(midx-5,midy-5,2,45,10);
	arc(midx-5,midy-5,20,80,20);
	arc(midx-5,midy-5,20,120,30);
	getarccoords(&ac);
	moveto(ac.xstart,ac.ystart);
	lineto(200,200);
	moveto(ac.xend,ac.yend);
	lineto(ac.x, ac.y);
	pieslice(midx+20,midy+50,0,30,50);
	ellipse(midx+100,midy+100,45,135,60,30);
	fillellipse(midx-100,midy-100,80,20);
	sector(midx-100,midy+100,135,200,40,80);
	if (getch() < 0) return -1;
	cleardevice();
	poly[0] = 20;
	poly[1] = getmaxy() / 2;
	poly[2] = getmaxx() - 20;
	poly[3] = 20;
	poly[4] = getmaxx() - 50;
	poly[5] = getmaxy() - 20;
	poly[6] = getmaxx() / 2;
	poly[7] = getmaxy() / 2;
	for (i = EMPTY_FILL; i < USER_FILL; i++)
	 {
		setfillstyle(i, getmaxcolor());
		fillpoly(4, poly);
		putimage(200,100,bitmap,COPY_PUT);
		if (getch() < 0) return -1;
	 }
	circle(50,50,40);
	setfillstyle(SOLID_FILL,4);
	floodfill(50,50,getmaxcolor());
	outtextxy(300,50,getdrivername());
	outtextxy(350,60,getmodename(0));
	outtextxy(350,80,getmodename(1));
	outtextxy(350,100,getmodename(2));
	if (getch() < 0) return -1;
	cleardevice();
	for (hj = LEFT_TEXT; hj <= RIGHT_TEXT; hj++)
	  for (vj = BOTTOM_TEXT; vj <= TOP_TEXT; vj++)
	   {
		cleardevice();
		settextjustify(hj, vj);
		sprintf(msg,"%s-%s", hjust[hj], vjust[vj]);
		line(midx-4, midy, midx+4, midy);
		line(midx, midy - 4, midx, midy + 4);
		outtextxy(midx, midy, msg);
		if (getch() < 0) return -1;
	   }
	closegraph();
	return 0;
 }
