/***************************************************************************
* EXAMPL4.C
* A dumb screen editor
* ****************************************************************************/

#include <Windows.h>
#include <WinDosIO.h>


long far pascal WndProc(HWND, WORD, WORD, LONG);

short currentHandle;
HWND idWindow;
HANDLE hInst;
short isText;
short saved;

#define F1	59
#define F2	60
#define F3	61
#define F4	62
#define F5	63
#define F6	64
#define F7	65

#define CURUP	72
#define CURDWN	80
#define CURLEFT 75
#define CURRIT  77
#define HOME	71
#define END	79
#define INS	82
#define DEL	83

char saveBuffer[4096];
short getkey(void);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdline, int cmdshow)
 {
	HWND hwnd;
	WNDCLASS wc;
	RECT r;
	MSG msg;

	/* Register Main Window Class */

	hInst = hInstance;

	if (!hPrevInstance)
	 {
	    wc.style = 0;
	    wc.lpfnWndProc = WndProc;
	    wc.cbClsExtra = 0;
	    wc.cbWndExtra = 0;
	    wc.hInstance = hInstance;
	    wc.hIcon = LoadIcon( 0, IDI_APPLICATION );
	    wc.hCursor = LoadCursor( 0, IDC_ARROW );
	    wc.hbrBackground = COLOR_WINDOW + 1;
	    wc.lpszMenuName = "Example5";
	    wc.lpszClassName = "Example5";
	    RegisterClass( &wc );
	 }


    /* Initialize terminal IO */
    WinDosIO(WD_INIT,hInstance,0);

	/* Create Main Window */
    hwnd = CreateWindow(
                "Example5",
                "A Very Dumb Screen Editor",
                (WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME),
                CW_USEDEFAULT,
                0,
                CW_USEDEFAULT,
                0,
                0,
                0,
                hInstance,
                NULL
                );

    ShowWindow(hwnd, cmdshow);

	/* Create menu window */
	r.top = 0;
	r.left = 0;
	idWindow = CreateWindow("termIO","Edit Window",
			  WS_CHILD ,
			  r.left,r.top,640,360,
			  hwnd,20,hInstance,0);
	ShowWindow(idWindow,SW_SHOW);
	UpdateWindow(idWindow);

	textcolor(LIGHTBLUE);
	gotoxy(1,26);
	printf("F1-HVideo F2-LVideo F3-80c F4-40c F5-Save F6-Rest F7-Copy");
	window(1,1,80,25);
	textcolor(WHITE);
	textbackground(BLACK);
	gotoxy(1,1);
	for(;;)
         {
	    short k = getkey();
	    if (k < 0) break;
	    switch (k)
	     {
		   case CURDWN:
			if (wherey() < 25) gotoxy(wherex(),wherey()+1);
		        break;
		   case CURUP:
			if (wherey() > 1) gotoxy(wherex(),wherey()-1);
		        break;
		   case CURLEFT:
			if (wherex() > 1) gotoxy(wherex()-1,wherey());
			break;
		   case CURRIT:
			if (wherex() < 80) gotoxy(wherex()+1,wherey());
			break;
		   case HOME:
			gotoxy(1,1);
	 	        break;
		   case END:
			gotoxy(80,25);
		        break;
		   case INS:
			insline();
			break;
		   case DEL:
			delline();
			break;
		   case F1:
			highvideo();
			break;
		   case F2:
			lowvideo();
			break;
		   case F3:
			textmode(C80);
			window(1,1,80,25);
			break;
		   case F4:
			textmode(C40);
			window(1,1,80,25);
			break;
		   case F5:
			saved = 1;
			gettext(1,1,80,25,saveBuffer);
			break;
		   case F6:
			if (saved)
 			  puttext(1,1,80,25,saveBuffer);
			break;
		   case F7:
			movetext(5,1,10,2,wherex(),wherey());
			break;
		   default:
			if (isText)
			  {
				char ch = k - 256;
				putchar(ch);
			  }
			break;
		}
	 }
	closegraph();
	while( GetMessage( &msg, 0, 0, 0 ) != 0 )
     	{
		TranslateMessage( &msg );
		DispatchMessage( &msg );
     	}

	return 0;
 }

short getkey(void)
 {
	int k = getch();
	isText = 1;
	if (!k)
	 {
	   isText = 0;
  	   return getch();
	 }
	if (k > 0)
		return k + 256;
	else	return k;
 }

long far pascal WndProc(HWND hwnd, WORD msg, WORD wParam, LONG lParam)
 {

    switch( msg )
        {
	case WM_COMMAND:
		break;
	case WM_SETFOCUS:
		WinDosIO(WD_SETFOCUS,0,0);
		break;
	case WM_CLOSE:
	        WinDosIO(WD_DESTROY,hwnd,0);
		return 0;
        case WM_DESTROY:
		PostQuitMessage(0);
	        return 0;
        }

	return DefWindowProc(hwnd,msg,wParam,lParam);
}


