#ifndef __DISKDRIV_H__
#define __DISKDRIV_H__

#include "HandleSt.h"

#define AUTOMATIC  1
#define NEVER      2
#define ALWAYS     3
#define FAST       4

#ifdef __cplusplus
extern "C" {
#endif /* _cplusplus */

VOID far * FAR PASCAL DiskDriveCreateDrive  ( char cDrive, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateFile   ( LPCSTR lpczFileName, LPCSTR lpczApplicationTitle, LPCSTR lpczVersion, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateMemory ( UINT nMemory, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID far * FAR PASCAL DiskDriveCreateVDrive ( VOID far *pCVDriveNew, UINT nType, UINT nCylinders, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
VOID       FAR PASCAL DiskDriveDelete ( VOID far *pCDiskDrive ) ;

VOID       FAR PASCAL DiskDriveCopy ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;
BOOL       FAR PASCAL DiskDriveCompare ( VOID far *pCDiskDrive, VOID far *pCDiskDriveSource ) ;

UINT       FAR PASCAL DiskDriveForceReset     ( VOID far *pCDiskDrive ) ;
BOOL       FAR PASCAL DiskDriveHasData        ( VOID far *pCDiskDrive ) ;
BOOL       FAR PASCAL DiskDriveIsTruncated    ( VOID far *pCDiskDrive ) ;
char       FAR PASCAL DiskDriveLetter         ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveReset          ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveSetRead        ( VOID far *pCDiskDrive, UINT nTempType, UINT nCylinders ) ;
VOID       FAR PASCAL DiskDriveSetType        ( VOID far *pCDiskDrive, UINT nNewType ) ;
UINT       FAR PASCAL DiskDriveSetWrite       ( VOID far *pCDiskDrive, UINT nTempType, UINT nCylinders ) ;
UINT       FAR PASCAL DiskDriveType           ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedCylinders  ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedHeads      ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedSectors    ( VOID far *pCDiskDrive ) ;
UINT       FAR PASCAL DiskDriveUsedSectorSize ( VOID far *pCDiskDrive ) ;

UINT       FAR PASCAL DiskDriveFormat       ( VOID far *pCDiskDrive, LPCSTR lpczVolumeSerial, BOOL bQuick, LPBYTE lpbyBootSector, lpfnHANDLESTATUS lpfnHandleStatus ) ;
UINT       FAR PASCAL DiskDriveFormatTrack  ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveReadSectors  ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;
UINT       FAR PASCAL DiskDriveWriteSectors ( VOID far *pCDiskDrive, UINT nCylinders, UINT nHead, UINT nSector, UINT nCount, LPBYTE lpcBuffer, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;

VOID       FAR PASCAL DiskDriveGetVolumeSerial ( VOID far *pCDiskDrive, LPSTR  lpczOldVolumeSerial ) ;
BOOL       FAR PASCAL DiskDriveSetVolumeSerial ( VOID far *pCDiskDrive, LPCSTR lpczNewVolumeSerial ) ;

VOID       FAR PASCAL DiskDriveSetWriteFormatOption ( VOID far *pCDiskDrive, UINT nWriteFormatOptionNew ) ;
VOID       FAR PASCAL DiskDriveSetWriteVerifyOption ( VOID far *pCDiskDrive, BOOL bWriteVerifyOptionNew ) ;

VOID       FAR PASCAL DiskDriveTruncate        ( VOID far *pCDiskDrive ) ;
VOID       FAR PASCAL DiskDriveTruncateReverse ( VOID far *pCDiskDrive ) ;

BOOL       FAR PASCAL DiskDriveWriteBootSector ( VOID far *pCDiskDrive, LPBYTE lpbyModelBootSector, lpfnHANDLESTATUS lpfnNewHandleStatus ) ;

#ifdef __cplusplus
           }
#endif /* __cplusplus */

#endif /* __DISKDRIV_H__ */


