/*
                    Windows Multitasking Demo by Mark Gamber
*/


#include "windows.h"
                                                    //  Lazy man's INCLUDE file
BOOL WINAPI MtaskDlgProc( HWND, UINT, UINT, LONG );
BOOL WINAPI NoFocusDlgProc( HWND, UINT, UINT, LONG );
BOOL WINAPI FocusOkDlgProc( HWND, UINT, UINT, LONG );


HANDLE hInst;


int PASCAL WinMain( HANDLE hInstance, HANDLE hPrev, LPSTR lpCmd, int nShow )
{
   hInst = hInstance;
   DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, MtaskDlgProc );
   return( FALSE );
}

                                           //  Dialog box acting as main window

BOOL WINAPI MtaskDlgProc( HWND hDlg, UINT msg, UINT wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
         return( TRUE );

      case WM_COMMAND:
      {
         if( wParam == IDCANCEL || wParam == 102 )
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         if( wParam == 100 )
         {
            DialogBox( hInst, MAKEINTRESOURCE( 10001 ), hDlg, NoFocusDlgProc );
            break;
         }
         if( wParam == 101 )
         {
            DialogBox( hInst, MAKEINTRESOURCE( 10002 ), hDlg, FocusOkDlgProc );
            break;
         }
         break;
      }
   }
   return( FALSE );
}


//  NoFocusDlgProc() uses a timed loop which lets other applications run but
//      doesn't allow the user to change focus.

BOOL WINAPI NoFocusDlgProc( HWND hDlg, UINT msg, UINT wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:                       //  Dialog box creation message
      {
         DWORD dwTime;
         int Total, OldTotal;
         char str[ 40 ];

         ShowWindow( hDlg, SW_SHOW );     //  Make sure dialog box is displayed
         UpdateWindow( hDlg );

         dwTime = GetTickCount() + 20000L;    //  Get value of 20 secs from now
         OldTotal = -1;
         while( dwTime > GetTickCount() )      //  Loop until 20 seconds are up
         {                                                //  Get relative time
            Total = (int)( ( dwTime - GetTickCount() ) / 1000L );
            if( Total != OldTotal )                   //  If one second elapsed
            {
               wsprintf( str, "Time Remaining: %d Seconds", Total );
               SetDlgItemText( hDlg, 1000, str );
               UpdateWindow( GetDlgItem( hDlg, 1000 ) );  //  Display time left
               OldTotal = Total;
            }
            Yield();                                 //  Let something else run
         }
         SetDlgItemText( hDlg, 1000, "TEST DONE" );
         MessageBeep( -1 );
         return( TRUE );
      }

      case WM_COMMAND:
         if( wParam == IDCANCEL || wParam == IDOK )
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}


//  FocusOkDlgProc() allows other applications to run while in it's timed loop
//       and allows the user to change focus to another application

BOOL WINAPI FocusOkDlgProc( HWND hDlg, UINT msg, UINT wParam, LONG lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
      {
         DWORD dwTime;
         MSG msg;
         char str[ 40 ];
         int Total, OldTotal;

         ShowWindow( hDlg, SW_SHOW );         //  Make sure dialog is displayed
         UpdateWindow( hDlg );
         dwTime = GetTickCount() + 20000L;             //  Get 20 second offset

         OldTotal = -1;
         while( dwTime > GetTickCount() )      //  While waiting for 20 seconds
         {
            Total = (int)( ( dwTime - GetTickCount() ) / 1000L );
            if( Total != OldTotal )               //  If one second has elapsed
            {                                        //  Display time remaining
               wsprintf( str, "Time Remaining: %d Seconds", Total );
               SetDlgItemText( hDlg, 1000, str );
               UpdateWindow( GetDlgItem( hDlg, 1000 ) );
               OldTotal = Total;
            }
            if( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
            {
               TranslateMessage( &msg );  //  This little chunk of code is what
               DispatchMessage( &msg );                //  lets other stuff run
            }
         }
         SetDlgItemText( hDlg, 1000, "TEST DONE" );
         MessageBeep( -1 );
         return( TRUE );
      }

      case WM_COMMAND:
         if( wParam == IDCANCEL || wParam == IDOK )
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}


