/* This file provides definitions for the C source and resource scripts
   for support of operation under the Microsoft Windows environment on
   an IBM-PC or compatible computer.

   Must be compiled with Borland C++ 2.0 or later version.

   It should not be compiled if the WINDOW_MSWIN symbol is not set */

/* compile flags */
#define BLOCKCARET  1   /* 1 to have a cell-sized caret when within a
			   screen, 0 for a vertical bar */
#define SUBALLOC    0   /* implement malloc/free/realloc by segment
			   suballocation routines (needed for Borland C
			   2.0, but not necessary under Borland C 3.0)
			   */
#define MEMTRACE    1   /* adds a debugging trace to mswmem.c */

/* some tricks to avoid conflicts with estruct.h ... */
#undef  FAR
#undef  PASCAL
#undef  NEAR
#undef  HIBYTE
#undef  CDECL
#undef  VOID
#define BITMAP MSWBMP   /* to avoid type redefinition */

#include    <windows.h>

#include    "mswrid.h"  /* contains all the Resource IDs */

/* macros */
#define MLSIZE  NSTRING         /* message line buffer size */

/* offsets for the screen windows extra bytes */
#define GWL_SCRPTR  0                   /* SCREEN structure pointer */
#define GWW_SCRCX   (GWL_SCRPTR+sizeof(LONG))   /* client area width */
#define GWW_SCRCY   (GWW_SCRCX+sizeof(WORD))       /* client area height */
#define SCRWNDEXTRA (GWW_SCRCY+sizeof(WORD))

/* offsets for the frame window extra bytes */
#define GWW_FRMID   0                   /* Id seen by other emacs apps */
#define FRMWNDEXTRA (GWW_FRMID+sizeof(WORD))

/* structures */
typedef struct  CellMetrics {   /* coordinate-related parameters of a font */
    short   OffsetX, OffsetY;  /* offset of column 0 or row 0, relative
				  to the client area upper left corner */
    short   LeadingY, HalfLeadingY; /* external leading between rows */
    short   SizeX, SizeY;       /* character cell size */
    short   MLHeight;           /* height of the message line */
} CellMetrics;

#ifdef  termdef     /* in mswdrv.c only */
char    ProgName [] = PROGNAME;
int     CurrentRow = 0;
int     CurrentCol = 0;
BOOL    MouseTracking = FALSE;
BOOL    InternalRequest = FALSE;

/* Global uninitialized variables */
HWND    hFrameWnd;          /* main (frame) window */
HWND    hMDIClientWnd;      /* MDI client window */
HANDLE  hEmacsInstance;     /* module instance */
DWORD   WinFlags;           /* windows memory configuration */
HCURSOR hScreenCursor, hTrackCursor, hNotQuiescentCursor, hHourglass;
char    *ScreenClassName;   /* MDI childs class name */
char    *MLBuf;             /* message line buffer */
HFONT   hEmacsFont;         /* font used for display */
CellMetrics     EmacsCM;    /* cell metrics of that font */

char    *MainHelpFile;      /* Emac's help file name and useage flag */
BOOL    MainHelpUsed;

char    HelpEngineFile [NFILEN];/* user help file and useage flag */
BOOL    ColorDisplay;       /* TRUE if the display is color-capable */
#else
extern char ProgName [];    /* used all over the place for captions,
			       etc... */
extern int  CurrentRow;
extern int  CurrentCol;     /* caret positions (in text coordinates) */
extern BOOL MouseTracking;  /* TRUE if mouse in tracking/dragging mode */
extern BOOL InternalRequest;
    /* TRUE for a request that originates from the mswxxx modules. This
       is meant to avoid infinite recursions for requests that could
       come from both MS-Windows or the editor's core (for instance
       resizing, screen activation...) */

/* Global uninitialized variables */
extern HWND    hFrameWnd;          /* main (frame) window */
extern HWND    hMDIClientWnd;      /* MDI client window */
extern HANDLE  hEmacsInstance;     /* module instance */
extern DWORD   WinFlags;           /* windows memory configuration */
extern HCURSOR hScreenCursor, hTrackCursor, hNotQuiescentCursor, hHourglass;
extern char    *ScreenClassName;   /* MDI childs class name */
extern char    *MLBuf;             /* message line buffer */
extern HFONT   hEmacsFont;         /* font used for display */
extern CellMetrics     EmacsCM;    /* cell metrics of that font */

extern char    *MainHelpFile;      /* Emac's help file name and useage flag */
extern BOOL    MainHelpUsed;

extern char    HelpEngineFile [NFILEN];/* user help file and useage flag */
extern BOOL    ColorDisplay;       /* TRUE if the display is color-capable */
#endif

/* input stream access functions */
void in_init (void);
BOOL in_room (int n);
BOOL in_check (void);
void in_put (int event);
int  in_get (void);

/* Windows-implementation specific functions */
LONG EXPORT far pascal ScrWndProc (HWND hWnd, WORD wMsg, WORD wParam,
				   LONG lParam);
LONG EXPORT far pascal FrameWndProc (HWND hWnd, WORD wMsg, WORD wParam,
				     LONG lParam);
int far pascal GetInput (void);
int far pascal TakeANap (int t);

void far pascal InitMenuPopup (HMENU hMenu, DWORD lParam);
BOOL far pascal MenuCommand (WORD wParam, DWORD lParam);
HMENU far pascal GetScreenMenuHandle (void);

BOOL far pascal EatKey (WORD MsgCode, WORD Key, DWORD lParam);
void far pascal MouseMessage (HWND hWnd, WORD wMsg, WORD wParam, DWORD lParam);

void far pascal BuildCellMetrics (CellMetrics *cm, HFONT hFont);
void far pascal InvalidateCells (HWND hWnd, int leftcol, int toprow,
                                 int rightcol, int bottomrow);
void far pascal MinimumClientSize (HWND hWnd, int NCols, int NRows,
				   int *Width, int *Height);
int far pascal DisplayableRows (HWND hWnd, int Height, CellMetrics *cm);
int far pascal DisplayableColumns (HWND hWnd, int Width, CellMetrics *cm);
void far pascal EmacsCaret (BOOL Show);
void far pascal MoveEmacsCaret (HWND hWnd, int col, int row);
void far pascal ShowEmacsCaret (BOOL Show);
void far pascal CellToClient (HWND hWnd, POINT Cell, LPPOINT Client);
void far pascal ClientToCell (HWND hWnd, POINT Client, LPPOINT Cell);
void far pascal GetMinMaxInfo (HWND hWnd, LPPOINT rgpt);
BOOL far pascal ScrReSize (HWND hWnd, WORD wParam, WORD cx, WORD cy);
void far pascal ScrPaint (HWND hWnd);
void far pascal MLPaint (void);

BOOL far pascal InMessageLine (void);

void far pascal ClipboardCleanup (void);

int far pascal SetWorkingDir (void);

void far pascal InitializeFarStorage (void);
void far pascal JettisonFarStorage (void);

HFONT far pascal SelectFont (HDC hDC, HFONT hFont);
BOOL far pascal PickEmacsFont (void);
void far pascal FontInit (void);
