/* The routines in this file provide extra emacs functions available
   under the Microsoft Windows environment on an IBM-PC or compatible
   computer. The following functions are supplied: cutregion,
   clipregion, insertclip and helpengine.

   Must be compiled with Borland C++ 2.0 or later version.

   It should not be compiled if the WINDOW_MSWIN symbol is not set */

#include    "estruct.h"
#include    <stdio.h>
#include    "eproto.h"
#include    "edef.h"
#include    "elang.h"

#include    "mswin.h"

static HANDLE   hClipData = NULL;   /* used by insertclip and
				       ClipboardCleanup */

/* CopyToClipboard: internal function to copy region to clipboard */
/* ===============                                                */

static BOOL pascal near CopyToClipboard (REGION *Region)
{
    long    Size = 0L;
    HANDLE  hData;
    char huge *Data;
    BOOL    Result = TRUE;
    register LINE *lp;
    register int Offset;
    register int lcnt;       /* used to reduce longop() overhead */
    
    /*-figure out the size of the clipboard data (end of lines have to
       be turned into CR-LF) */
    Size = Region->r_size;
    if (curwp->w_dotp != curwp->w_markp[0]) {   /* multiple lines */
        lp = Region->r_linep;
        do {
            ++Size;
	    lp = lforw(lp);
	} while ((lp != curwp->w_dotp) && (lp != curwp->w_markp[0]));
    }
    if (Size == 0L) return TRUE;

    /*-copy the buffer data into a block of global memory */
    if (hData = GlobalAlloc (GMEM_MOVEABLE, Size + 1)) {
        if (!(Data = GlobalLock (hData))) goto NoClipboardMemory;
	lp = Region->r_linep;
	Offset = Region->r_offset;
	lcnt = 0;
	while (Size-- > 0) {
	    if (Offset != llength(lp)) {    /* middle of line */
	        *Data++ = lgetc(lp, Offset);
	        ++Offset;
	    }
	    else {                          /* end of line */
	        *Data++ = '\r';
	        *Data++ = '\n';
	        Size--;
	        lp = lforw(lp);
	        Offset = 0;
	        if (--lcnt < 0) {
		    longop (TRUE);
		    lcnt = 10;  /* reduce longop calls overhead */
		}
	    }
	}
	*Data = '\0';
	/*-pass the text to the clipboard */
	GlobalUnlock (hData);
	if (OpenClipboard (hFrameWnd)) {
	    if (EmptyClipboard ()) {
	        SetClipboardData (CF_TEXT, hData);
	    }
	    else Result = FALSE;
	    CloseClipboard ();
	}
	else Result = FALSE;
	if (Result == FALSE) GlobalFree (hData);
    }
    else {
NoClipboardMemory:
	mlabort (TEXT94);   /* out of memory */
        Result = FALSE;
    }
    return Result;
} /* CopyToClipboard */

/* cutregion:   move the current region to the clipboard */
/* =========                                             */

PASCAL cutregion (int f, int n)
{
    REGION  Region;
    int     Result;

    /*-don't allow command if read-only mode */
    if (curbp->b_mode & MDVIEW) return rdonly();

    if ((Result = getregion (&Region)) != TRUE) return Result;

    if ((Result = CopyToClipboard (&Region)) != TRUE) return Result;
    curwp->w_dotp = Region.r_linep;
    curwp->w_doto = Region.r_offset;
    return ldelete (Region.r_size, FALSE);
} /* cutregion */

/* clipregion:  copy the current region into the clipboard */
/* ==========                                              */

PASCAL clipregion (int f, int n)
{
    REGION  Region;
    int     Result;
    
    if ((Result = getregion (&Region)) != TRUE) return Result;

    return CopyToClipboard (&Region);
} /* clipregion */

/* insertclip:  insert the clipboard contents at dot */
/* ==========                                        */

PASCAL insertclip (int f, int n)
{
    BOOL    Result = TRUE;
    char    *Text, *TextHead;
    short int curoff;
    LINE    *curline;

    /*-don't allow command if read-only mode */
    if (curbp->b_mode & MDVIEW) return rdonly();

    if (OpenClipboard (hFrameWnd)) {
	if ((hClipData = GetClipboardData (CF_TEXT)) != NULL) {
	    /* Save the local pointers to hold global "." */
	    if (yankflag == SRBEGIN) {
		/* Find the *previous* line, since the line we are on
		   may disappear due to re-allocation.  This works even
		   if we are on the first line of the file. */
		curline = lback(curwp->w_dotp);
		curoff = curwp->w_doto;
	    }
	    if ((TextHead = GlobalLock (hClipData)) != NULL) {
		while (n--) {
		    Text = TextHead;
		    while (*Text != '\0') {
			if (*Text == '\n') {
			    if (lnewline () == FALSE) {
				Result = FALSE;
				goto bail_out;
			    }
			}
			else {
			    if (*Text != '\r') if (linsert (1, *Text) == FALSE) {
				Result = FALSE;
				goto bail_out;
			    }
			}
			++Text;
		    }
		}
bail_out:
                GlobalUnlock (hClipData);
                hClipData = NULL;   /* for ClipboardCleanup */
                /* If requested, set global "." back to the beginning of
		   the yanked text. */
		if (yankflag == SRBEGIN) {
		    curwp->w_dotp = lforw(curline);
		    curwp->w_doto = curoff;
		}
	    }
	}
	else Result = FALSE;
	CloseClipboard ();
    }
    else Result = FALSE;
    return Result;
} /* insertclip */

/* ClipboardCleanup:    to be called if the user aborts during a longop */
/* ================                                                     */

void far pascal ClipboardCleanup (void)
{
    if (hClipData) {
        GlobalUnlock (hClipData);
        CloseClipboard ();
    }
} /* ClipboardCleanup */

/* helpengine:  invoke the MS-Windows help engine */
/* ==========                                     */

PASCAL helpengine (int f, int n)
{
    char    OldHelpFile [NFILEN];
    char    HelpKey [NLINE];
    BOOL    Result;

    strcpy (OldHelpFile, HelpEngineFile);
    SetWorkingDir ();
    if ((Result = FILENAMEREPLY (TEXT307, HelpEngineFile, NFILEN)) != TRUE) return Result;
        /* "Help file: " */
    if (HelpEngineFile[0] == '\0') {
        strcpy (HelpEngineFile, OldHelpFile);
        return FALSE;
    }
    else {
        Result = mlreply (TEXT308, HelpKey, NLINE);
	if ((Result != TRUE) && (Result != FALSE)) return Result;
	    /* "Help key: " */
	if (HelpKey[0] == '\0') {
	    WinHelp (hFrameWnd, HelpEngineFile, HELP_INDEX, NULL);
	}
	else {
	    WinHelp (hFrameWnd, HelpEngineFile, HELP_KEY,
                     (DWORD)(LPSTR)&HelpKey[0]);
	}
    }
    return TRUE;
} /* helpengine */

/* minimizescreen:  turn the current screen into an icon */
/* ==============                                        */

PASCAL  minimizescreen (int f, int n)
{
    BOOL    nq;

    nq = notquiescent;
    notquiescent = 0;
    ShowWindow (first_screen->s_drvhandle, SW_MINIMIZE);
    notquiescent = nq;
    return TRUE;
} /* minimizescreen */

/* ForceMessage:    do a SendMessage, forcing quiescent mode */
/* ============                                              */

static pascal near  ForceMessage (HWND hWnd, WORD wMsg, WORD wParam, DWORD lParam)
{
    BOOL    nq;

    nq = notquiescent;
    notquiescent = 0;
    SendMessage (hWnd, wMsg, wParam, lParam);
    notquiescent = nq;
} /* ForceMessage */

/* maximizescreen:  maximize the current screen */
/* ==============                               */

PASCAL  maximizescreen (int f, int n)
{
    ForceMessage (hMDIClientWnd, WM_MDIMAXIMIZE,
                 first_screen->s_drvhandle, 0L);
    return TRUE;
} /* maximizescreen */

/* restorescreen:   restore the current screen from maximized/minimized state */
/* =============                                                              */

PASCAL  restorescreen (int f, int n)
{
    ForceMessage (hMDIClientWnd, WM_MDIRESTORE,
                 first_screen->s_drvhandle, 0L);
    return TRUE;
} /* restorescreen */

/* tilescreens: tile the non-iconized screens */
/* ===========                                */

PASCAL  tilescreens (int f, int n)
{
    ForceMessage (hMDIClientWnd, WM_MDITILE, 0, 0L);
    return TRUE;
} /* tilescreens */

/* cascadescreens:  position the non-iconized screens in cascade */
/* ==============                                                */

PASCAL  cascadescreens (int f, int n)
{
    ForceMessage (hMDIClientWnd, WM_MDICASCADE, 0, 0L);
    return TRUE;
} /* cascadescreens */

/* renamescreen:    change the current screen's name */
/* ============                                      */

PASCAL  renamescreen (int f, int n)
{
    char    scr_name[NSTRING];  /* buffer to hold screen name */
    int     result;

    /* get the new name of the screen */
    if ((result = mlreply(TEXT335, scr_name, NSTRING)) != TRUE) {
	/* "Change screen name to: " */
	return result;
    } 
    if (lookup_screen(scr_name) != (SCREEN*)NULL) {
	mlwrite (TEXT336);  /* "[Screen name already in use]" */
	return FALSE;
    }

    free (first_screen->s_screen_name);
    first_screen->s_screen_name = copystr (scr_name);
    SetWindowText ((HWND)first_screen->s_drvhandle, scr_name);
    return TRUE;
} /* renamescreen */
