/****************************************************************************
 *   FILE PCBDEMO.H                                                         *
 *   Created 01-MAY-1993            Rickie W. Belitz                        *
 *                                  820 Brentwood Drive                     *
 *                                  Maryville, Tennessee  37804             *
 *                                  BBS (615) 690-8231                      *
 *                                      (615) 690-7968                      *
 *                                      (615) 690-7913                      *
 *                                                                          *
 ****************************************************************************/
#include    <stdio.h>
#include    <stdlib.h>
#include    <fcntl.h>
#include    <memory.h>
#include    <dos.h>
#include    <share.h>
#include    <string.h>
#include    <malloc.h>
#include    <process.h>
#include    "oldckit.h"          /* For version 2.x CKit           */
#include    "ckit.h"             /* Include CKIT Header file!      */
#pragma check_stack (off)

#define     BUFFER_SIZE   2048
/************************************************************************
 *       Globals                                                        *
 ***********************************************************************/
char    progname[21] = "PCBDemo";       /* Program name for status line     */
char    pathname[80];         /*  general purpose  filename/path       */
char    *pathptr;             /*  general purpose path pointer         */
short   OPENED;               /* Flag to know if open_door has been called  */
short   CLOSED;              /* Flag to know if close_door has beeb called */

/************************************************************************
 *  Function prototypes                                                 *
 ***********************************************************************/
void    display_conferences(void);
void    shut_down(void);      /* Shuts door down if normal or error occurs. */
short   read_pcbdat(void);
BYTE    get_mapbit(unsigned, BYTE *);
void    set_mapbit(unsigned, BYTE, BYTE, BYTE *);
char *  create_buffer(size_t);
short   open_file(char *);
size_t  read_record(short, BYTE *, size_t);
short   parse_to_C(char *, size_t);
void    copy_buffer(char *, char **, char *);
char *  str_move(char *, unsigned char, char *);
/*****************************************************************************
 *  If desired, optional custom log off messages.                            *
 *  If not used, the library will use it's internal defaults.                *
 *****************************************************************************/
char    option0[] = "Normal Quit to BBS msg\n";
char    option1[] = "CARRIER DROPPED! msg\n";
char    option2[] = "Keyboard Timeout msg\n";
char    option3[] = "Sysop return request msg\n";
char    option4[] = "System time expired msg\n";
char    option5[] = "Goobye, hangup msg\n";

/*****************************************************************************
 *  If desired, optional general message used.                               *
 *  If not used, the library will use it's internal defaults.                *
 *****************************************************************************/
char    ckmsg0[] = "Screen Display on Message";
char    ckmsg1[] = "Time Adjusted due to event message";
char    ckmsg2[] = "< Press ENTER to Continue > message";
char    ckmsg3[] = "Sysop Chat Active Message";
char    ckmsg4[] = "Sysop Chat End Message";
char    ckmsg5[] = "Sysop Exited to DOS Message";
char    ckmsg6[] = "Sysop Returned from DOS Message";
char    ckmsg7[] = "(Enter=none)?) ";
char    ckmsg8[] = "(Enter=yes) ";
char    ckmsg9[] = "(Enter=no) ";
char    ckmsg10[] = " (Enter) or (Y)es, (N)o, (NS)nonstop? ";
char    ckmsg11[] = "More: ";

/*****************************************************************************
 *  Create array of pointers to our custom log off messages                  *
 *****************************************************************************/
static  char    *logoffs[6] = {
    option0,
    option1,
    option2,
    option3,
    option4,
    option5,
};

/*****************************************************************************
 *  Create array of pointers to our custom general messages                  *
 *****************************************************************************/
static  char    *ckit_msgs[12] = {
    ckmsg0,
    ckmsg1,
    ckmsg2,
    ckmsg3,
    ckmsg4,
    ckmsg5,
    ckmsg6,
    ckmsg7,
    ckmsg8,
    ckmsg9,
    ckmsg10,
    ckmsg11
};

/************************************************************************
 *               Define  Pcboard .DAT file  (14.5)                      *
 ***********************************************************************/
typedef struct  pcbdattyp {
char        pcb_version[52];        /* PCBoard version                        */
char        sysop_name[17];         /* Sysop display name                     */
char        sysop_pwrd[14];         /* Sysop password                         */
char        use_realname[4];        /* Use real name for sysop?               */
char        use_graphics[4];        /* Use graphics when local sysop login    */
char        comment_level[5];       /* Level need to read comments            */
char        readall_level[5];       /* Level needed to read all mail          */
char        sysop_level[5];         /* Sysop access level                     */
char        msgcopy_level[5];       /* Level needed to move/copy messages     */
char        callerlog_level[5];     /* Level needed for veiw log              */
char        viewusers_level[5];     /* Level needed to veiw users             */
char        msgpack_level[5];       /* Level needed to pack messages          */
char        recover_level[5];       /* Level needed to recover a message      */
char        header_level[5];        /* Level needed to list msg headers       */
char        system_level[5];        /* Level needed to veiw system files      */
char        maintenance_level[5];   /* Level needed for user maintenance      */
char        packusers_level[5];     /* Level needed for pack users file       */
char        remote_level[5];        /* Level needed for remote drop to DOS    */
char        shell_level[5];         /* Level needed for DOS shell             */
char        node_level[5];          /* Level needed to view other nodes       */
char        logoff_node_level[5];   /* Level needed to logoff alternate node  */
char        view_nodelog_level[5];  /* Level needed to view alt nodes log     */
char        dropnode_level[5];      /* Level needed to drop alt node to DOS   */
char        helpfiles[33];          /* Path/name of helpfiles                 */
char        security_files[33];     /* Path/name of security files            */
char        nodechat_files[33];     /* Path/name of node chat files           */
char        pcbtext[33];            /* Pathname/name of PCBTEXT file          */
char        index_file[33];         /* Pathname/name of index_file file       */
char        users_file[33];         /* Pathname/name of users_file file       */
char        caller_log[33];         /* Pathname/name of caller_log file       */
char        cnames_file[33];        /* Pathname/name of cnames_file file      */
char        pwrd_file[33];          /* Pathname/name of pwrd_file file        */
char        fsec_file[33];          /* Pathname/name of fsec_file file        */
char        upsec_file[33];         /* Pathname/name of upsec_file file       */
char        tcan_file[33];          /* Pathname/name of tcan_file file        */
char        welcome_file[33];       /* Pathname/name of welcome_file file     */
char        newuser_file[33];       /* Pathname/name of newuser_file file     */
char        closed_file[33];        /* Pathname/name of closed_file file      */
char        warning_file[33];       /* Pathname/name of warning_file file     */
char        expired_file[33];       /* Pathname/name of expired_file file     */
char        usernet_file[33];       /* Pathname/name of usernet_file file     */
char        cnfn_menu[33];          /* Pathname/name of cnfn_menu file        */
char        newask_file[33];        /* Pathname/name of newask_file file      */
char        newreg_file[33];        /* Pathname/name of newreg_file file      */
char        pcbprot_file[33];       /* Pathname/name of pcbprot_file file     */
char        dloadtxt_file[33];      /* Pathname/name of dloadtxt_file file    */
char        logoff_scr[33];         /* Pathname/name of logoff_scr file       */
char        logoff_answers[33];     /* Pathname/name of logoff_answrs file    */
char        pcbml_file[33];         /* Pathname/name of pcbml_file file       */
char        chat_topic_file[33];    /* Pathname/name of chat_topic_file file  */
char        carrier_time[4];        /* Seconds to wait on carrier             */
char        comport[6];             /* COM port in use or NONE                */
char        open_baud[8];           /* Opening baud rate                      */
char        lock_baud[4];           /* Lock baud rate?                        */
char        modem_init[42];         /* Modem initialization string            */
char        modem_offhk[33];        /* Modem off-hook string                  */
char        cts_rts_check[4];       /* Enable CTS/RTS checking                */
char        hayes_modem[4];         /* Using Hayes V-series or Ultra          */
char        fastcomm_modem[4];      /* Using FASTCOMM modem                   */
char        rst_modem[4];           /* Reset modem during re-cycle            */
char        modem_offhook[4];       /* Take modem off hook during re-cycle    */
char        pad[4];                 /* Useing PAD                             */
char        ring_detect[4];         /* Answer on true ring detect             */
char        allow_7E1[4];           /* Allow 7-E-1 callers                    */
char        allow_low_baud[4];      /* Allow low baud rates            */
char        low_baud_start[7];      /* Start time for lower bauds      */
char        low_baud_end[7];        /* End time for lower bauds        */
char        mesage_scan[4];         /* Disable message scan            */
char        scr_saver[4];           /* Disable 3 minute screen saver   */
char        reg_edit[4];            /* Disabe registration edits       */
char        high_ASCII[4];          /* Disable higher ASCII codes >127 */
char        quick_logon[4];         /* Disable quick logon             */
char        disable_pwrd[4];        /* Disable pwrd check for DOS drop */
char        multi_lingual[4];       /* Multi-lingual operation         */
char        full_update[4];         /* Disable full record updating    */
char        closed_board[4];        /* Run as a closed board           */
char        non_graphic[4];         /* Run in non-graphic mode         */
char        exit_DOS[4];            /* Exit to DOS after each call     */
char        display_city[4];        /* Display city in node display    */
char        snow_chk[4];            /* Screen snow checking            */
char        subscription_mode[4];   /* Subscription mode of operation  */
char        ESC_code[4];            /* Allow ESC codes in message      */
char        carbon_msgs[4];         /* Allow carbon copy of messages   */
char        validate_msg[4];        /* Validate message TO:            */
char        not_used[4];            /* No longer used                  */
char        daily_time_on[4];       /* Enforce daily time limit        */
char        NEWS_disaply[4];        /* How to display NEWS file        */
char        disable_CTS[4];         /* Disable CTS drop during write   */
char        keyboard_tmr[4];        /* Enable keyboard timeouts        */
char        Network_syst[4];        /* Running a network/multitasker   */
char        Node_number[4];         /* Node number of system           */
char        Network_tmr[4];         /* Network timeout                 */
char        Node_chattmr[4];        /* Node chat frequency             */
char        board_name[65];         /* Name of BBS running             */
char        pcbview_file[33];       /* Path/filename of PCBVIEW        */
char        cmpr_method[6];         /* Filename EXT for compression    */
char        function_key1[62];      /* Function key SHIFT F1                  */
char        function_key2[62];      /* Function key SHIFT F2                  */
char        function_key3[62];      /* Function key SHIFT F3                  */
char        function_key4[62];      /* Function key SHIFT F4                  */
char        function_key5[62];      /* Function key SHIFT F5                  */
char        function_key6[62];      /* Function key SHIFT F6                  */
char        function_key7[62];      /* Function key SHIFT F7                  */
char        function_key8[62];      /* Function key SHIFT F8                  */
char        function_key9[62];      /* Function key SHIFT F9                  */
char        function_key10[62];     /* Function key SHIFT F10                 */
char        not_used3[4];           /* Not used                               */
char        high_conference[8];     /* Highest conference desired             */
char        max_lines[5];           /* Maximum lines used in msg editor       */
char        default_color[4];       /* Default ANSI color in use              */
char        default_intensity[3];   /* Default intensity mode                 */
char        event_active[4];        /* Event active                           */
char        event_start[7];         /* Event start time                       */
char        suspend_mins[4];        /* Minutes to suspend activity prior      */
char        upload_allowed[4];      /* Uploads allowed before event           */
char        slide_event[4];         /* Slide the event time                   */
char        upload_buffer[4];       /* Upload buffer size                     */
char        disable_check[4];       /* Diable Drive size check                */
char        printer_port[3];        /* Printer port number                    */
char        disable_bytes[6];       /* Bytes to disable uploads               */
char        abandon_level[5];       /* Level to abandon conference            */
char        bulletin_level[5];      /* Level to read bulletins                */
char        comment_msg_level[5];   /* Level to leave a sysop comment         */
char        dload_level[5];         /* Level to download a file               */
char        message_level[5];       /* Level to enter a message               */
char        file_level[5];          /* Level for F)ile directory              */
char        not_used2[4];
char        help_level[5];          /* Level for help command                 */
char        initial_level[5];       /* Level for abandon conference           */
char        join_level[5];          /* Level for join command                 */
char        kill_level[5];          /* Level for kill command                 */
char        locate_level[5];        /* Level for locate command               */
char        mode_level[5];          /* Level for mode command                 */
char        filescan_level[5];      /* Level for filescan command             */
char        operator_page_level[5]; /* Level for operator_page command        */
char        page_length_level[5];   /* Level for page_length command          */
char        quick_scan_level[5];    /* Level for quick_scan command           */
char        read_msg_level[5];      /* Level for read_msg command             */
char        script_level[5];        /* Level for script command               */
char        xfer_protocol[5];       /* Level for transfer protocol command    */
char        upload_level[5];        /* Level for upload command               */
char        view_level[5];          /* Level for view command                 */
char        write_level[5];         /* Level for write command                */
char        expert_level[5];        /* Level for expert command               */
char        your_level[5];          /* Level for your command                 */
char        zippy_level[5];         /* Level for zippy command                */
char        door_level[5];          /* Level for door command                 */
char        chat_level[5];          /* Level for chat command                 */
char        register_level[5];      /* Level for register command             */
char        refused_level[5];       /* Level for refused command              */
char        users_level[5];         /* Level for users command                */
char        who_level[5];           /* Level for who command                  */
char        batch_level[5];         /* Level for batch file xfer cmd          */
char        color_defaults[34];     /* Path\NAME of color file (PCFILER.DEF)  */
char        lowest_baud[8];         /* Lowest baud rate allowed               */
char        modem_delay[3];         /* Modem delay during re-cycle            */
char        number_rings[3];        /* Number of rings to answer              */
char        IRQ_number[5];          /* IRQ number of com port in use          */
char        port_base[5];           /* Base address of port in use            */
char        DTR_on[4];              /* Leave DTR on for drop to DOS           */
char        scroll_buffer[5];       /* Maximum lines for scroll back          */
char        preload_text[4];        /* Pre-load PCBTEXT file                  */
char        preload_cnames[4];      /* Pre-load CNAMES file                   */
char        variable_level[5];      /* Level for usign @variable       */
char        uploaded_by[4];         /* Include "Uploaded By"           */
char        user_setting[4];        /* Show user settings at login     */
char        local_shell[4];         /* Allow local F5 shells           */
char        slave_card[4];          /* Using Slave card                */
char        sub_length[6];          /* Default subscription length     */
char        max_msgs[6];            /* MAX message capture             */
char        max_msg_cnfn[6];        /* MAX message capture for cnfn    */
char        stop_uploads[4];        /* Minutes prior to stop uploads   */
char        edit_level[5];          /* Level to edit a message         */
char        edit_your[5];           /* Level to edit your own message  */
char        IRQ_share[4];           /* Share IRQ's                     */
char        scan_all[4];            /* Default to scan all msgs at log */
char        readonly_level[5];      /* Level  to use 'Read Only' cmd   */
char        newask_user[4];         /* Use NEWASK plus standard        */
char        temp_files[34];         /* Path/Locations of temp. files   */
char        user_inf_file[34];      /* Path of user.inf file           */
char        quick_deflt[4];         /* Default to Quick Scan           */
char        warning_days[6];        /* Number of days for sub. warning */
char        onenames[4];            /* Allow on name users             */
char        expired_level[5];       /* Default expired level           */
char        test_level[5];          /* Level for TEST command          */
char        capture_file[10];       /* Message capture filename        */
char        file_verify[4];         /* Perform file verification       */
char        stop_clk[4];            /* Stop clock during msg dload     */
char        page_start[7];          /* Sysop page time start           */
char        page_stop[7];           /* Sysop page time end             */
char        caller_number_log[4];   /* Write caller number to log      */
char        caller_connect_log[4];  /* Write CONNECT string to log     */
char        caller_level_log[4];    /* Write caller sec. level to log  */
char        read_pwrd[4];           /* Read PWRD file upon joining CNF */
char        confirm_caller[4];      /* Confirm caller at logon time    */
char        pwrd_fail_cmt[4];       /* Allowed comment on failed pwrd  */
char        warning_time[4];        /* Display warning before logoff   */
char        max_file_desc[4];       /* MAX lines for file description  */

};

struct pcbdattyp pcboard_dat;

static  char    *dat_ptrs[198] = {
    &pcboard_dat.pcb_version[0],
    &pcboard_dat.sysop_name[0],
    &pcboard_dat.sysop_pwrd[0],
    &pcboard_dat.use_realname[0],
    &pcboard_dat.use_graphics[0],
    &pcboard_dat.comment_level[0],
    &pcboard_dat.readall_level[0],
    &pcboard_dat.sysop_level[0],
    &pcboard_dat.msgcopy_level[0],
    &pcboard_dat.callerlog_level[0],
    &pcboard_dat.viewusers_level[0],
    &pcboard_dat.msgpack_level[0],
    &pcboard_dat.recover_level[0],
    &pcboard_dat.header_level[0],
    &pcboard_dat.system_level[0],
    &pcboard_dat.maintenance_level[0],
    &pcboard_dat.packusers_level[0],
    &pcboard_dat.remote_level[0],
    &pcboard_dat.shell_level[0],
    &pcboard_dat.node_level[0],
    &pcboard_dat.logoff_node_level[0],
    &pcboard_dat.view_nodelog_level[0],
    &pcboard_dat.dropnode_level[0],
    &pcboard_dat.helpfiles[0],
    &pcboard_dat.security_files[0],
    &pcboard_dat.nodechat_files[0],
    &pcboard_dat.pcbtext[0],
    &pcboard_dat.index_file[0],
    &pcboard_dat.users_file[0],
    &pcboard_dat.caller_log[0],
    &pcboard_dat.cnames_file[0],
    &pcboard_dat.pwrd_file[0],
    &pcboard_dat.fsec_file[0],
    &pcboard_dat.upsec_file[0],
    &pcboard_dat.tcan_file[0],
    &pcboard_dat.welcome_file[0],
    &pcboard_dat.newuser_file[0],
    &pcboard_dat.closed_file[0],
    &pcboard_dat.warning_file[0],
    &pcboard_dat.expired_file[0],
    &pcboard_dat.usernet_file[0],
    &pcboard_dat.cnfn_menu[0],
    &pcboard_dat.newask_file[0],
    &pcboard_dat.newreg_file[0],
    &pcboard_dat.pcbprot_file[0],
    &pcboard_dat.dloadtxt_file[0],
    &pcboard_dat.logoff_scr[0],
    &pcboard_dat.logoff_answers[0],
    &pcboard_dat.pcbml_file[0],
    &pcboard_dat.chat_topic_file[0],
    &pcboard_dat.carrier_time[0],
    &pcboard_dat.comport[0],
    &pcboard_dat.open_baud[0],
    &pcboard_dat.lock_baud[0],
    &pcboard_dat.modem_init[0],
    &pcboard_dat.modem_offhk[0],
    &pcboard_dat.cts_rts_check[0],
    &pcboard_dat.hayes_modem[0],
    &pcboard_dat.fastcomm_modem[0],
    &pcboard_dat.rst_modem[0],
    &pcboard_dat.modem_offhook[0],
    &pcboard_dat.pad[0],
    &pcboard_dat.ring_detect[0],
    &pcboard_dat.allow_7E1[0],
    &pcboard_dat.allow_low_baud[0],
    &pcboard_dat.low_baud_start[0],
    &pcboard_dat.low_baud_end[0],
    &pcboard_dat.mesage_scan[0],
    &pcboard_dat.scr_saver[0],
    &pcboard_dat.reg_edit[0],
    &pcboard_dat.high_ASCII[0],
    &pcboard_dat.quick_logon[0],
    &pcboard_dat.disable_pwrd[0],
    &pcboard_dat.multi_lingual[0],
    &pcboard_dat.full_update[0],
    &pcboard_dat.closed_board[0],
    &pcboard_dat.non_graphic[0],
    &pcboard_dat.exit_DOS[0],
    &pcboard_dat.display_city[0],
    &pcboard_dat.snow_chk[0],
    &pcboard_dat.subscription_mode[0],
    &pcboard_dat.ESC_code[0],
    &pcboard_dat.carbon_msgs[0],
    &pcboard_dat.validate_msg[0],
    &pcboard_dat.not_used[0],
    &pcboard_dat.daily_time_on[0],
    &pcboard_dat.NEWS_disaply[0],
    &pcboard_dat.disable_CTS[0],
    &pcboard_dat.keyboard_tmr[0],
    &pcboard_dat.Network_syst[0],
    &pcboard_dat.Node_number[0],
    &pcboard_dat.Network_tmr[0],
    &pcboard_dat.Node_chattmr[0],
    &pcboard_dat.board_name[0],
    &pcboard_dat.pcbview_file[0],
    &pcboard_dat.cmpr_method[0],
    &pcboard_dat.function_key1[0],
    &pcboard_dat.function_key2[0],
    &pcboard_dat.function_key3[0],
    &pcboard_dat.function_key4[0],
    &pcboard_dat.function_key5[0],
    &pcboard_dat.function_key6[0],
    &pcboard_dat.function_key7[0],
    &pcboard_dat.function_key8[0],
    &pcboard_dat.function_key9[0],
    &pcboard_dat.function_key10[0],
    &pcboard_dat.not_used3[0],
    &pcboard_dat.high_conference[0],
    &pcboard_dat.max_lines[0],
    &pcboard_dat.default_color[0],
    &pcboard_dat.default_intensity[0],
    &pcboard_dat.event_active[0],
    &pcboard_dat.event_start[0],
    &pcboard_dat.suspend_mins[0],
    &pcboard_dat.upload_allowed[0],
    &pcboard_dat.slide_event[0],
    &pcboard_dat.upload_buffer[0],
    &pcboard_dat.disable_check[0],
    &pcboard_dat.printer_port[0],
    &pcboard_dat.disable_bytes[0],
    &pcboard_dat.abandon_level[0],
    &pcboard_dat.bulletin_level[0],
    &pcboard_dat.comment_msg_level[0],
    &pcboard_dat.dload_level[0],
    &pcboard_dat.message_level[0],
    &pcboard_dat.file_level[0],
    &pcboard_dat.not_used2[0],
    &pcboard_dat.help_level[0],
    &pcboard_dat.initial_level[0],
    &pcboard_dat.join_level[0],
    &pcboard_dat.kill_level[0],
    &pcboard_dat.locate_level[0],
    &pcboard_dat.mode_level[0],
    &pcboard_dat.filescan_level[0],
    &pcboard_dat.operator_page_level[0],
    &pcboard_dat.page_length_level[0],
    &pcboard_dat.quick_scan_level[0],
    &pcboard_dat.read_msg_level[0],
    &pcboard_dat.script_level[0],
    &pcboard_dat.xfer_protocol[0],
    &pcboard_dat.upload_level[0],
    &pcboard_dat.view_level[0],
    &pcboard_dat.write_level[0],
    &pcboard_dat.expert_level[0],
    &pcboard_dat.your_level[0],
    &pcboard_dat.zippy_level[0],
    &pcboard_dat.door_level[0],
    &pcboard_dat.chat_level[0],
    &pcboard_dat.register_level[0],
    &pcboard_dat.refused_level[0],
    &pcboard_dat.users_level[0],
    &pcboard_dat.who_level[0],
    &pcboard_dat.batch_level[0],
    &pcboard_dat.color_defaults[0],
    &pcboard_dat.lowest_baud[0],
    &pcboard_dat.modem_delay[0],
    &pcboard_dat.number_rings[0],
    &pcboard_dat.IRQ_number[0],
    &pcboard_dat.port_base[0],
    &pcboard_dat.DTR_on[0],
    &pcboard_dat.scroll_buffer[0],
    &pcboard_dat.preload_text[0],
    &pcboard_dat.preload_cnames[0],
    &pcboard_dat.variable_level[0],
    &pcboard_dat.uploaded_by[0],
    &pcboard_dat.user_setting[0],
    &pcboard_dat.local_shell[0],
    &pcboard_dat.slave_card[0],
    &pcboard_dat.sub_length[0],
    &pcboard_dat.max_msgs[0],
    &pcboard_dat.max_msg_cnfn[0],
    &pcboard_dat.stop_uploads[0],
    &pcboard_dat.edit_level[0],
    &pcboard_dat.edit_your[0],
    &pcboard_dat.IRQ_share[0],
    &pcboard_dat.scan_all[0],
    &pcboard_dat.readonly_level[0],
    &pcboard_dat.newask_user[0],
    &pcboard_dat.temp_files[0],
    &pcboard_dat.user_inf_file[0],
    &pcboard_dat.quick_deflt[0],
    &pcboard_dat.warning_days[0],
    &pcboard_dat.onenames[0],
    &pcboard_dat.expired_level[0],
    &pcboard_dat.test_level[0],
    &pcboard_dat.capture_file[0],
    &pcboard_dat.file_verify[0],
    &pcboard_dat.stop_clk[0],
    &pcboard_dat.page_start[0],
    &pcboard_dat.page_stop[0],
    &pcboard_dat.caller_number_log[0],
    &pcboard_dat.caller_connect_log[0],
    &pcboard_dat.caller_level_log[0],
    &pcboard_dat.read_pwrd[0],
    &pcboard_dat.confirm_caller[0],
    &pcboard_dat.pwrd_fail_cmt[0],
    &pcboard_dat.warning_time[0],
    &pcboard_dat.max_file_desc[0],
};

unsigned char pcb_maxbytes[198] = {
    sizeof(pcboard_dat.pcb_version),
    sizeof(pcboard_dat.sysop_name),
    sizeof(pcboard_dat.sysop_pwrd),
    sizeof(pcboard_dat.use_realname),
    sizeof(pcboard_dat.use_graphics),
    sizeof(pcboard_dat.comment_level),
    sizeof(pcboard_dat.readall_level),
    sizeof(pcboard_dat.sysop_level),
    sizeof(pcboard_dat.msgcopy_level),
    sizeof(pcboard_dat.callerlog_level),
    sizeof(pcboard_dat.viewusers_level),
    sizeof(pcboard_dat.msgpack_level),
    sizeof(pcboard_dat.recover_level),
    sizeof(pcboard_dat.header_level),
    sizeof(pcboard_dat.system_level),
    sizeof(pcboard_dat.maintenance_level),
    sizeof(pcboard_dat.packusers_level),
    sizeof(pcboard_dat.remote_level),
    sizeof(pcboard_dat.shell_level),
    sizeof(pcboard_dat.node_level),
    sizeof(pcboard_dat.logoff_node_level),
    sizeof(pcboard_dat.view_nodelog_level),
    sizeof(pcboard_dat.dropnode_level),
    sizeof(pcboard_dat.helpfiles),
    sizeof(pcboard_dat.security_files),
    sizeof(pcboard_dat.nodechat_files),
    sizeof(pcboard_dat.pcbtext),
    sizeof(pcboard_dat.index_file),
    sizeof(pcboard_dat.users_file),
    sizeof(pcboard_dat.caller_log),
    sizeof(pcboard_dat.cnames_file),
    sizeof(pcboard_dat.pwrd_file),
    sizeof(pcboard_dat.fsec_file),
    sizeof(pcboard_dat.upsec_file),
    sizeof(pcboard_dat.tcan_file),
    sizeof(pcboard_dat.welcome_file),
    sizeof(pcboard_dat.newuser_file),
    sizeof(pcboard_dat.closed_file),
    sizeof(pcboard_dat.warning_file),
    sizeof(pcboard_dat.expired_file),
    sizeof(pcboard_dat.usernet_file),
    sizeof(pcboard_dat.cnfn_menu),
    sizeof(pcboard_dat.newask_file),
    sizeof(pcboard_dat.newreg_file),
    sizeof(pcboard_dat.pcbprot_file),
    sizeof(pcboard_dat.dloadtxt_file),
    sizeof(pcboard_dat.logoff_scr),
    sizeof(pcboard_dat.logoff_answers),
    sizeof(pcboard_dat.pcbml_file),
    sizeof(pcboard_dat.chat_topic_file),
    sizeof(pcboard_dat.carrier_time),
    sizeof(pcboard_dat.comport),
    sizeof(pcboard_dat.open_baud),
    sizeof(pcboard_dat.lock_baud),
    sizeof(pcboard_dat.modem_init),
    sizeof(pcboard_dat.modem_offhk),
    sizeof(pcboard_dat.cts_rts_check),
    sizeof(pcboard_dat.hayes_modem),
    sizeof(pcboard_dat.fastcomm_modem),
    sizeof(pcboard_dat.rst_modem),
    sizeof(pcboard_dat.modem_offhook),
    sizeof(pcboard_dat.pad),
    sizeof(pcboard_dat.ring_detect),
    sizeof(pcboard_dat.allow_7E1),
    sizeof(pcboard_dat.allow_low_baud),
    sizeof(pcboard_dat.low_baud_start),
    sizeof(pcboard_dat.low_baud_end),
    sizeof(pcboard_dat.mesage_scan),
    sizeof(pcboard_dat.scr_saver),
    sizeof(pcboard_dat.reg_edit),
    sizeof(pcboard_dat.high_ASCII),
    sizeof(pcboard_dat.quick_logon),
    sizeof(pcboard_dat.disable_pwrd),
    sizeof(pcboard_dat.multi_lingual),
    sizeof(pcboard_dat.full_update),
    sizeof(pcboard_dat.closed_board),
    sizeof(pcboard_dat.non_graphic),
    sizeof(pcboard_dat.exit_DOS),
    sizeof(pcboard_dat.display_city),
    sizeof(pcboard_dat.snow_chk),
    sizeof(pcboard_dat.subscription_mode),
    sizeof(pcboard_dat.ESC_code),
    sizeof(pcboard_dat.carbon_msgs),
    sizeof(pcboard_dat.validate_msg),
    sizeof(pcboard_dat.not_used),
    sizeof(pcboard_dat.daily_time_on),
    sizeof(pcboard_dat.NEWS_disaply),
    sizeof(pcboard_dat.disable_CTS),
    sizeof(pcboard_dat.keyboard_tmr),
    sizeof(pcboard_dat.Network_syst),
    sizeof(pcboard_dat.Node_number),
    sizeof(pcboard_dat.Network_tmr),
    sizeof(pcboard_dat.Node_chattmr),
    sizeof(pcboard_dat.board_name),
    sizeof(pcboard_dat.pcbview_file),
    sizeof(pcboard_dat.cmpr_method),
    sizeof(pcboard_dat.function_key1),
    sizeof(pcboard_dat.function_key2),
    sizeof(pcboard_dat.function_key3),
    sizeof(pcboard_dat.function_key4),
    sizeof(pcboard_dat.function_key5),
    sizeof(pcboard_dat.function_key6),
    sizeof(pcboard_dat.function_key7),
    sizeof(pcboard_dat.function_key8),
    sizeof(pcboard_dat.function_key9),
    sizeof(pcboard_dat.function_key10),
    sizeof(pcboard_dat.not_used3),
    sizeof(pcboard_dat.high_conference),
    sizeof(pcboard_dat.max_lines),
    sizeof(pcboard_dat.default_color),
    sizeof(pcboard_dat.default_intensity),
    sizeof(pcboard_dat.event_active),
    sizeof(pcboard_dat.event_start),
    sizeof(pcboard_dat.suspend_mins),
    sizeof(pcboard_dat.upload_allowed),
    sizeof(pcboard_dat.slide_event),
    sizeof(pcboard_dat.upload_buffer),
    sizeof(pcboard_dat.disable_check),
    sizeof(pcboard_dat.printer_port),
    sizeof(pcboard_dat.disable_bytes),
    sizeof(pcboard_dat.abandon_level),
    sizeof(pcboard_dat.bulletin_level),
    sizeof(pcboard_dat.comment_msg_level),
    sizeof(pcboard_dat.dload_level),
    sizeof(pcboard_dat.message_level),
    sizeof(pcboard_dat.file_level),
    sizeof(pcboard_dat.not_used2),
    sizeof(pcboard_dat.help_level),
    sizeof(pcboard_dat.initial_level),
    sizeof(pcboard_dat.join_level),
    sizeof(pcboard_dat.kill_level),
    sizeof(pcboard_dat.locate_level),
    sizeof(pcboard_dat.mode_level),
    sizeof(pcboard_dat.filescan_level),
    sizeof(pcboard_dat.operator_page_level),
    sizeof(pcboard_dat.page_length_level),
    sizeof(pcboard_dat.quick_scan_level),
    sizeof(pcboard_dat.read_msg_level),
    sizeof(pcboard_dat.script_level),
    sizeof(pcboard_dat.xfer_protocol),
    sizeof(pcboard_dat.upload_level),
    sizeof(pcboard_dat.view_level),
    sizeof(pcboard_dat.write_level),
    sizeof(pcboard_dat.expert_level),
    sizeof(pcboard_dat.your_level),
    sizeof(pcboard_dat.zippy_level),
    sizeof(pcboard_dat.door_level),
    sizeof(pcboard_dat.chat_level),
    sizeof(pcboard_dat.register_level),
    sizeof(pcboard_dat.refused_level),
    sizeof(pcboard_dat.users_level),
    sizeof(pcboard_dat.who_level),
    sizeof(pcboard_dat.batch_level),
    sizeof(pcboard_dat.color_defaults),
    sizeof(pcboard_dat.lowest_baud),
    sizeof(pcboard_dat.modem_delay),
    sizeof(pcboard_dat.number_rings),
    sizeof(pcboard_dat.IRQ_number),
    sizeof(pcboard_dat.port_base),
    sizeof(pcboard_dat.DTR_on),
    sizeof(pcboard_dat.scroll_buffer),
    sizeof(pcboard_dat.preload_text),
    sizeof(pcboard_dat.preload_cnames),
    sizeof(pcboard_dat.variable_level),
    sizeof(pcboard_dat.uploaded_by),
    sizeof(pcboard_dat.user_setting),
    sizeof(pcboard_dat.local_shell),
    sizeof(pcboard_dat.slave_card),
    sizeof(pcboard_dat.sub_length),
    sizeof(pcboard_dat.max_msgs),
    sizeof(pcboard_dat.max_msg_cnfn),
    sizeof(pcboard_dat.stop_uploads),
    sizeof(pcboard_dat.edit_level),
    sizeof(pcboard_dat.edit_your),
    sizeof(pcboard_dat.IRQ_share),
    sizeof(pcboard_dat.scan_all),
    sizeof(pcboard_dat.readonly_level),
    sizeof(pcboard_dat.newask_user),
    sizeof(pcboard_dat.temp_files),
    sizeof(pcboard_dat.user_inf_file),
    sizeof(pcboard_dat.quick_deflt),
    sizeof(pcboard_dat.warning_days),
    sizeof(pcboard_dat.onenames),
    sizeof(pcboard_dat.expired_level),
    sizeof(pcboard_dat.test_level),
    sizeof(pcboard_dat.capture_file),
    sizeof(pcboard_dat.file_verify),
    sizeof(pcboard_dat.stop_clk),
    sizeof(pcboard_dat.page_start),
    sizeof(pcboard_dat.page_stop),
    sizeof(pcboard_dat.caller_number_log),
    sizeof(pcboard_dat.caller_connect_log),
    sizeof(pcboard_dat.caller_level_log),
    sizeof(pcboard_dat.read_pwrd),
    sizeof(pcboard_dat.confirm_caller),
    sizeof(pcboard_dat.pwrd_fail_cmt),
    sizeof(pcboard_dat.warning_time),
    sizeof(pcboard_dat.max_file_desc)
};

/****************************************************************************
 ************************ E N D  OF  M O D U L E ****************************/

