; Fast3D   v 2.1.3
; Concepts and coding by Stefano Tommesani 95/96
; All rights reserved
; E-mail: tommesa@ulisse.cedi.unipr.it

; Fast3D is the renderer of the Purple Haze project
; developed by Stefano Tommesani and Andrea Marchini
; at the University of Parma in 1995/96.

.MODEL SMALL

.STACK 7D0H

.DATA
     extrn x_res : word , y_res : word , min : word , max : word
     public MINDRAW,MAXDRAW

     DataSize     EQU 53000          ; size of Vertex + Poly
     XShift       EQU   320          ; X center of the screen
     YShift       EQU   240          ; Y center of the screen

; indexes in the poly's structure
     NormX        EQU     0
     NormY        EQU     4
     NormZ        EQU     8
     NumVert      EQU    12
     Red          EQU    13
     Green        EQU    14
     Blue         EQU    15
     ColorShift   EQU    16
     Front        EQU    20
     Back         EQU    22
     Vertexes     EQU    24
; indexes in the vertex' structure
     IterNum      EQU     0
     VertX        EQU     4
     VertY        EQU     8
     VertZ        EQU    12
     ScreenX      EQU    16
     ScreenY      EQU    18

     align 2
     Step          DW     4096       ; 4096 paragraphs = 64KB
     FileName      DB     '        .3D',0  ; Name of the data file
     cColor        DD    62.5        ; color constant
     cPerspective  DD     -0.0039    ; perspective distortion constant
     HorZ          DD  -256.0        ; Z position of the viewer
     HiPassNeg     DD    -0.001      ; filters for numeric errors
     HiPassPos     DD     0.001      ;
     ScaleFact     DD     2.0        ; scaling factor
     WRONGFILENAME DB     'File doesn''t exist.$'  ; error message
     TOOMANYCOLORS DB     'Too many colors!$'      ; error message

.DATA?
public MINDRAW,MAXDRAW
     align 2
     Color         DW     ?
     Acc           DD     ?
     Iter          DD     ?          ; counter of rendered images
     XMouse        DW     ?          ; X-position of the mouse
     YMouse        DW     ?          ; Y-position of the mouse
     Plot          DW    20 DUP(?)   ; structure passed to Polygon
     NumVertex     DB     ?          ; number of vertexes in current polygon
     Dummy         DB     ?

     Palette       DD   256 DUP(?)   ; 256 color palette

     Light         DD     3 DUP(?)   ; light versor
     tSinCos       DD   720 DUP(?)   ; precalculated Sin-Cos table (faster than FSin-FCos!)
     Vertex        DD  6500 DUP(?)   ; array of vertexes
     Poly          DD  6750 DUP(?)   ; space for polygons

     MinDraw       DW ?
     MaxDraw       DW ?
     new_min dw ?
     new_max dw ?

.486

.CODE
     EXTRN Polygon : PROC , RESETTA : PROC , COPIA_SU_SCHERMO : PROC, INIT_VESA : PROC
     EXTRN RESETTA_TUTTO : PROC

SETUP3D PROC
        PUBLIC SETUP3D

; Purpose: sets video mode, loads data file, resets mouse handler
; Registers destroyed: none

  pusha
  call INIT_VESA           ; sets 640x480x8bpp video mode
  push es
  pop ds
  mov ax,Dgroup
  mov es,ax
  mov si,93
  lea di,FileName
  mov cx,8
  rep movsb                ; copies command line argument into FileName
  mov ax,Dgroup
  mov ds,ax
  mov ah,3DH
  mov al,0
  mov dx,OFFSET FileName
  int 21H                  ; opens data file , ax <- handle
  jnc @FileExists          ; error: file does not exist
  mov ax,03
  int 10H
  lea dx,WRONGFILENAME
  mov ah,09
  int 21H
  mov ah,4CH
  int 21H
@FileExists:
  mov bx,ax
  mov dx,OFFSET Light
  xor ax,ax
  mov ah,3FH
  mov cx,DataSize+2892
  int 21H                  ; reads from data file ( Light -> Poly )
  xor ax,ax
  mov ah,3EH
  int 21H                  ; closes data file
  mov ax,0000H
  int 33H                  ; mouse reset
  mov ax,0007H
  mov cx,0
  mov dx,359
  int 33H                  ; defines horizontal cursor range
  mov ax,0008H
  mov cx,0
  mov dx,359
  int 33H                  ; defines vertical cursor range
  mov ax,Dgroup
  add ax,4096
  mov es,ax
  mov ax,Dgroup
  mov ds,ax
  mov MinDraw,0
  mov MaxDraw,479
  call resetta_tutto       ; clears video buffer
  popa
  ret
SETUP3D ENDP

DRAW PROC
     PUBLIC DRAW

; Purpose:  BSP tree walk, polygons' rotation and projection on screen space,
;           shading and palette management
; Input:    bx = index of current poly in Poly array
; Registers destroyed: ax

; rotates poly's first vertex

  align 2
  finit
  push bx
  mov bx,WORD PTR Poly[bx+Vertexes] ; index of current vertex in Vertexes array

  fld Vertex[bx+VertZ]      ; st0 <- Poly.Z
  fmul tSinCos[si]          ; st0 <- Z*Sin(DegX)
  fld Vertex[bx+VertY]      ; st0 <- Poly.Y
  fmul tSinCos[si+4]        ; st0 <- Y*Cos(DegX)
  faddp st 1,st             ; st0 = Z*Sin(DegX) + Y*Cos(DegX) = Rot.Y
  fld Vertex[bx+VertY]      ; st0 <- Poly.Y
  fmul tSinCos[si]          ; st0 =  Y*Sin(DegX)
  fld Vertex[bx+VertZ]      ; st0 <- Poly.Z
  fmul tSinCos[si+4]        ; st0 <- Z*Cos(DegX)
  fsubrp st 1,st            ; app = -Y*Sin(DegX) + Z*Cos(DegX)
  fld st 0                  ; duplicates app
  fmul tSinCos[di+4]        ; st0 = app*Cos(DegY)
  fincstp
  fmul tSinCos[di]          ; st1 = app*Sin(DegY)
  fdecstp

  fld Vertex[bx+VertX]      ; st0 <- Poly.X
  fmul tSinCos[di]          ; st0 = X*Sin(DegY)
  fld Vertex[bx+VertX]      ; st0 <- Poly.X
  fmul tSinCos[di+4]        ; st0 = X*Cos(DegY)
  fsubrp st 3,st            ; st2 = -app*Sin(DegY) + X*Cos(DegY)
  faddp st 1,st             ; st0 = app*Cos(DegY) + X*Sin(DegY)
  pop bx

  fsub HorZ

; rotates poly's normal

  fld Poly[bx+NormZ]        ; st0 <- Poly.Z
  fmul tSinCos[si]          ; st0 <- Z*Sin(DegX)
  fld Poly[bx+NormY]        ; st0 <- Poly.Y
  fmul tSinCos[si+4]        ; st0 <- Y*Cos(DegX)
  faddp st 1,st             ; st0 = Z*Sin(DegX) + Y*Cos(DegX) = Rot.Y
  fld Poly[bx+NormY]        ; st0 <- Poly.Y
  fmul tSinCos[si]          ; st0 =  Y*Sin(DegX)
  fld Poly[bx+NormZ]        ; st0 <- Poly.Z
  fmul tSinCos[si+4]        ; st0 <- Z*Cos(DegX)
  fsubrp st 1,st            ; app = -Y*Sin(DegX) + Z*Cos(DegX)
  fld st 0                  ; duplicates app
  fmul tSinCos[di+4]        ; st0 = app*Cos(DegY)
  fincstp
  fmul tSinCos[di]          ; st1 = app*Sin(DegY)
  fdecstp

  fld Poly[bx+NormX]        ; st0 <- Poly.X
  fmul tSinCos[di]          ; st0 = X*Sin(DegY)
  fld Poly[bx+NormX]        ; st0 <- Poly.X
  fmul tSinCos[di+4]        ; st0 = X*Cos(DegY)
  fsubrp st 3,st            ; st2 = -app*Sin(DegY) + X*Cos(DegY)
  faddp st 1,st             ; st0 = app*Cos(DegY) + X*Sin(DegY)

; finds scalar product between Light versor and rotated normal

  fld st 0
  fmul Light[8]
  fld st 2
  fmul Light[4]
  faddp st 1,st
  fld st 3
  fmul Light[0]
  faddp st 1,st
  fstp Poly[bx+ColorShift]   ; saves the scalar product into
                             ; the ColorShift field

; finds scalar product between rotated normal and view vector

  fmulp st 3,st
  fmulp st 3,st
  fmulp st 3,st
  faddp st 1,st
  faddp st 1,st

; is the poly visible ?

  fcom HiPassPos
  fstsw ax
  sahf
  jae @NotVisible

; it's not clearly invisible, but I must see if it's clearly visible

  fcom HiPassNeg
  fstsw ax
  sahf
  jb @NoDoubtBelow

; this is a tricky situation: I can't tell if the polygon is visible or not,
; so I pick another vertex of the polygon and repeat all calculations
; NOTE: this situation rarely happens, so all following instructions usually
; are not executed and performance does not suffer; however, this is a
; really dangerous situation, because a wrong decision can turn upside down
; the BSP tree and display a completely messed up image!

; rotates poly's third vertex (the third vertex is usually more meaningful
; than the second one)

  fstp Acc

  push bx
  mov bx,WORD PTR Poly[bx+Vertexes+4]  ; index of the third vertex

  fld Vertex[bx+VertZ]      ; st0 <- Poly.Z
  fmul tSinCos[si]          ; st0 <- Z*Sin(DegX)
  fld Vertex[bx+VertY]      ; st0 <- Poly.Y
  fmul tSinCos[si+4]        ; st0 <- Y*Cos(DegX)
  faddp st 1,st             ; st0 = Z*Sin(DegX) + Y*Cos(DegX) = Rot.Y
  fld Vertex[bx+VertY]      ; st0 <- Poly.Y
  fmul tSinCos[si]          ; st0 =  Y*Sin(DegX)
  fld Vertex[bx+VertZ]      ; st0 <- Poly.Z
  fmul tSinCos[si+4]        ; st0 <- Z*Cos(DegX)
  fsubrp st 1,st            ; app = -Y*Sin(DegX) + Z*Cos(DegX)
  fld st 0                  ; duplicates app
  fmul tSinCos[di+4]        ; st0 = app*Cos(DegY)
  fincstp
  fmul tSinCos[di]          ; st1 = app*Sin(DegY)
  fdecstp

  fld Vertex[bx+VertX]      ; st0 <- Poly.X
  fmul tSinCos[di]          ; st0 = X*Sin(DegY)
  fld Vertex[bx+VertX]      ; st0 <- Poly.X
  fmul tSinCos[di+4]        ; st0 = X*Cos(DegY)
  fsubrp st 3,st            ; st2 = -app*Sin(DegY) + X*Cos(DegY)
  faddp st 1,st             ; st0 = app*Cos(DegY) + X*Sin(DegY)
  pop bx

  fsub HorZ

; Rotate poly's normal

  fld Poly[bx+NormZ]        ; st0 <- Poly.Z
  fmul tSinCos[si]          ; st0 <- Z*Sin(DegX)
  fld Poly[bx+NormY]        ; st0 <- Poly.Y
  fmul tSinCos[si+4]        ; st0 <- Y*Cos(DegX)
  faddp st 1,st             ; st0 = Z*Sin(DegX) + Y*Cos(DegX) = Rot.Y
  fld Poly[bx+NormY]        ; st0 <- Poly.Y
  fmul tSinCos[si]          ; st0 =  Y*Sin(DegX)
  fld Poly[bx+NormZ]        ; st0 <- Poly.Z
  fmul tSinCos[si+4]        ; st0 <- Z*Cos(DegX)
  fsubrp st 1,st            ; app = -Y*Sin(DegX) + Z*Cos(DegX)
  fld st 0                  ; duplicates app
  fmul tSinCos[di+4]        ; st0 = app*Cos(DegY)
  fincstp
  fmul tSinCos[di]          ; st1 = app*Sin(DegY)
  fdecstp

  fld Poly[bx+NormX]        ; st0 <- Poly.X
  fmul tSinCos[di]          ; st0 = X*Sin(DegY)
  fld Poly[bx+NormX]        ; st0 <- Poly.X
  fmul tSinCos[di+4]        ; st0 = X*Cos(DegY)
  fsubrp st 3,st            ; st2 = -app*Sin(DegY) + X*Cos(DegY)
  faddp st 1,st             ; st0 = app*Cos(DegY) + X*Sin(DegY)

  fmulp st 3,st
  fmulp st 3,st
  fmulp st 3,st
  faddp st 1,st
  faddp st 1,st

  fadd Acc

  ftst
  fstsw ax
  sahf
  jae @NotVisible

; the polygon is visible, so I draw all polygons that lie behind it,
; then the current one and then all those in front of it

@NoDoubtBelow:
  push bx
  mov bx,WORD PTR Poly[bx+Back]
  cmp bx,0
  je @VD1
  call DRAW       ; this is recursive code!
@VD1:
  pop bx
  call DRAWPOLY   ;  DRAW MYSELF !!!
  push bx
  mov bx,WORD PTR Poly[bx+Front]
  cmp bx,0
  je @VD2
  call DRAW
@VD2:
  pop bx
  ret

; the polygon is not visible, so I draw all polygons that lie in front of it
; then all those behind it

@NotVisible:
  push bx
  mov bx,WORD PTR Poly[bx+Front]
  cmp bx,0
  je @NVD1
  call DRAW
@NVD1:
  pop bx
  push bx
  mov bx,WORD PTR Poly[bx+Back]
  cmp  bx,0
  je @NVD2
  call DRAW
@NVD2:
  pop bx
  ret
DRAW ENDP

DRAWPOLY PROC
         PUBLIC DRAWPOLY

; Purpose:
; Input:    bx = offset in polys' array
;           si = DegX*8
;           di = DegY*8

  finit
  push bx
  xor cx,cx
  mov cl,BYTE PTR Poly[bx+NumVert]
  mov NumVertex,cl
  xor dx,dx
  align 2
@RotateLoop:
      push bx
      mov bx,WORD PTR Poly[bx+Vertexes]
      ; maybe I've already done all those calculations...
      mov eax,Iter
      cmp eax,Vertex[bx]
      jne @DoCalc
   @AlreadyDone:
      ; YES: the vertexes' cache has done it again! This is a GREAT speedup!
      mov eax,Vertex[bx+ScreenX]
      mov bx,dx
      mov DWORD PTR Plot[bx],eax
      pop bx
      inc bx
      add dx,4
      inc bx
      dec cx
      jnz @RotateLoop
      jmp @ExitRotate

; it's the first time I rotate and project this vertex in the current image,
; so I have all these calculations to do...
   @DoCalc:
      fld Vertex[bx+VertZ]      ; st0 <- Poly.Z
      fmul tSinCos[si]          ; st0 <- Z*Sin(DegX)
      fld Vertex[bx+VertY]      ; st0 <- Poly.Y
      fmul tSinCos[si+4]        ; st0 <- Y*Cos(DegX)
      faddp st 1,st             ; st0 = Z*Sin(DegX) + Y*Cos(DegX) = Rot.Y
      fld Vertex[bx+VertY]      ; st0 <- Poly.Y
      fmul tSinCos[si]          ; st0 =  Y*Sin(DegX)
      fld Vertex[bx+VertZ]      ; st0 <- Poly.Z
      fmul tSinCos[si+4]        ; st0 <- Z*Cos(DegX)
      fsubrp st 1,st            ; app = -Y*Sin(DegX) + Z*Cos(DegX)
      fld st 0                  ; duplicates app
      fmul tSinCos[di+4]        ; st0 = app*Cos(DegY)
      fincstp
      fmul tSinCos[di]          ; st1 = app*Sin(DegY)
      fdecstp

      fld Vertex[bx+VertX]      ; st0 <- Poly.X
      fmul tSinCos[di]          ; st0 = X*Sin(DegY)
      fld Vertex[bx+VertX]      ; st0 <- Poly.X
      fmul tSinCos[di+4]        ; st0 = X*Cos(DegY)
      fsubrp st 3,st            ; st2 = -app*Sin(DegY) + X*Cos(DegY)
      faddp st 1,st             ; st0 = app*Cos(DegY) + X*Sin(DegY)

; Perspective distortion
      fmul cPerspective         ; st0 = Z*cPerspective
      fld1                      ; st0 <- 1
      faddp st 1,st             ; st0 = Z*cPerspective + 1
      fmul ScaleFact            ; scales image
      fmul st 2,st              ; st2 = X*(Z*cPerspective + 1)
      fmulp st 1,st             ; st0 = Y*(Z*cPerspective + 1)
      xchg bx,dx
      fistp WORD PTR Plot[bx]   ; save X to plot
      add Plot[bx],XShift       ; screen centers X
      fistp WORD PTR Plot[bx+2] ; save Y to plot
      neg Plot[bx+2]
      add Plot[bx+2],YShift     ; screen centers Y
      mov eax,DWORD PTR Plot[bx]
      xchg bx,dx
      mov Vertex[bx+ScreenX],eax
      mov eax,Iter
      mov Vertex[bx],eax
      pop bx
      inc bx
      add dx,4
      inc bx

      dec cx
      jnz @RotateLoop

@ExitRotate:
    pop bx
    push di
    push si
    push bx

    fld Poly[bx+ColorShift]
    fmul cColor            ; poly color = (cColor * norm scalar product) + ...
    fadd cColor            ;   ...+ cColor
    fistp WORD PTR Color

    mov dx,WORD PTR Color
    xor edx,edx            ; EDX = 00H-Color-Color-Color
    mov dx,Color
    mov dh,dl
    shl edx,8
    mov dl,dh

    mov eax,Poly[bx+Red] ; EAX = polygon color
    add eax,edx
    shr eax,2         ; from 24bit to 18bit color
    and eax,03F3F3FH  ; EAX = palette values

; Hashing function: Red + Green << 1 + Blue << 2

    mov ebx,eax
    shr ebx,16
    mov si,bx
    mov ebx,eax
    and ebx,0FF00H
    shr ebx,7
    add si,bx
    mov ebx,eax
    and ebx,0FFH
    shl ebx,2
    add si,bx

    and si,0FFH
    jnz @DontIncSI    ; color 0 is reserved (used by background)
    inc si
  @DontIncSI:
    mov dx,si         ; DX = palette index
    mov di,dx         ; DI = starting index
    shl si,2          ; SI = palette offset
    and eax,03F3F3FH
    align 2
  @StartPaletteLoop:
    mov ecx,Palette[si]  ; color in current slot
    and ecx,03F3F3FH  ; clears unused bits
    jz @EmptySlot     ; is this slot empty?
    cmp ecx,eax
    je @EndPalette    ; is this the color I was looking for?
    inc dl
    jno @NoOverFlow   ; this is a 256-entries table, so I check for overflow
    mov dx,1
    mov si,0
    align 2
  @NoOverFlow:
    add si,4          ; update slot offset
    cmp di,dx         ; have I started for here?
    je @ErrorTableFull  ; YES: the table is full -> ERROR
    jmp @StartPaletteLoop ; NO: jump back
    align 2
  @EmptySlot:
; the current slot is empty, so I fill it with the required color
    mov Palette[si],eax
    align 2
  @EndPalette:
    mov ax,dx

    push es
    mov si,DGROUP
    add si,Step
    mov es,si              ; ES:SI = Buffer address
    mov cl,NumVertex
    lea si,Plot            ; loads address of Plot structure
    call Polygon           ; draws poly
    mov bx,min
    cmp bx,new_min
    ja nating
    mov new_min,bx
nating:
    mov bx,max
    cmp bx,new_max
    jb notting
    mov new_max,bx
notting:
    pop es
    pop bx
    pop si
    pop di
    jmp @EndDrawPoly
@DontDrawPoly:
  pop bx
@EndDrawPoly:
  ret
@ErrorTableFull: ; this object has more than 255 different colors!
  mov ax,03
  int 10H
  lea dx,TOOMANYCOLORS
  mov ah,09
  int 21H
  mov ah,4CH
  int 21H
DRAWPOLY ENDP

PAINT PROC
      PUBLIC PAINT

; Purpose: updates the palette of the video card
; Registers destroyed: ax bx cx dx ds

  mov dx,03DAH   ; V-Sync : no flickering!
@VSync1:
  in al,dx
  test al,08H
  jnz @VSync1    ; wait for V-Sync

@VSync2:
  in al,dx
  test al,08H
  jz @VSync2     ; wait again for V-Sync

  mov ax,DGROUP
  mov ds,ax
; I update the colors in the palette of the video card
; using I/O ports (they're much faster than BIOS!)
  mov bx,1020
  mov cx,255
  align 2
@SetPalette:
  mov eax,Palette[bx]
  and eax,03F3F3FH
  jz @DontUpdate                  ; black color means unused
  mov dx,03C8H
  mov ax,cx
  out dx,al                       ; selects color to set
  mov dx,03C9H
  mov al,BYTE PTR Palette[bx]
  out dx,al                       ; Red value
  mov al,BYTE PTR Palette[bx+1]
  out dx,al                       ; Green value
  mov al,BYTE PTR Palette[bx+2]
  out dx,al                       ; Blue value
  align 2
@DontUpdate:
  sub bx,4
  dec cx
  jnz @SetPalette
  ret
PAINT ENDP

CLEARPALETTE PROC
             PUBLIC CLEARPALETTE

; Purpose: clears palette array
; Registers destroyed: bx cx
; Assumes DS = data segment

  mov cx,128
  mov bx,0
  align 2
@ClearPal:
  mov Palette[bx],0
  mov Palette[bx+4],0
  add bx,8
  dec cx
  jnz @ClearPal
  ret
CLEARPALETTE ENDP


THREED PROC
       PUBLIC THREED

; Purpose: draws a new image
; Input:    si = DegX
;           di = DegY

  finit
  mov ax,DGROUP
  mov ds,ax               ; Initialize Data Segment
  add ax,4096
  mov es,ax
  inc Iter                ; number of the new image to be rendered
  shl si,3                ; SinCos table is aligned on 8 byte boundaries
  shl di,3
@StartWalk:
  call RESETTA            ; clears video buffer
  mov new_min,-1
  mov new_max,0
  call CLEARPALETTE       ; clears palette array
  mov bx,0                ; Offset of the root polygon is 0
  call DRAW
  mov bx,new_max
  cmp bx,maxdraw
  jb nientamax
  mov maxdraw,bx
nientamax:
  mov bx,new_min
  cmp bx,mindraw
  ja nientamin
  mov mindraw,bx
nientamin:
  call PAINT              ; updates palette
  call COPIA_SU_SCHERMO  ; copies image from video buffer into video memory
  push new_min
  pop mindraw
  push new_max
  pop maxdraw
@End:
  ret
THREED ENDP

INPUTLOOP PROC
          PUBLIC INPUTLOOP

; Purpose: handles mouse actions

@StartInputLoop:
  mov ax,0003H
  int 33H            ; returns mouse position and button status
  cmp bx,0
  ja @EndInputLoop   ; a button was pressed -> quit
  cmp cx,XMouse      ; has X position changed ?
  je  @EqualX        ; No -> jump
  mov XMouse,cx      ; save X position
  mov YMouse,dx      ; save Y position
  mov si,YMouse
  mov di,XMouse
  call THREED
  jmp @StartInputLoop
@EqualX:
  cmp dx,YMouse      ; has Y position changed ?
  je @StartInputLoop ; No -> jump
  mov XMouse,cx      ; save X position
  mov YMouse,dx      ; save Y position
  mov si,YMouse
  mov di,XMouse
  call THREED
  jmp @StartInputLoop
@EndInputLoop:
  ret
INPUTLOOP ENDP

END
