{
  Jaluit -> Fast 3D filter
  developed by Stefano Tommesani
  Purple Haze project
}

uses Crt;

type Point3D=record
             x,y,z:single;
             end;

type BSPPoly=record
             NumVert:byte;
             Red:byte;
             Green:byte;
             Blue:byte;
             Vert:array[1..10] of Point3D;
             Front:WORD;
             Back:WORD;
             end;

type TPoly=record
           Norm:Point3D;
           NumVert:byte;
           Red:byte;
           Green:byte;
           Blue:byte;
           ColorShift:longint;
           Front:word;
           Back:word;
           Vert:array[1..10] of word;
           end;

type TVertex=record
             Iter:longint;
             X:single;
             Y:single;
             Z:single;
             ScreenX:word;
             ScreenY:word;
             end;

var fIn,fOut:file;
    NumPoly:word;
    res:integer;
    Palette:array[0..767] of byte;
    Light:array[1..3] of single;
    tSinCos:array[0..719] of single;
    app:BSPPoly;
    app2:TPoly;
    count,c:word;
    V1,V2:Point3D;
    Norm:single;
    CN:Point3D;
    appVert:array[1..10] of Point3D;
    cRed,cGreen,cBlue:word;
    pIndex:byte;
    index:array[0..1000] of word;
    Vert:array[0..1299] of TVertex;
    VertDef:integer;

procedure BuildIndex;
var prox:word;
begin
reset(fIn,1);
blockread(fIn,NumPoly,2,res);
prox:=0;
for count:=0 to (NumPoly-1) do
  begin
  blockread(fIn,app,sizeof(app),res);
  index[count]:=prox;
  prox:=prox+(24+2*app.NumVert);
  end;
end;

procedure InsertVert(var V:TVertex);
var iter:integer;
    found:boolean;
begin
found:=false;
for iter:=0 to VertDef do
  begin
  if (Vert[iter].X=V.X) and (Vert[iter].Y=V.Y) and (Vert[iter].Z=V.Z)
    then begin
         found:=true;
         exit;
         end;
  end;
if found=false
  then begin
       inc(VertDef);
       Vert[VertDef].X:=V.X;
       Vert[VertDef].Y:=V.Y;
       Vert[VertDef].Z:=V.Z;
       end;
end;

function FindVert(var V:Point3D):integer;
var position:integer;
    iter:integer;
begin
position:=-1;
for iter:=0 to VertDef do
  begin
  if (Vert[iter].X=V.X) and (Vert[iter].Y=V.Y) and (Vert[iter].Z=V.Z)
    then begin
         position:=iter;
         FindVert:=position;
         exit;
         end;
  end;
if position=-1
  then writeln('Errore!!!!!!!!');
FindVert:=position;
end;

procedure BuildVertList;
var temp:TVertex;
    num:integer;
begin
reset(fIn,1);
blockread(fIn,NumPoly,2,res);
for count:=0 to (NumPoly-1) do
  begin
  blockread(fIn,app,sizeof(app),res);
  for num:=1 to app.NumVert do
    begin
    temp.X:=app.Vert[num].X;
    temp.Y:=app.Vert[num].Y;
    temp.Z:=app.Vert[num].Z;
    InsertVert(temp);
    end;
  end;
end;

function ScalarProduct(A,B:Point3D):single;
begin
ScalarProduct:=A.X*B.X+A.Y+B.Y+A.Z+B.Z;
end;

begin
if paramcount=0
  then begin
       writeln('Filter Jaluit->Fast3D - by Stefano Tommesani 96');
       writeln('  filter <Jaluit file> <Fast3D file>');
       halt(1);
       end;
clrscr;
Light[1]:=0.707;
Light[2]:=0.707;
Light[3]:=0;
for count:=0 to 359 do
  begin
  tSinCos[count*2]:=sin(count/180*Pi);
  tSinCos[count*2+1]:=cos(count/180*Pi);
  end;
fillchar(Vert,sizeof(Vert),0);
VertDef:=-1;

assign(fIn,paramstr(1));
reset(fIn,1);
assign(fOut,paramstr(2));
rewrite(fOut,1);
writeln('Filter Jaluit->Fast3D - by Stefano Tommesani 96');
writeln('Building offset array');
BuildIndex;
writeln('Building vertexes list');
BuildVertList;
writeln(VertDef,' vertexes');
reset(fIn,1);
blockread(fIn,NumPoly,2,res);
writeln('Num poly: ',NumPoly);
blockwrite(fOut,Light,sizeof(Light),res);
blockwrite(fOut,tSinCos,sizeof(tSinCos),res);
blockwrite(fOut,Vert,sizeof(Vert),res);
writeln('Converting...');

for count:=1 to NumPoly do
  begin
  blockread(fIn,app,sizeof(app),res);
  app2.NumVert:=app.NumVert;
  app2.Red:=app.Red;
  app2.Green:=app.Green;
  app2.Blue:=app.Blue;
  app2.Front:=index[app.Front];
  app2.Back:=index[app.Back];
  for c:=1 to app2.NumVert do
    appVert[app.NumVert-c+1]:=app.Vert[c];
  move(appVert,app.Vert,sizeof(appVert));

  V1.x:=app.Vert[2].x-app.Vert[1].x;
  V1.y:=app.Vert[2].y-app.Vert[1].y;
  V1.z:=app.Vert[2].z-app.Vert[1].z;
  V2.x:=app.Vert[app.NumVert].x-app.Vert[1].x;
  V2.y:=app.Vert[app.NumVert].y-app.Vert[1].y;
  V2.z:=app.Vert[app.NumVert].z-app.Vert[1].z;
  CN.X:=V1.y*V2.z - V1.z*V2.y;
  CN.Y:=V1.z*V2.x - V1.x*V2.z;
  CN.Z:=V1.x*V2.y - V1.y*V2.x;
  Norm:=sqrt( sqr(CN.X)+sqr(CN.Y)+sqr(CN.Z));
  if Norm<>0
    then begin
        CN.X:=CN.X / Norm;
        CN.Y:=CN.Y / Norm;
        CN.Z:=CN.Z / Norm;
        end;

  app2.Norm.X:=CN.X;
  app2.Norm.Y:=CN.Y;
  app2.Norm.Z:=CN.Z;

  for c:=1 to app2.NumVert do
    begin
    app2.Vert[c]:=FindVert(app.Vert[c])*sizeof(TVertex);
    end;

  blockwrite(fOut,app2,24+2*app2.NumVert,res);
  end;

close(fIn);
close(fOut);
writeln('Num vert: ',VertDef);
end.
