;VESA POLYGONS 1.0 Marchini Andrea matr. 88589 
;Universit di Parma, Facolt di Ingegneria
;Corso di Calcolatori Elettronici, Prof. Gianni Conte
;Libreria completa per la gestione di grafica poligonale in modalit VESA 8bpp
;Versione custom per il renderer FAST3D
;gestione automatica del double buffer per animazioni fluide (magari...)

.MODEL SMALL        

.DATA?
EXTRN MINDRAW:WORD,MAXDRAW:WORD
PUBLIC X_RES,Y_RES,MIN,MAX

BUFFER DD 480 DUP (?,?)     ; scan-line buffer
SHIFTER DB ?                ; valore di shift per aggiustare il valore del banco
MIN DW ?                    ; limite 'superiore' delle ordinate
MAX DW ?                    ; limite 'inferiore' delle ordinate
SEGMENTO DB ?               ; numero del segmento attuale
START DW ?                  ; variabile temp.

MODE_ATTR DW ?
WIN_A_ATTR DB ?
WIN_B_ATTR DB ?
WIN_GRAN DW ?               ; window granularity
WIN_SIZE DW ?               ; window size = 64Kb default per tutte le schede
WIN_A_SEGM DW ?
WIN_B_SEGM DW ?
FUNCTION LABEL DWORD        ; puntatore alla funzione per cambiare banco
WIN_PTR  DW ?
WIN_OFF  DW ?
BYTES_LINE DW ?
X_RES DW ?                  ; x resolution
Y_RES DW ?                  ; y resolution
CHAR_WIDTH DB ?
CHAR_HEIGHT DB ?
PLANES DB ?
BITS_PIXEL DB ?
SPAZIO_IN_PIU DB 250 DUP (?)

.486

.CODE
PUBLIC POLYGON,INIT_VESA,BANCO_VESA,RESETTA,RESETTA_TUTTO,COPIA_SU_SCHERMO

FAI_LINEA PROC
;(ax,dx)-(bp,di) PUNTI DA CONGIUNGERE PER LA SCAN_LINE CONVERSION      
;RIEMPE IL BUFFER CON GLI OPPORTUNI VALORI. USA L'ALGORITMO DI BRESNHAM PER
;IL CALCOLO DEI PUNTI. NON E' L'ALGORITMO PIU' VELOCE MA QUESTA NON E' UNA
;PROCEDURA TIME-CRITICAL. L'IMPLEMENTAZIONE E' STATA CURATA PER QUANTO 
;POSSIBILE. IL FUNZIONAMENTO OTTIMALE DOVREBBE OTTENERSI SU PROCESSORE PENTIUM
;PER IL QUALE SONO STATE RIORDINATE E SCELTE LE ISTRUZIONI ALLO SCOPO DI
;UTILIZZARE AL MEGLIO LE DUE PIPELINE INTERE U E V E DI LIMITARE I BLOCCHI AGI
;(ADDRESS GENERATION INTERLOCK). CONFLITTI DI ACCESSO ALLA CACHE DATI DOVREBBERO
;ESSERE PRESSOCHE' NULLI POICHE' TALE ACCESSO AVVIENE PER 4 BYTES ALLA VOLTA E
;I DATI SONO ALLINEATI SU 32BIT (OGNI BANCO DI CACHE CONTIENE 4 BYTES ALLINEATI)
;DA NOTARE COMUNQUE CHE L'UNICO ACCESSO ALLA MEMORIA E' QUELLO AL BUFFER: PER
;IL RESTO NON VIENE USATA UNA VARIABILE DI MEMORIA.
;NO SELF-MODIFYING CODE ;-)

        PUSH BX
        PUSH CX
        PUSH DI
        PUSH BP
        PUSH SI
        MOV CX,AX
        MOV SI,BP
        CMP CX,SI                       ;QUAL E' IL VERTICE PIU' A DESTRA?
        JL ORDINATI                     ;SE CX<SI -> ORDINATI DA SX A DX
        MOV CX,SI                       ;SCAMBIA LE COORDINATE
        MOV SI,AX
        MOV AX,DX
        MOV DX,DI
        MOV DI,AX
ORDINATI:                              
        
        AND EAX,65535                   ;RESETTA LA WORD ALTA DI QUESTI REGS.
        AND EBX,65535
        AND ECX,65535
        AND EDX,65535
        AND ESI,65535

        MOV BX,DX                       ;BX=BP= Y DEL PRIMO PUNTO
        MOV AX,DI                       ;AX=    Y DEL SECONDO PUNTO
        MOV BP,DX

        SHL BX,2                        ;MOLTIPLICA PER 4
        SHL AX,2                        ;MOLTIPLICA PER 4
        SHL BP,3                        ;MOLTIPLICA PER 8

        ADD BX,DX                       ;BX MOLTIPLICATO PER 5
        ADD AX,DI                       ;AX MOLTIPLICATO PER 5
        LEA BP,[BP+OFFSET BUFFER]       ;BP PUNTA ALLA PRIMA LINEA NEL BUFFER

        SHL EBX,7                       ;MOLTIPLICA PER 128, IN TUTTO PER 640
        SHL EAX,7                       ;MOLTIPLICA PER 128, IN TUTTO PER 640

        ADD EBX,ECX                     ;AGGIUNGI A EBX L'ASCISSA DEL PRIMO
                                        ;PUNTO
        ADD EAX,ESI                     ;AGGIUNGI A EAX L'ASCISSA DEL SECONDO
                                        ;PUNTO

        ADD EDX,00080000H               ;INIZIALIZZA LA WORD ALTA AD 8
        SUB SI,CX                       ;SI = DELTAX
        MOV CX,DX                       ;SCAMBIA DX E DI    /
        MOV DX,DI                       ;LISCA DI PESCE    //
        MOV DI,CX                       ;NO REGS.CONFLICT  // 
        MOV ECX,640                     ;DIREZIONE: GIU'
        SUB DX,DI                       ;IN DX C'E' DELTAY, MA SARA' POSITIVO?
        JA POSITIVO
        NEG DX                          ;NO! QUINDI IL SEGMENTO VA IN SU
        NEG ECX                         ;DIREZIONE: SU
        ADD EDX,0FFF00000H              ;WORD ALTA DI EDX E' -8
POSITIVO:                               ;SI! ORA E' POSITIVO
        MOV DI,BP                       ;DI OFFSET SCAN-LINE BUFFER
        MOV EBP,ECX                     ;DELTA OFFSET
        MOV CX,SI                       ;CX A POSTO CX=SI
COMINCIA_IL_LOOP:
        CMP EBX,DWORD PTR DS:[DI]       ;E' IL LIMITE SX PER QUESTA ORDINATA
        JA NON_E_ESTREMO_SINISTRO
        MOV DWORD PTR DS:[DI],EBX       ;SI'
NON_E_ESTREMO_SINISTRO:
        CMP EBX,DWORD PTR DS:[DI+4]     ;E' IL LIMITE DX PER QUESTA ORDINATA               
        JB NON_E_ESTREMO_DESTRO
        MOV DWORD PTR DS:[DI+4],EBX     ;SI'
NON_E_ESTREMO_DESTRO:
        CMP EBX,EAX                     ;CONFRONTA OFFSET ATTUALE CON QUELLA
                                        ;FINALE
        JZ FINE
        TEST SI,32768                   ;SI E' NEGATIVO?
        JNZ INC_Y
        SUB SI,DX                       ;(COUNTERX-=DELTAY)>0
        JG INC_X
INC_Y:
        ROR EDX,16                      ;PORTA LA WORD ALTA IN BASSO
        ADD EBX,EBP                     ;AGGIUNGERE A EBX DELTA OFFSET
        ADD DI,DX                       ;AGGIORNA IL PUNTATORE
        ROR EDX,16                      ;RIPORTARE IN DX DELTAY
        ADD SI,CX                       ;AGGIUNGERE A SI DELTAX
        JS COMINCIA_IL_LOOP
INC_X:
        INC EBX                         ;INCREMENTA OFFSET ATTUALE
        JMP COMINCIA_IL_LOOP
FINE:
        POP SI                          ;RIPRISTINA I REGISTRI UTILI
        POP BP
        POP DI
        POP CX
        POP BX
        RET

FAI_LINEA ENDP

POLYGON PROC ;DS:SI:VERTICI, AL COLORE, CL:NUMERO VERTICI
;DISEGNA IL POLIGONO IN UNA QUALSIASI MODALITA' VIDEO (640X480 IN QUESTO
;CASO). DOPO AVER EFFETTUATO LA SCAN-LINE CONVERSION DEL POLIGONO, DISEGNA
;LE LINEE ORIZZONTALI CHE UNISCONO GLI ESTREMI PER OGNI RIGA: CREDO CHE SIA
;L'ALGORITMO PIU' VELOCE E PIU' USATO ANCHE SE NON NE HO MAI VISTO ALTRI.
;SONO A CONOSCENZA DEL FATTO CHE QUANDO IL MODO VIDEO IMPOSTATO E' ORGANIZZATO
;IN PIANI ANZICHE' BANCHI (PIANI RED,GREEN E BLUE) PUO' ESSERE CONVENIENTE
;EFFETTUARE UNO SCAN-LINE VERTICALE ANZICHE' ORIZZONTALE PER POTER CARICARE 
;PIU' FACILMENTE IL LATCH. ANCHE QUESTO CODICE E' STATO OTTIMIZZATO PER 
;PROCESSORE PENTIUM E COMPATIBILI.

        PUSHA                           ;SALVA TUTTI I REGISTRI GENERALI 16BIT
        PUSH ES                         ;METTI ES NELLO STACK
        POP START                       ;E PONILO IN START
        MOV MIN,-1                      ;RESETTA IL VALORE DELLA MIN Y
        MOV MAX,0                       ;RESETTA IL VALORE DELLA MAX Y
        MOV SEGMENTO,0                  ;PARTIAMO DAL PRIMO SEGMENTO
        XOR CH,CH                       ;RESETTA IL BYTE ALTO DEI LATI
        PUSH AX                         ;SALVA IL COLORE
        PUSH CX                         ;SALVA IL NUMERO DI LATI
        DEC CL                          ;UNIAMO I PRIMI N-1 LATI
        XOR BX,BX                       ;PARTI DAL PRIMO VERTICE
        MOV AX,WORD PTR [SI]            ;ASCISSA DEL PRIMO VERTICE
        MOV DX,WORD PTR [SI+2]          ;ORDINATA DEL PRIMO VERTICE
PROSSIMO_SEGMENTO:
        MOV BP,WORD PTR [SI+BX+4]       ;ASCISSA DEL SECONDO ESTREMO
        MOV DI,WORD PTR [SI+BX+6]       ;ORDINATA DEL SECONDO ESTREMO
        CALL FAI_LINEA                  ;DELIMITA IL POLIGONO     
        MOV AX,BP                       ;IL SECONDO ESTREMO ORA DIVENTA IL... 
        MOV DX,DI                       ;... PRIMO!
        ADD BX,4                        ;INCREMENTA LA BASE
        DEC CX                          ;DECREMENTA IL CONTATORE
        JNZ PROSSIMO_SEGMENTO           ;ALTRO LATO
        MOV BP,WORD PTR [SI]            ;ASCISSA DEL PRIMO VERTICE                    
        MOV DI,WORD PTR [SI+2]          ;ORDINATA DEL PRIMO VERTICE
        CALL FAI_LINEA                  ;DELIMITA IL POLIGONO
        POP CX                          ;RIPRISTINA IL NUMERO DI LATI
        POP AX                          ;RIPRISTINA IL COLORE
        MOV BX,2                        ;SELEZIONA SOLO LE ORDINATE
CONFRONTA_NUOVA_RIGA:        
        MOV DX,WORD PTR [SI+BX]         ;OTTIENI L'ORDINATA DEL VERTICE
        CMP DX,MIN                      ;E' INFERIORE AL MINIMO?
        JA NIENTE_DA_FARE               ;
        MOV MIN,DX                      ;SI! NUOVO MINIMO
NIENTE_DA_FARE:
        CMP DX,MAX                      ;E' SUPERIORE AL MASSIMO?
        JB NIENTE_DA_FARE_2             ;
        MOV MAX,DX                      ;SI! NUOVO MASSIMO
NIENTE_DA_FARE_2:
        ADD BX,4                        ;PROSSIMO VERTICE
        DEC CX                          ;DECREMENTA CONTATORE
        JNZ CONFRONTA_NUOVA_RIGA        ;ALTRO VERTICE
        MOV CX,MAX                      
        MOV BX,MIN
        SUB CX,MIN
        SHL BX,3                        ;BX INDICE DELLA BASE
        INC CX                          ;CX NUMERO DI RIGHE
        MOV BP,START                    ;SEGMENTO BASE
CICLO_PRINCIPALE:
        PUSH CX                         ;SALVA IL NUMERO RI RIGHE RESTANTI
        MOV ECX,BUFFER[BX+4]            ;OFFSET DEL LIMITE DESTRO
        MOV EDI,BUFFER[BX]              ;OFFSET DEL LIMITE SINISTRO
        MOV BUFFER[BX],-1               ;RESETTA IL LIMITE SINITRO
        MOV BUFFER[BX+4],0              ;RESETTA IL LIMITE DESTRO
        SUB ECX,EDI                     ;PIXEL DELLA RIGA - 1
        MOV EDX,EDI                     ;
        ROR EDX,16                      ;PORTA LA WORD ALTA... IN BASSO
        CMP DL,SEGMENTO                 ;CONFRONTA IL SEGMENTO VOLUTO CON
                                        ;QUELLO ATTUALE
        JZ CONTINUA
        XOR DH,DH                       ;NON COINCIDONO: RICALCOLA
        MOV SEGMENTO,DL                 ;IMPOSTA IL NUOVO SEGMENTO
        SHL DX,12                       ;MOLTIPLICA PER 4096
        ADD DX,BP                       ;AGGIUNGI IL SEGMENTO BASE
        MOV ES,DX                       ;IMPOSTA ES
CONTINUA:
        INC ECX                         ;NUMERO DI PIXEL NELLA RIGA
        JZ NON_DISEGNARE_PIU            ;SE NON CE NE SONO.. NON DISEGNARE
PROSSIMO_PUNTO:
        MOV BYTE PTR ES:[DI],AL         ;DISEGNA IL PIXEL
        INC DI                          ;PUNTA AL PROSSIMO PIXEL
        JZ CAMBIARE_SEGMENTO            ;SE E' ZERO CAMBIARE SEGM.       
NON_CAMBIARE_SEGMENTO:
        DEC CX                          ;DECREMENTA IL CONTATORE
        JNZ PROSSIMO_PUNTO              ;PROSSIMO PUNTO
        ADD BX,8                        ;PUNTA ALLA PROSSIMA RIGA
NON_DISEGNARE_PIU:
        POP CX                          ;RIPRISTINA IL NUMERO DI RIGHE RIMANENTI
        DEC CX                          ;DECREMENTALO
        JNZ CICLO_PRINCIPALE            ;SE NON E' ZERO, ALTRA LINEA
        PUSH START                      ;RIPRISTINA ES
        POP ES
        POPA                            ;RIPRISTINA I REGISTRI
        RET                             ;RITORNA
CAMBIARE_SEGMENTO:
        INC SEGMENTO                    ;ALTRIMENTI.. AVANTI IL PROSSIMO
        MOV DX,ES                       ;OTTIENI ES...
        ADD DX,4096                     ;...SALTA IL SEGMENTO ATTUALE...
        MOV ES,DX                       ;...REIMPOSTA ES!
        JMP NON_CAMBIARE_SEGMENTO

POLYGON ENDP

INIT_VESA PROC
;QUESTA PROCEDURA INIZIALIZZA ALCUNI VALORI FONDAMENTALI PER LA GESTIONE
;DELLE RISORSE DELLA SCHEDA VIDEO VESA. QUESTO CODICE E' FRUTTO DI TENTATIVI
;DA ME EFFETTUATI IN MANCANZA DI NOTIZIE PIU' PRECISE (!). MEDIANTE LUNGHE
;SESSIONI DI DEBUGGING SONO GIUNTO AD ALCUNE CONCLUSIONI: 
;1) L'INTERFACCIA VESA 1.2 NON E' MOLTO COMODA A CAUSA DELLA SEGMENTAZIONE
;2) NON E' NEMMENO MOLTO VELOCE PERCHE' BISOGNA CONTROLLARE PERIODICAMENTE
;   LA PROPRIA POSIZIONE NELLA FINESTRA VIRTUALE ED EVENTUALMENTE CHIAMARE
;   UNA FUNZIONE FAR PER CAMBIARE FINESTRA (E QUINDI BANCO)

        PUSHA                   ;SALVA TUTTI I REGISTRI... IN UN BYTE (QUASI)
        MOV AX,04F03H           ;OTTIENI L'ATTUALE MODO VIDEO
        INT 10H                 ;CHIAMA IL BIOS
        MOV CX,BX               ;ECCO IL MODO VIDEO IMPOSTATO
        MOV AX,04F01H           ;OTTIENI INFORMAZIONI SUL MODO VIDEO ATTUALE
        PUSH ES                 ;SALVA ES
        PUSH DS                 ;E IMPOSTALO A DS
        POP ES
        LEA DI,MODE_ATTR        ;PUNTA ALLA TABELLA              
        INT 10H                 ;CHIAMA IL BIOS (PER OGGI NE HA ABBASTANZA)
        POP ES                  ;RIPRISTINA ES
        MOV AX,64               ;64kB...
        MOV BX,WIN_GRAN         ;...DIVISO LA GRANULARITA'...
        XOR DX,DX               ;...DOVREBBE DARE IL NUMERO DI SEGMENTI CHE...
        DIV BX                  ;...SEPARANO UNA FINESTRA DALL'ALTRA!
        BSR CX,AX               ;E' SEMPRE UN MULTIPLO DI 2 E ALLORA CALCOLA...
        MOV SHIFTER,CL          ;...CX=LOG2(AX) E IMPOSTA IL SHIFTER
        MOV CX,480              ;PER QUESTO PROGRAMMA, LA M.V. E' 640X480
        XOR SI,SI               ;INDICE
RESETTA_IL_BUFFER:
        MOV BUFFER[SI],-1       ;RESETTA IL BUFFER CHE ERA NEL BSS
        MOV BUFFER[SI+4],0
        ADD SI,8
        DEC CX
        JNZ RESETTA_IL_BUFFER
        POPA                    ;RIPRISTINA I REGISTRI
        RET                     ;TORNA

INIT_VESA ENDP

BANCO_VESA PROC
;QUESTA PROCEDURA SERVE A PERDERE UN PO' DI TEMPO CAMBIANDO BANCO E QUINDI
;FINESTRA VIRTUALE
;AX BANCO

        PUSHA                           ;SALVA TUTTI I REGS.
        PUSH DS                         ;E ANCHE DS
        MOV DX,DGROUP
        MOV DS,DX                       ;PUNTA AL SEGM. DATI
        MOV CL,SHIFTER                  ;OTTIENI IL SHIFTER
        SHL AX,CL                       ;E SHIFTA
        MOV DX,AX                       ;DX E' IL BANCO
        CLI                             ;FERMA GLI INTERRUPTS MASCHERABILI
                                        ;(TUTTI TRANNE IL 2)
        MOV BX,1                        ;SOLO PER LA SCRITTURA (LETTURA BX=0)
        CALL DWORD PTR FUNCTION         ;E CAMBIA
        STI                             ;VABBE', ADESSO POTETE!
        POP DS                          ;RIPRISTINA DS
        POPA                            ;E I REGISTRI GENERALI
        RET                             ;TORNA

BANCO_VESA ENDP

RESETTA PROC
;QUESTA SEMPLICE ROUTINE SERVE PER CANCELLARE IL DOPPIO BUFFER (1 CY/BYTE).
;E' ABBASTANZA VELOCE.
;ES : SEGMENTO DI INIZIO DEL DOUBLE BUFFER

        PUSH AX                         ;SALVA I REGISTRI
        PUSH CX
        PUSH DX
        PUSH DI
        PUSH ES
        XOR EDI,EDI                     ;AZZERA LA WORD ALTA
        MOV DI,MINDRAW                  ;PARTI DALL'ALTO
        MOV EAX,EDI                     ;MOLTIPLICA PER 640 EDI
        SHL DI,2
        ADD DI,AX
        SHL EDI,7
        ADD EDI,80                      ;PARTI DA X=80
        MOV EAX,EDI     
        SHR EAX,16                      ;OTTIENI LA WORD ALTA -> SEGMENTO
        SHL AX,12                       ;MOLTIPLICA PER 4096 PARAGRAFI = 64Kb
        MOV CX,ES
        ADD AX,CX
        MOV ES,AX                       ;AGGIORNA IL SEGMENTO
        MOV CX,MAXDRAW
        SUB CX,MINDRAW
        INC CX                          ;NUMERO DI RIGHE
        MOV DX,160                      ;DELTA OFFSET A FINE RIGA
        XOR EAX,EAX                     ;PATTERN
CICLO_DI_RESET:
        PUSH CX                         ;SALVA LE RIGHE
        MOV CX,30                       ;NUMERO DI 4-DWORD PER RIGA
PICCOLO_UNROLLING:
        MOV DWORD PTR ES:[DI],EAX       ;CANCELLA!      L'UNROLLING E' MINIMO
        MOV DWORD PTR ES:[DI+4],EAX     ;CANCELLA!!       PERCHE' SU PENTIUM
        MOV DWORD PTR ES:[DI+8],EAX     ;CANCELLA!!!       CONTA ANCHE LA 
        MOV DWORD PTR ES:[DI+12],EAX    ;CANCELLA!!!!    DIMENSIONE DEL LOOP
        ADD DI,16                       ;ALTRI 16 BYTE
        JZ CAMBIA_SEGMENTO_FINALMENTE   ;SEGMENTO DA CAMBIARE
PUNTO_DI_RITORNO:
        DEC CX                          ;LOOOOOP...
        JNZ PICCOLO_UNROLLING           ;...UNROLLLLING (MA NON TROPPO)
        ADD DI,DX                       ;PARTI DA X=80 PER LA NUOVA RIGA
        POP CX                          ;RIPRISTINA LE RIGHE RIMANENTI
        DEC CX                          ;DECREMENTA LE RIGHE
        JNZ CICLO_DI_RESET              ;SALTA
        JMP FINE_DEL_TUTTO
CAMBIA_SEGMENTO_FINALMENTE:
        MOV AX,ES                       ;SALTA IL SEGMENTO ATTUALE...
        ADD AX,4096
        MOV ES,AX                       ;E RIPRISTINA ES
        XOR AX,AX                       ;RIPRISTINA AX
        JMP PUNTO_DI_RITORNO
FINE_DEL_TUTTO:
        POP ES
        POP DI
        POP DX
        POP CX
        POP AX
        RET

RESETTA ENDP

RESETTA_TUTTO PROC
;QUESTA ROUTINE VIENE USATA UNA SOLA VOLTA PER CANCELLARE LA MEMORIA CHE VERRA'
;OCCUPATA DAL DOPPIO BUFFER.

        PUSH AX 
        PUSH CX
        PUSH DX
        PUSH DI
        PUSH ES
        XOR EAX,EAX
        XOR EDX,EDX
        MOV AX,Y_RES
        MUL X_RES
        SHL EDX,16
        XOR DI,DI
        ADD EDX,EAX
        XOR EAX,EAX
        MOV ECX,EDX
CICLO_PER_RESETTARE_TUTTO:
        PUSH CX
        MOV CX,8192
CANCELLA_QWORD:
        MOV DWORD PTR ES:[DI],EAX
        MOV DWORD PTR ES:[DI+4],EAX
        ADD DI,8
        DEC CX
        JNZ CANCELLA_QWORD
        POP CX
        SUB ECX,65536
        MOV DX,ES
        ADD DX,4096
        MOV ES,DX
        CMP ECX,65535
        JA CICLO_PER_RESETTARE_TUTTO
        SHR CX,1
CANCELLA_WORD:
        MOV WORD PTR ES:[DI],AX
        ADD DI,2
        DEC CX
        JNZ CANCELLA_WORD
        POP ES
        POP DI        
        POP DX
        POP CX
        POP AX
        RET

RESETTA_TUTTO ENDP

COPIA_SU_SCHERMO PROC
;QUESTA E' UNA PROCEDURA ASSOLUTAMENTE TIME-CRITICAL: DEVE SCRIVERE FINO
;A 230400 BYTE IN MEMORIA VIDEO PER FRAME. PER CERCARE LE MIGLIORI PRESTAZIONI
;SONO STATI EFFETTUATI INNUMEREVOLI BENCHMARKS SU DIVERSE SCHEDE VIDEO TRA LE
;PIU' DIFFUSE (ET4000, S3, CL54XX) ED IL RISULTATO NON E' COMUNQUE SODDISFACENTE
;QUANDO ARRIVERA' VESA 2...
;ES : SEGMENTO DI INIZIO DEL DOUBLE BUFFER

        PUSH AX                         ;SALVA I REGISTRI
        PUSH BX
        PUSH CX
        PUSH DX
        PUSH DI
        PUSH DS
        PUSH ES
        XOR EDI,EDI                     ;AZZERA LA WORD ALTA
        MOV DI,MINDRAW                  ;PARTI DALL'ALTO
        MOV EAX,EDI                     ;MOLTIPLICA PER 640 EDI
        SHL DI,2
        ADD DI,AX
        SHL EDI,7
        ADD EDI,80                      ;PARTI DA X=80
        MOV EAX,EDI     
        SHR EAX,16                      ;OTTIENI LA WORD ALTA -> SEGMENTO
        MOV BX,AX
        CALL BANCO_VESA
        SHL AX,12                       ;MOLTIPLICA PER 4096 PARAGRAFI = 64Kb
        MOV CX,ES
        ADD AX,CX
        MOV ES,AX                       ;AGGIORNA IL SEGMENTO
        MOV CX,MAXDRAW
        SUB CX,MINDRAW
        INC CX                          ;NUMERO DI RIGHE
        MOV AX,ES
        MOV DS,AX
        MOV AX,0A000H
        MOV ES,AX
        MOV DX,160                      ;DELTA OFFSET A FINE RIGA
        XOR EAX,EAX                     ;PATTERN
CICLO_DI_COPIA:
        PUSH CX                         ;SALVA LE RIGHE
        MOV CX,120                       ;NUMERO DI 4-DWORD PER RIGA
PICCOLO_UNROLLING_2:
        MOV EAX,DWORD PTR DS:[DI]       ;LOAD
        MOV DWORD PTR ES:[DI],EAX       ;STORE - BUONA PARTE DEL CICLO
        ADD DI,4                        ;ALTRI 4 BYTE
        JZ CAMBIA_SEGMENTO_FINALMENTE_2 ;SEGMENTO DA CAMBIARE
PUNTO_DI_RITORNO_2:
        DEC CX                          ;LOOP
        JNZ PICCOLO_UNROLLING_2         ;SALTA
        ADD DI,DX                       ;PARTI DA X=80 PER LA NUOVA RIGA
        POP CX                          ;RIPRISTINA LE RIGHE RIMANENTI
        DEC CX                          ;DECREMENTA LE RIGHE
        JNZ CICLO_DI_COPIA              ;SALTA
        JMP FINE_DEL_TUTTO_2
CAMBIA_SEGMENTO_FINALMENTE_2:
        MOV AX,DS                       ;SALTA IL SEGMENTO ATTUALE...
        ADD AX,4096
        MOV DS,AX                       ;E RIPRISTINA ES
        INC BX
        MOV AX,BX
        CALL BANCO_VESA
        XOR AX,AX                       ;RIPRISTINA AX
        JMP PUNTO_DI_RITORNO_2
FINE_DEL_TUTTO_2:
        POP ES
        POP DS
        POP DI
        POP DX
        POP CX
        POP BX
        POP AX
        RET

COPIA_SU_SCHERMO ENDP


END
