/***********************************************************************
 *                                                                     *
 * RANDINT                                                             *
 *                                                                     *
 * Sample DLL for use with Procomm Plus for Windows.                   *
 *                                                                     *
 * This DLL module allows a user to generate a random number to be     *
 * used within the Aspect language.                                    *
 *                                                                     *
 ***********************************************************************/
/***********************************************************************
 *                                                                     *
 * Code Disclaimer                                                     *
 *                                                                     *
 * This sample is provided as a service to you.  DATASTORM does not in *
 * any way warrant the source code, nor do we commit to any support on *
 * this sample file.                                                   *
 *                                                                     *
 ***********************************************************************/

#include <windows.h>
#include <stdlib.h>

#define IntegerType 1

int FAR PASCAL LibMain( HANDLE, WORD, WORD, LPSTR );
int FAR PASCAL RandomInt( HWND, HANDLE, void far * far *, LPBYTE, int );
int FAR PASCAL WEP( int );

HANDLE hInst;

int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
  LPSTR lpszCmdLine )
{
  if (cbHeapSize)
    UnlockData(0);    /* make the data segment moveable */
	hInst = hInstance;
	return(TRUE);
}

int FAR PASCAL RandomInt( HWND PWWnd, HANDLE PWInst,
	void far * far *vdatptr, LPBYTE vtypeptr, int argcnt )
{
	if ( argcnt < 1 )                     /* at least one argument? */
		return( FALSE );                    /* if not, return FAILURE */
	if ( vtypeptr[0] != IntegerType )     /* is first arg an integer? */
		return( FALSE );                    /* if not, return FAILURE */
	if ( argcnt > 1 ) {                   /* more arguments? */
		if ( vtypeptr[1] != IntegerType )   /* is second argument an integer? */
			return( FALSE );                  /* if not, return FAILURE */
		srand( *(int far *)vdatptr[0] );    /* seed the generator with arg */
		*(int far *)vdatptr[1] = rand();    /* get a random number */
	}
	else {
		srand( (unsigned)GetCurrentTime() );    /* seed the generator with time */
		*(int far *)vdatptr[0] = rand();    /* get a random number */
	}
	return( TRUE );                       /* return SUCCESS to Aspect */
}

int FAR PASCAL WEP( int bSystemExit )
{
	return(TRUE);
}
