/* Glob support for MS-DOS PERL
 * 
 * Copyright 1992, Stuart G. Phillips
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * To compile without a makefile use the following command:
 *
 *		bcc -ms -eperlglob perlglob.c
 *
 * and stand back !.
 */

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>

/* The following define controls how many files we will process.
 * 1024 *should* be big enough for most DOS systems.
 */

#define NFNAMES	1024


#define TRUE	1
#define FALSE	0

char fnames[NFNAMES][14];
int sort_function(const void *a, const void *b);

void main(int argc, char *argv[])
{
	struct ffblk fb;
	char *env, *s;
	int no_more = FALSE, i, uc = FALSE, nf = 0;

	if (argc < 2)
		exit(1);

	if ((env = getenv("PERLGLOB")) != NULL) 
		if (env[0] == 'U' || env[0] == 'u')
			uc = TRUE;

	for (i = 1; i <argc; i++) {
		no_more = findfirst(argv[i],&fb,0);
		while (!no_more && nf < NFNAMES) {
			if (!uc)
				strlwr(fb.ff_name);
			strcpy(fnames[nf++],fb.ff_name);
			no_more = findnext(&fb);
		}
	}

done_search:

	qsort(fnames, nf, 14, sort_function);

	for (i=0; i < nf; i++)
		printf("%s\n",fnames[i]);

	exit(0);
}

int sort_function(const void *a, const void *b)
{
	return(strcmp((char *)a,(char *)b));
}
