#include "EXTERN.h"
#include "perl.h"

char *savestr();
unsigned long heapfree();
unsigned long stkfree();

static enum usersubs {
    US_heapfree,
    US_stkfree,
};

static int usersub();

int
init_dos()
{
    char *filename = "doslocal.c";

#define MAGICVAR(name, ix) uf.uf_index = ix, magicname(name, &uf, sizeof uf)

    make_usub("heapfree",	US_heapfree,	usersub, filename);
    make_usub("stkfree",	US_stkfree,	usersub, filename);
};

static int
usersub(ix, sp, items)
int ix;
register int sp;
register int items;
{
    STR **st = stack->ary_array + sp;
    register int i;
    register char *tmps;
    register STR *Str;		/* used in str_get and str_gnum macros */

    switch (ix) {
    case US_heapfree:
	if (items != 0)
	    fatal("Usage: &heapfree()");
	else {
	    unsigned long retval;

	    retval = heapfree();
	    str_numset(st[0], (double) retval);
	}
	return sp;

    case US_stkfree:
	if (items != 0)
	    fatal("Usage: &stkfree()");
	else {
	    unsigned long retval;

	    retval = stkfree();
	    str_numset(st[0], (double) retval);
	}
	return sp;

    default:
	fatal("Unimplemented user-defined subroutine");
    }
    return sp;
}
