/* off-line.cpp    Reads the PCBoard DIR files and changes the date to OFF-LINE */

#include <conio.h>
#include <process.h>
#include <stdio.h>
#include <string.h>

struct
   {
   char rec1[23];
   char rec2[57];
   } rec4;

void main(int argc,char* argv[])
   {
                                 /* Define variables */
   unsigned end=99999;
   unsigned dirext=1;            /* the '01' in directory name DL01 */
   char  dirfile[12+1];
   char  buffer[80];
           
   FILE *infile;                 /* define files */
   FILE *outfile;
                                 /* command line arg */

   clrscr();
      
   if (argc == 2) /* if command line parm is given, process that file */
      {
      strcpy(dirfile,(char *)argv[1]);
      end=2;      /* process one file, (< 2) */
      }     
   for(dirext=1; dirext < end; dirext++)    /* main processing loop      */
      {     
      unlink("DIR.$$$");                    /* delete temp file if exists */
      if (argc == 1)     
         sprintf(dirfile,"%s%02d","DIR",dirext); /* build dirfile("DIR01") */
      
      if (rename(dirfile,"DIR.$$$") != 0)   /* rename real file to temp file */
         {
         printf("%s%s\n","Can't process file: ",dirfile);
         exit(1);
         }
      if((infile=fopen("DIR.$$$","r"))==NULL)   /* open input file */
         {
         printf("Error opening input file");
         exit(1);
         }
      if((outfile=fopen(dirfile,"w+"))==NULL)   /* open output file */
         {
         printf("Error opening output file");
         exit(1);
         }
      memset(buffer,'\0',sizeof(buffer));       /* clear buffer */
      fgets(buffer,80,infile);                  /* get first record */
      do
         {
         strcpy(rec4.rec1,buffer);
         if(buffer[23] >= '0' && buffer[23] <= '9' &&     /* if date in col */
   	      buffer[24] >= '0' && buffer[24] <= '9' &&     /* 24 thru 31     */
            buffer[25] == '-'                      &&
	         buffer[26] >= '0' && buffer[26] <= '9' &&
            buffer[27] >= '0' && buffer[27] <= '9' &&
	         buffer[28] == '-'                      &&
            buffer[29] >= '0' && buffer[29] <= '9' &&
            buffer[30] >= '0' && buffer[30] <= '9'   )
            {
            strncpy(rec4.rec2,"OFF-LINE",8);
            strcpy(buffer,rec4.rec1);
            }
         printf(buffer);                    /* show user the line */
         fputs(buffer,outfile);             /* write the record */
         memset(buffer,'\0',sizeof(buffer));
         fgets(buffer,80,infile);           /* get next record  */
         } while(!feof(infile));            /* end of do{} loop */
           
      fclose(infile);
      fclose(outfile);
      unlink("DIR.$$$");                    /* delete old file */
      }
   }
