/*
 * COMAVAIL --- COM port availability
 */

#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

int
main(int argc, char **argv)
{
    char path[64];
    int port, rc;

    if (argc < 3)
    {
	fprintf(stderr, "usage: comavail portnumber command [args]\n");
	return 255;
    }
    if ((port = atoi(argv[1])) < 1 || port > 8)
    {
	fprintf(stderr, "comavail: port number must be between 1 and 8\n");
	return 255;
    }
    strcpy(path, getenv("TEMP"));
    strcat(path, "\\LOCK_");
    strcat(path, argv[1]);
    strcat(path, ".LCK");
    if ((port = open(path, O_WRONLY|O_CREAT|O_EXCL, 0666)) == -1)
    {
	perror("comavail: can't lock");
	return 255;
    }
    close(port);
    if ((rc = spawnvp(P_WAIT, argv[2], argv + 2)) == -1)
	perror("comavail: can't run program");
    if (unlink(path) != 0)
	perror("comavail: can't unlock");
    return rc;
}