
/*-------------------------------[ Vlib ]------------------------------*/
/*                      Text File Viewer Library                       */
/*---------------------------------------------------------------------*/
/* Written by: Jeff Dunlop                                             */
/* Copyright 1991 DB/Soft Publishing Co. All Rights Reserved           */
/*---------------------------------------------------------------------*/

/*--------------------------[ vlibdemo.c ]-----------------------------*/
/*                        Demo shell for VLib                          */
/*---------------------------------------------------------------------*/

#include <stdio.h>

#include "vlib.h"

/*--------------------------------------------------------------*/
/*---------------------------[ main ]---------------------------*/
/*--------------------------------------------------------------*/

int main(int argc, char *argv[])
{
    int Fore = vlIsMono() ? LIGHTGREY : YELLOW,
        Back = vlIsMono() ? BLACK : BLUE;

    BORDER bd_info = {{1}, {"Ŀ"}, {YELLOW}, {BLUE}};

    if ( vlIsMono() )
    {
        bd_info.Foreground = LIGHTGREY;
        bd_info.Background = BLACK;
    }

    if ( argc < 2 )
    {
        puts("\nVlibDemo v.1.00");
        puts("Copyright 1992 DB/Soft Publishing Co.");
        puts("All Rights Reserved");
        puts("\nSyntax: VlibDemo <view file>");
        printf("\n%d Rows, %d Columns at %x were detected\n", vlGetRows(),
            vlGetCols(), vlGetVidbase());
        printf("Vga/Ega was %sdetected\n", vlIsEgaVga() ? "": "not ");
        printf("Desqview was %sdetected\n", vlIsDV() ? "": "not ");
        printf("Video is in mode %d ", vlGetVidMode());

    }
    else
    {
        vlLister(argv[1], 1, 1, vlGetCols() - 2, vlGetRows() - 2,
            Fore, Back, 0x2000, &bd_info);
    }
    return 0;
}
