( this file simulates a Hamming error correction system. a code is calculated 
  in the transmitter, the integrity is checked in the receiver, and a channel
  is simulated which inserts errors based on an adjustable random number
  generator)



VOCABULARY HAMMING
HAMMING                     ( SET CONTEXT TO HAMMING)
HAMMING DEFINITIONS         ( ADD DEFINITIONS TO HAMMING VOCABULARY)
( --------------------USEFUL WORDS ---------------------------------------)
: MOD2+     ( N1,N2--MOD2_N3)  + 01 AND ;
: 3SHR   ( N1--N1_SHIFTED)  2* 2* 2* ;
: 2^N  ( N1--2^N1)   DUP 0= IF DROP 1 ELSE 1 SWAP 0 DO 2* LOOP THEN ;

( ---------------------------TRANSMITTER----------------------------------)
7 VECTOR     TX'D
: D1!D2!D3!D4!  ( N--)  4 0 DO    DUP  I 2^N  AND
IF 1   3 I -   TX'D !   ELSE 0   3 I -   TX'D ! THEN      LOOP DROP ;

( CHECK BIT CALCULATION)
: D5!  ( --D5)  01  TX'D @   02  TX'D @   03  TX'D @  MOD2+ MOD2+
               IF 1 04  TX'D ! ELSE 0  04  TX'D ! THEN   ;
: D6!  ( --D6)  00  TX'D @   02  TX'D @   03  TX'D @  MOD2+ MOD2+
               IF 1 05  TX'D ! ELSE 0  05  TX'D ! THEN   ;
: D7!  ( --D7)  00  TX'D @   01  TX'D @   03  TX'D @  MOD2+ MOD2+
               IF 1 06  TX'D ! ELSE 0  06  TX'D ! THEN   ;

( TRANSMITTER ACCESS)
: TX'ER!  ( DATA--)  D1!D2!D3!D4!    D5! D6! D7!  ;
: TX'ER@   ( --) 0   7 0 DO   I TX'D @    6 I -  2^N *  +  LOOP  ;

( ----------------------------RECEIVER------------------------------------)
7 VECTOR RX'D
: RX'ER@   ( --) 0   7 0 DO   I RX'D @    6 I -  2^N *  +  LOOP  ;
: RX'ER!   ( --)  7 0 DO   DUP   I 2^N AND
IF 1   6 I -   RX'D !    ELSE 0   6 I -   RX'D !    THEN LOOP DROP ;
( SYNDROME CALCULATION, BIT CORRECTION)
: S1  03 RX'D @   04 RX'D @   05 RX'D @   06 RX'D @   MOD2+ MOD2+ MOD2+  ;
: S2  01 RX'D @   02 RX'D @   05 RX'D @   06 RX'D @   MOD2+ MOD2+ MOD2+  ;
: S3  00 RX'D @   02 RX'D @   04 RX'D @   06 RX'D @   MOD2+ MOD2+ MOD2+  ;

( PROSCRIPTION AND CORRECTION OF FAULTY BITS)
: SYNDROME   ( --N)  4 S1 *  2 S2 *  1 S3 *   + +     ;
: TOGGLE-BIT ( RX'D#--)  DUP RX'D @ 1 XOR SWAP RX'D ! ;
: CORR-BIT  ( SYN--)   DUP  IF  1- TOGGLE-BIT  ELSE DROP THEN ;

( -----------------RANDOM NUMBER GENERATOR--------------------------------)
FVARIABLE RND
: FSEED   GTIME CLKADR @    S>D   FLOAT  1/X    6.0 10**X F* ;
( CONVERT A # TO INTERVAL 0,1 )
: (0,1)      FDUP   IFIX  IFLOAT     FMOD    ;
( RANDOM # IN INTERVAL 0,1 )
: RANDOM  ( --N)  RND F@   69.069 F*   0.000232830   F+
                  (0,1)    FDUP  RND F!  ;

FSEED  (0,1)   RND  F!

( -------------------DATA AND CHANNEL SIMULATION--------------------------)

( DATA SIMULATION, A RANDOM WORD IN INTERVAL 0,15 )
: RND-WORD ( --N)    0    4 0 DO    0.500000  RANDOM  F>
IF    1       I 2^N *   +
ELSE  0       I 2^N *   +      THEN   LOOP ;

( CHANNEL SIMULATION, ERRORS ARE INTRODUCED IAW P{BIT ERROR} )
FVARIABLE PBE  ( PROB-BIT-ERROR)
: CHANNEL  ( --)   PBE F@   RANDOM   F>   IF  1 XOR  THEN ;
: TX'ER--->CHANNEL--->RX'ER   ( --)
7 0 DO   I TX'D @   CHANNEL  I RX'D !    LOOP ;


;S
