!
! test signal handling
!
	set	sigtramp,%o1
	set	sv1,%o0
	st	%o1,[%o0] ! init sigvec struct
	mov	%o0,%o1
	clr	%o2
	mov	11,%o0   ! catch SIGSEGV
	mov	0x6c,%g1 ! sigvec system call
	ta	0
	nop
	st	%g0,[%g0] ! force segmentation fault
	nop
!
! send SIGSEGV signal to ourselves with kill, getpid syscalls
!
	mov	20,%g1 ! getpid
	ta	0
	mov	11,%o1  ! %o0 has pid
	mov	37,%g1  ! kill
	ta 0
	nop
exit:
	mov	23,%o0
	mov	1,%g1
	ta 0


	.seg "bss"
sv1:
	.skip 0xc

!
! handler skips over insn and returns
!
        .seg "text"
handler:
        ld      [%o2+0xc],%l0  ! return pc
        ld      [%o2+0x10],%l1 ! return npc
        inc     4,%l0
        inc     4,%l1
        st      %l0,[%o2+0xc]
        st      %l1,[%o2+0x10]
        retl
        nop

!
! sigtramp sets up arguments for and calls the user handler,
! which is assumed not to touch the fp regs
!
	.seg "text"
sigtramp:
	save	%sp,-128,%sp ! protect ins, locals
	mov	%y,%l0
	st	%l0,[%sp+0x60]
	std	%g6,[%sp+0x68]
	std	%g4,[%sp+0x70]
	std	%g2,[%sp+0x78]
	ld	[%fp+0x40],%o0 ! sig
	ld	[%fp+0x44],%o1 ! code
	ld	[%fp+0x48],%o2 ! sigcontext ptr
	set	handler,%g1
	call	%g1            ! user's handler
	ld	[%fp+0x4c],%o3 ! faulty addr
	ld	[%sp+0x60],%l0
	mov	%l0,%y
	ldd	[%sp+0x68],%g6
	ldd	[%sp+0x70],%g4
	ldd	[%sp+0x78],%g2
	ld	[%fp+0x48],%i0 ! will be %o0 after restore
	mov	0x8b,%g1       ! return to sigcontext syscall
	restore                ! regs restored (expect %o0)
	ta	0
