/*
 * Exercise all non-branching opcodes at least partially.
 * Section numbers are from the SPARC Architecture
 * Manual.
 */
	.seg "text"
	set str, %o1
!
! B.1 Load Integer Instructions
!
	ldsb [%o1],%g0
	ldub [%o1],%g0
	ldsh [%o1],%g0
	lduh [%o1],%g0
	ld   [%o1],%g0
	ldd  [%o1],%g0
!
! B.4 Store Integer Instructions
!
	stb  %g0,[%o1]
	sth  %g0,[%o1]
	st   %g0,[%o1]
	std  %g0,[%o1]
!
! B.7 Atomic Load-Store Unsigned Byte Instruction
!
	ldstub [%o1],%g0
!
! B.8 SWAP r Register with Memory
!
	swap [%o1],%g0
!
! B.9 Add Instructions
!
	add    %o1,%o2,%o3
	addcc  %o1,%o2,%o3
	addx   %o1,%o2,%o3
	addxcc %o1,%o2,%o3
!
! B.10 Tagged Add Instructions
!
	taddcc %o1,%o2,%o3
	taddcctv %o1,%o2,%o3
!
! B.11 Subtract Instructions
!
	sub    %o1,%o2,%o3
	subcc  %o1,%o2,%o3
	subx   %o1,%o2,%o3
	subxcc %o1,%o2,%o3
!
! B.12 Tagged Subtract Instructions
!
	tsubcc %o1,%o2,%o3
	tsubcctv %o1,%o2,%o3
!
! B.13 Multiply Step Instruction
!
	mulscc %o1,%o2,%o3
!
! B.14 Logical Instructions
!
	and	%o1,%o2,%o3
	andcc	%o1,%o2,%o3
	andn	%o1,%o2,%o3
	andncc	%o1,%o2,%o3
	or	%o1,%o2,%o3
	orcc	%o1,%o2,%o3
	orn	%o1,%o2,%o3
	orncc	%o1,%o2,%o3
	xor	%o1,%o2,%o3
	xorcc	%o1,%o2,%o3
	xnor	%o1,%o2,%o3
	xnorcc	%o1,%o2,%o3
!
! B.15 Shift Instructions
!
	sll	%o1,%o2,%o3
	srl	%o1,%o2,%o3
	sra	%o1,%o2,%o3
!
! B.16 Sethi Instruction
!
	sethi	0,%o3
!
! B.17 Save and Restore Instructions
!
	save	%o1,%o2,%o3
	restore %o1,%o2,%o3
!
! B.25 Read Y Register Instruction
!
	rd	%y,%o3
!
! B.26 Write Y Register Instruction
!
	wr	%o3,%g0,%y
!
! B.28 Instruction Cache Flush Instruction
!
	iflush  %o1
!
! B.29 Floating-point Operate Instructions
	fitos %f0,%f4
	fitod %f0,%f4
	fstoi %f0,%f4
	fdtoi %f0,%f4
	fstod %f0,%f4
	fdtos %f0,%f4
	fmovs %f0,%f4
	fnegs %f0,%f4
	fabss %f0,%f4
	fsqrts %f0,%f4
	fsqrtd %f0,%f4
	fadds	%f0,%f2,%f4
	faddd	%f0,%f2,%f4
	fsubs	%f0,%f2,%f4
	fsubd	%f0,%f2,%f4
	fmuls	%f0,%f2,%f4
	fmuld	%f0,%f2,%f4
	fdivs	%f0,%f2,%f4
	fdivd	%f0,%f2,%f4
	fcmps	%f0,%f2
	fcmpd	%f0,%f2
	fcmpes	%f0,%f2
	fcmped	%f0,%f2


!
! Exit with status 18
!
	mov 18,%o0
	mov 1,%g1
	ta 0

	.seg "data"
str:
	.asciz "Sample data"