!
! test floating point insns
!
! fpe trap is a little tricky since the
! sigcontext sc_pc/sc_npc are unreliable due
! to FP parallel execution.
!
! extended-precision instructions are NOT implemented!
!
! setup SIGFPE signal handler
!
	set	sigtramp,%o1
	set	sv1,%o0
	st	%o1,[%o0] ! init sigvec struct
	mov	%o0,%o1
	clr	%o2
	mov	8,%o0
	mov	0x6c,%g1 ! sigvec system call
	ta	0
!
! clear tem mask
!
	call	set_tem
	clr	%o0
	set	f1,%o0
	ld	[%o0],%f0
	fitos	%f0,%f1
	ld	[%o0+4],%f0
	fitos	%f0,%f1
!
! set nxm bit in tem mask
!
	call	set_tem
	mov	0x1,%o0
!
! now trap on inexact
!
	set	f1,%o0
	ld	[%o0],%f0
	fitos	%f0,%f1
	ld	[%o0+4],%f0
	fitos	%f0,%f1       ! trap #1
! fitod
	ld	[%o0],%f0
	fitod	%f0,%f2
	std	%f2,[%o0+8]
	ldd	[%o0+16],%l0
	ldd	[%o0+8],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l1,%l3
	bne,a	.+0x8
	unimp	0
! fstoi (in range)
	set	f2,%i0
	ld	[%i0],%f0
	fstoi	%f0,%f0
	st	%f0,[%i0+4]
	ld	[%i0+4],%l0
	ld	[%i0+8],%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
!
! enable nvc, ofc, nxc, dzc exceptions
!
	call	set_tem
	mov	0x1b,%o0
! fstoi (out of range, nvc trap)
	ld	[%i0+12],%f0
	fstoi	%f0,%f0       ! trap #2
	nop
	st	%f0,[%i0+16]
	ld	[%i0+16],%i1
	set	0x7fffffff,%g1
	cmp	%i1,%g1
	bne,a	.+0x8
	unimp	0
! fdtoi (in range)
	set	f3,%i0
	ldd	[%i0],%f0
	fdtoi	%f0,%f0
	st	%f0,[%i0+12]
	ld	[%i0+12],%l0
	ld	[%i0+8],%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fdtoi (out of range, trap nvc)
	ldd	[%i0+16],%f0
	fdtoi	%f0,%f0        ! trap #3
	nop
	st	%f0,[%i0+12]
	ld	[%i0+12],%i1
	set	0x7fffffff,%g1
	cmp	%i1,%g1
	bne,a	.+0x8
	unimp	0
! fdtoi (in range, but inexact, trap nxc)
	ldd	[%i0+24],%f0
	fdtoi	%f0,%f0        ! trap #4
! fstod (always in range, cannot trap)
	set	f4,%o0
	ld	[%o0],%f0
	fstod	%f0,%f2
	std	%f2,[%o0+8]
	ldd	[%o0+8],%l0
	ldd	[%o0+16],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l1,%l3
	bne,a	.+0x8
	unimp	0
! fdtos (in range)
	set	f5,%i0
	ldd	[%i0],%f0
	fdtos	%f0,%f0
	st	%f0,[%i0+4]
	ld	[%i0+4],%l0
	set	0x4d91a2b0,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fdtos (out of range, trap nvc)
	ldd	[%i0+8],%f0
	fdtos	%f0,%f0         ! trap #5
	nop
	st	%f0,[%i0+4]
	ld	[%i0+4],%l0
	set	0x7f800000,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
!
! fdtos (in range, but inexact, trap nxc)
!
	ldd	[%i0+16],%f0
	fdtos	%f0,%f0        ! trap #6
	nop
! fmovs
	set	f4,%o0
	ld	[%o0],%f0
	ld	[%o0+4],%f1  ! s/b 0
	fmovs	%f0,%f1
	st	%f1,[%o0+4]
	ld	[%o0],%l0
	ld	[%o0+4],%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fnegs
	fnegs	%f1,%f2
! fabss
	fabss	%f2,%f3
	st	%f3,[%o0+4]
	ld	[%o0+4],%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fsqrts (exact, inrange)
	set	f6,%o0
	ld	[%o0],%f0
	fsqrts	%f0,%f1
	st	%f1,[%o0+8]
	ld	[%o0+8],%l0
	ld	[%o0+4],%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fsqrts (negative number, trap nvc)
	fnegs	%f0,%f0
	fsqrts	%f0,%f1        ! trap #7
	st	%f1,[%o0+8]
	ld	[%o0+8],%l0
	mov	-1,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fsqrts (inrange, inexact, trap nxc)
	ld	[%o0+12],%f0
	fsqrts	%f0,%f0        ! trap #8
	st	%f0,[%o0+16]
	ld	[%o0+16],%l0
	set	0x408f1bbd,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fsqrtd (exact, inrange)
	set	f7,%o0
	ldd	[%o0],%f0
	fsqrtd	%f0,%f2
	std	%f2,[%o0+8]
	ldd	[%o0+8],%l0
	ldd	[%o0+16],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l1,%l3
	bne,a	.+0x8
	unimp	0
! fsqrtd (negative number, trap nvc)
	fnegs	%f0,%f0
	fsqrtd	%f0,%f2        ! trap #9
	std	%f2,[%o0+8]
	ldd	[%o0+8],%l0
	mov	-1,%l2
	mov	-1,%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l1,%l3
	bne,a	.+0x8
	unimp	0
! fsqrtd (inrange, inexact, trap nxc)
	set	f8,%o0
	ldd	[%o0],%f0
	fsqrtd	%f0,%f0        ! trap #10
	std	%f0,[%o0+8]
	ldd	[%o0+8],%l0    ! compare only most significant digs.
	set	0x3ffc5bf8,%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
! fadds (exact)
	set	f9,%o0
	ldd	[%o0],%f0
	fadds	%f0,%f1,%f2
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x451dcc00,%l1
	cmp	%l1,%l0
	bne,a	.+0x8
	unimp	0
! fadds (inexact, trap nxc)
	ldd	[%o0+8],%f0
	fadds	%f0,%f1,%f2  ! trap #11
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x45887820,%l1
	cmp	%l1,%l0
	bne,a	.+0x8
	unimp	0
! fadds (overflow, trap ofc)
	ld	[%o0+20],%f0
	fadds	%f0,%f0,%f0  ! trap #12
	st	%f0,[%o0+24]
	ld	[%o0+24],%l0
	set	0x7f800000,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! faddd (exact)
	set	f10,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	faddd	%f0,%f2,%f4
	std	%f4,[%o0+16]
	ldd	[%o0+16],%l0
	ldd	[%o0+24],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! faddd (inexact, trap nxc)
	set	f11,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	faddd	%f0,%f2,%f4   ! trap #13
	std	%f4,[%o0+16]
	ldd	[%o0+16],%l0
	ldd	[%o0+24],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! faddd (overflow, trap ofc)
	set	f12,%o0
	ldd	[%o0],%f0
	faddd	%f0,%f0,%f4   ! trap #14
	std	%f4,[%o0+8]
	ldd	[%o0+8],%l0
	set	0x7ff00000,%l2
	clr	%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fsubs (exact)
	set	f9,%o0
	ldd	[%o0],%f0
	fnegs	%f1,%f1
	fsubs	%f0,%f1,%f2
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x451dcc00,%l1
	cmp	%l1,%l0
	bne,a	.+0x8
	unimp	0
! fsubs (inexact, trap nxc)
	ldd	[%o0+8],%f0
	fnegs	%f1,%f1
	fsubs	%f0,%f1,%f2  ! trap #15
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x45887820,%l1
	cmp	%l1,%l0
	bne,a	.+0x8
	unimp	0
! fsubs (overflow, trap ofc)
	ld	[%o0+20],%f0
	fnegs	%f0,%f1
	fsubs	%f0,%f1,%f0  ! trap #16
	st	%f0,[%o0+24]
	ld	[%o0+24],%l0
	set	0x7f800000,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fsubd (exact)
	set	f10,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	fnegs	%f2,%f2
	fsubd	%f0,%f2,%f4
	std	%f4,[%o0+16]
	ldd	[%o0+16],%l0
	ldd	[%o0+24],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fsubd (inexact, trap nxc)
	set	f11,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	fnegs	%f2,%f2
	fsubd	%f0,%f2,%f4   ! trap #17
	std	%f4,[%o0+16]
	ldd	[%o0+16],%l0
	ldd	[%o0+24],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fsubd (overflow, trap ofc)
	set	f12,%o0
	ldd	[%o0],%f0
	fnegs	%f0,%f2
	fmovs	%f1,%f3
	fsubd	%f0,%f2,%f4   ! trap #18
	std	%f4,[%o0+8]
	ldd	[%o0+8],%l0
	set	0x7ff00000,%l2
	clr	%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fmuls (exact)
	set	f13,%o0
	ld	[%o0],%f0
	ld	[%o0+4],%f1
	fmuls	%f0,%f1,%f2
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x47b89200,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fmuls (inexact, trap nxc)
	ld	[%o0+12],%f0
	ld	[%o0+16],%f1
	fmuls	%f0,%f1,%f2     ! trap #19
	st	%f2,[%o0+20]
	ld	[%o0+20],%l0
	set	0x40e0367e,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fmuls (overflow, trap ofc)
	ld	[%o0+24],%f0
	fmuls	%f0,%f0,%f1   ! trap #20
	st	%f1,[%o0+28]
	ld	[%o0+28],%l0
	set	0x7f800000,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fmuld (exact)
	set	f14,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	fmuld	%f0,%f2,%f4
	std	%f4,[%o0+16]
	ldd	[%o0+16],%l0
	ldd	[%o0+24],%l2
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fmuld (inexact, trap nxc)
	fmuld	%f0,%f4,%f4    ! trap #21
	std	%f4,[%o0+8]
	ldd	[%o0+8],%l0
	set	0x43b6cdc7,%l2
	set	0x98c8955e,%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fmuld (overflow, trap ofc)
	ldd	[%o0+32],%f0
	fmuld	%f0,%f0,%f0   ! trap #22
	std	%f0,[%o0+40]
	ldd	[%o0+40],%l0
	set	0x7ff00000,%l2
	clr	%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fdivs (exact)
	set	f15,%o0
	ldd	[%o0],%f0
	fdivs	%f0,%f1,%f2
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x42f60000,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fdivs (divide by zero, trap dzc)
	ld	[%o0+12],%f1
	fdivs	%f0,%f1,%f2    ! trap #23	
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x7f800000,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fdivs (inexact, trap nxc)
	ldd	[%o0+16],%f0
	fdivs	%f0,%f1,%f2   ! trap #24
	st	%f2,[%o0+8]
	ld	[%o0+8],%l0
	set	0x3e21af28,%l1
	cmp	%l0,%l1
	bne,a	.+0x8
	unimp	0
! fdivd (exact)
	ldd	[%o0+24],%f0
	ldd	[%o0+32],%f2
	fdivd	%f0,%f2,%f4
	std	%f4,[%o0+8]
	ldd	[%o0+8],%l0
	set	0x419196c5,%l2
	set	0x04000000,%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fdivd (divide by zero, trap dzc)
	fsubd	%f2,%f2,%f6
	fdivd	%f0,%f6,%f8  ! trap #25
	std	%f8,[%o0+8]
	ldd	[%o0+8],%l0
	set	0x7ff00000,%l2
	clr	%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fdivd (inexact, trap nxc)
	fdivd	%f4,%f2,%f0  ! trap #26
	std	%f0,[%o0+8]
	ldd	[%o0+8],%l0
	set	0x404c1637,%l2
	set	0xc8124d8a,%l3
	cmp	%l0,%l2
	bne,a	.+0x8
	unimp	0
	cmp	%l3,%l1
	bne,a	.+0x8
	unimp	0
! fcmps (greater than, less than, equal)
	set	f16,%o0
	ldd	[%o0],%f0
	fcmps	%f1,%f0
	nop
	fbg,a	.+0x8
	unimp	0
	fcmps	%f0,%f1
	nop
	fbl,a	.+0x8
	unimp	0
	fcmps	%f1,%f1
	nop
	fbne,a	.+0x8
	unimp	0
! fcmps (unordered)
	ldd	[%o0+8],%f2  ! f2 signalling, f3 quiet NaN
	fcmps	%f0,%f3
	nop
	fbo,a	.+0x8
	unimp	0
	fcmps	%f0,%f2  ! trap #27 nvc
	nop
	fbo,a	.+0x8
	unimp	0
! fcmpes (greater than, less than, equal)
	ldd	[%o0],%f0
	fcmpes	%f1,%f0
	nop
	fbg,a	.+0x8
	unimp	0
	fcmpes	%f0,%f1
	nop
	fbl,a	.+0x8
	unimp	0
	fcmpes	%f1,%f1
	nop
	fbne,a	.+0x8
	unimp	0
! fcmpes (unordered)
	ldd	[%o0+8],%f2  ! f2 signalling, f3 quiet NaN
	fcmpes	%f0,%f3  ! trap #28 nvx
	nop
	fbo,a	.+0x8
	unimp	0
	fcmpes	%f0,%f2  ! trap #29 nvc
	nop
	fbo,a	.+0x8
	unimp	0
! fcmpd (greater than, less than, equal)
	set	f17,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	fcmpd	%f2,%f0
	nop
	fbg,a	.+0x8
	unimp	0
	fcmpd	%f0,%f2
	nop
	fbl,a	.+0x8
	unimp	0
	fcmpd	%f2,%f2
	nop
	fbne,a	.+0x8
	unimp	0
! fcmpd (unordered)
	ldd	[%o0+16],%f2  ! f2 signalling, f4 quiet NaN
	ldd	[%o0+24],%f4
	fcmpd	%f0,%f4
	nop
	fbo,a	.+0x8
	unimp	0
	fcmpd	%f0,%f2  ! trap #30 nvc
	nop
	fbo,a	.+0x8
	unimp	0
! fcmped (greater than, less than, equal)
	set	f17,%o0
	ldd	[%o0],%f0
	ldd	[%o0+8],%f2
	fcmped	%f2,%f0
	nop
	fbg,a	.+0x8
	unimp	0
	fcmped	%f0,%f2
	nop
	fbl,a	.+0x8
	unimp	0
	fcmped	%f2,%f2
	nop
	fbne,a	.+0x8
	unimp	0
! fcmped (unordered)
	ldd	[%o0+16],%f2  ! f2 signalling, f4 quiet NaN
	ldd	[%o0+24],%f4
	fcmped	%f0,%f4  ! trap #31 nvc
	nop
	fbo,a	.+0x8
	unimp	0
	fcmped	%f0,%f2  ! trap #32 nvc
	nop
	fbo,a	.+0x8
	unimp	0

end:
! exit status is expected trap count
	set	trap_count,%o0
	ld	[%o0],%o0
	mov	1,%g1
	ta	0
	nop

	.seg "data"
f1:
	.word 0xfedcba,0x12345678,0,0,0x416fdb97,0x40000000
f2:
	.word 0x4ee3c5a7,0,0x71e2d380,0x5ee3c5a7,0,0
f3:
	.word 0x41b23456,0x78000000,0x12345678,0,
              0x6979ce40,0x17fc634f,0x40934a45,0x84f4c6e7
f4:
	.word 0x58cc550b,0,0,0,0x43198aa1,0x60000000
f5:
	.word 0x41b23456,0,0x5529af2b,0x7d0e0bbc,
	      0x427a28ed,0xc580e6a3
f6:
	.word 0x43dc8000,0x41a80000,0,0x41a00000,0,0
f7:
	.word 0x407ce400,0,0,0,0x40358000,0
f8:
	.word 0x400921fb,0x54411744,0,0
f9:
	.word 0x44d27000,0x44525000,0x4544597c,0x44e6487e,0
	.word 0x7f61b1e6,0,0
f10:
	.word 0x41a14582,0xde90dc00,0x4110d63a,0xf1000000,
	      0,0,0x41a14ded,0xfc095c00
f11:
	.word 0x41a14582,0xde90dc00,0x3fb4e5e0,0xa72f053a,
	      0,0,0x41a14582,0xdebaa7c1
f12:
	.word 0x7feab36d,0x48e1acf1,0,0
f13:
	.word 0x40900000,0x46a41000,0,0x3f9df3b6,0x40b5b22d,0
	.word 0x7f61b1e6,0
f14:
	.word 0x411bda05,0,0x415e1a4d,0xe0000000,0,0,
              0x428a3349,0x9ba22b00,0x6ed00000,0,0,0
f15:
	.word 0x4664b400,0x42ee0000,0,0,0x40400000,0x41980000,
              0x42d60796,0x944037c0,0x41340a1f,0x0
f16:
	.word 0x43988fbe,0x41f41931,0x7f800001,0x7fc00001
f17:
	.word 0x407311f7,0xced91687,0x403e8326,0x17c1bda5,
              0x7ff00000,0x00000001,0x7ff80000,0x00000001





sv1:
	.skip 0xc
trap_count:
	.word 0
!
! handler increments trap count and returns
!
        .seg "text"
handler:
	set	trap_count,%o0
	ld	[%o0],%o1
	inc	%o1
	st	%o1,[%o0]
        retl
        nop

!
! sigtramp sets up arguments for and calls the user handler,
! which is assumed not to touch the fp regs
!
	.seg "text"
sigtramp:
	save	%sp,-128,%sp ! protect ins, locals
	mov	%y,%l0
	st	%l0,[%sp+0x60]
	std	%g6,[%sp+0x68]
	std	%g4,[%sp+0x70]
	std	%g2,[%sp+0x78]
	ld	[%fp+0x40],%o0 ! sig
	ld	[%fp+0x44],%o1 ! code
	ld	[%fp+0x48],%o2 ! sigcontext ptr
	set	handler,%g1
	call	%g1            ! user's handler
	ld	[%fp+0x4c],%o3 ! faulty addr
	ld	[%sp+0x60],%l0
	mov	%l0,%y
	ldd	[%sp+0x68],%g6
	ldd	[%sp+0x70],%g4
	ldd	[%sp+0x78],%g2
	ld	[%fp+0x48],%i0 ! will be %o0 after restore
	mov	0x8b,%g1       ! return to sigcontext syscall
	restore                ! regs restored (expect %o0)
	ta	0

!
! (re)set bits in trap enable mask (tem)
!
	.seg	"data"
fsrbits:
	.word	0
	.seg	"text"
set_tem:
L1:
	set	fsrbits,%g1
	st	%fsr,[%g1]
	ld	[%g1],%o1
	set	0xf800000,%o3
	andn	%o1,%o3,%o1  ! turn off all tem bits
	sll	%o0,23,%o0
	or	%o0,%o1,%o1  ! or in new bits
	st	%o1,[%g1]
	ld	[%g1],%fsr
	retl
	nop
