/*
 * Program to interpret ssim data trace files
 *
 */
#include <stdio.h>
/*
 * Positive entry: read
 * Negative entry: write
 */

int array[64] = {
 4, /* ld */
 1, /* ldub */
 2, /* lduh */
 8, /* ldd */
-4, /* st */
-1, /* stb */
-2, /* sth */
-8, /* std */
 0,
 1, /* ldsb */
 2, /* ldsh */
 0,
 0,
 0, /* ldstub */
 0,
 0, /* swap */
 0, /* lda */
 0,
 0, /* lduba */
 0, /* ldda */
 0, /* sta */
 0, /* stba */
 0, /* stha */
 0, /* stda */
 0,
 0, /* ldsba */
 0, /* ldsah */
 0,
 0,
 0, /* ldstuba */
 0,
 0, /* swapa */
 4, /* ldf */
 4, /* ldfsr */
 0,
 8, /* lddf */
-4, /* stf */
-4, /* stfsr */
 0, /* stdfq */
-8  /* stdf */
};

FILE *in;

main(argc, argv)
int argc;
char **argv; {
  int c, aval;
  long addr;
  if (argc < 2) {
    printf("usage: %s filename\n",argv[0]);
    exit(1);
  }

#ifdef MSDOS
#define FMODE "rb"
#else
#define FMODE "r"
#endif /* MSDOS */

  if (!(in = fopen(argv[1],FMODE))) {
    perror(argv[1]);
    exit(1);
  }
  while ((c = getc(in)) != EOF) {
    if (c >= 64) {
      printf("%s: bad input\n",argv[1]);
      exit(1);
    }
    if (aval = array[c]) {
      if (aval < 0) {
        printf("write ");
        aval = -aval;
      }
      else {
        printf("read ");
      }
      if (fread((char *)&addr, 4, 1, in) != 1) {
        printf("%s: bad input\n",argv[1]);
        exit(1);
      }
      printf("%d bytes: address 0x%lx\n",aval,addr);
    }

  }
}
