
; REDVIEW.ASM (C) Alexandr NOVY 1988,92
            
IFDEF _286_
 .286
 _pusha_ equ pusha
 _popa_ equ popa
ELSE
 _pusha_ equ call push_all
 _popa_ equ call pop_all
ENDIF
   
MY_FLAG EQU 0BEh

_TEXT       SEGMENT
            ASSUME  cs:_TEXT, ds:_TEXT, ss:_TEXT
            ORG     100h
       
$start:      jmp   $begin

oldadr21    DD ?
oldadr09    DD ?
oldadr2f    DD ?
duplo       DB 1
character   DB ?

; ################################ INTERRUPT 09 ##############################
$begin09:
            push ax
            in al,60h
            cmp al,3ah
            jne $old09

            push es
            xor ax,ax
            mov es,ax
            test byte ptr es:[0417h],08h ; test for Alt
            jne  $alt09
            test byte ptr es:[0417h],04h ; test for Ctrl
            jne  $ctrl09
            pop  es
            jmp  short $old09
$ctrl09:
            mov  cs:duplo,0
            jmp  short $end09
$alt09:
            mov  cs:duplo,1
$end09:
            in al,60h
            in al,61h
            mov ah,al
            or  al,80h
            out 61h,al
            xchg ah,al
            out  61h,al
            mov  al,20h
            out  20h,al
            pop  es
            pop  ax
            sti
            iret
$old09:
           pop ax
           jmp cs:oldadr09
; ############################# END OF INTERRUPT 09 ##########################

IFNDEF _286_
retw DW ?
push_all:
         pop  cs:retw
         push ax
         push bx
         push cx
         push dx
         push bp
         push si
         push di
         jmp  cs:retw
pop_all:
         pop cs:retw
         pop di
         pop si
         pop bp
         pop dx
         pop cx
         pop bx
         pop ax
         jmp cs:retw
ENDIF

; ################################ INTERRUPT 21 ##############################
$begin21:
;-------------------------------------------------------
                              ; new in version 2.0 :
           cmp ax,4400h       ; IOCTL info for handle 1 & 2
           jne $21_1          ; must be 'device' when
           cmp bx,1           ; REDVIEW installed
           je  $21_dev
           cmp bx,2
           jne $21_1
$21_dev:
           pushf
           call cs:oldadr21
           pushf
           or   dx,80h        ; set 'device' bit in IOCTL info
           popf
           retf 2
$21_1:
;--------------------------------------------------------            
           cmp cs:duplo,0
           je  $ne21

           push bx
           mov  bx,1
           call device_test
           pop  bx
           jne  $ne21

           push bx
           mov  bx,2
           call device_test
           pop  bx
           je   $ne21

           cmp ah,02
           jne $l2109
           _pusha_
           push ds
           push cs
           pop  ds
           mov  character,dl
           mov  ah,40h
           mov  bx,2
           mov  dx,OFFSET character
           mov  cx,1
           pushf
           call oldadr21
           pop  ds
           _popa_
           jmp  short $ne21
$l2109:
           cmp ah,09
           jne $l2140
           _pusha_
$loop09:
           mov  si,dx
           cmp  byte ptr ds:[si],'$'
           je   $end2109
           mov  ah,40h
           mov  bx,2
           mov  cx,1
           push dx
           pushf
           call cs:oldadr21
           pop  dx
           inc  dx
           jmp  short $loop09
$end2109:
           _popa_
$l2140:
           cmp ah,40h
           jne $ne21

           cmp bx,1
           jne $ne21

           _pusha_
           push ds
           mov  bx,2
           pushf
           call cs:oldadr21
           pop  ds
           _popa_
$ne21:
           jmp cs:oldadr21

device_test:
           push ax
           push dx
           mov  ax,4400h
           pushf
           call cs:oldadr21
           test dl,80h
           pop  dx
           pop  ax
           ret

; ################################ INTERRUPT 2f ##############################
$begin2f:
          cmp  ah,MY_FLAG
          je   $l2f_0
          jmp  cs:oldadr2f
$l2f_0:
          or   al,al
          jne  $l2f_1
          mov  al,0ffh
$l2f_1:
          iret
; ############################# END OF INTERRUPT 2f ##########################

; ############################# START UP ################################

$begin:

            mov bx,2
            mov dx,OFFSET ilogo
            mov cx,l_ilogo
            mov ah,40h
            int 21h

            mov ah,MY_FLAG
            sub al,al
            int 2fh
            or  al,al
            je  $cont
            cmp al,0ffh
            je  $end
            mov bx,2
            mov dx,OFFSET noins
            mov cx,l_noins
            mov ah,40h
            int 21h
$end:       int 20h
$cont:
            mov ah,35h
            mov al,09h
            int 21h
            mov word ptr oldadr09[2],es
            mov word ptr oldadr09[0],bx ; get int 09

            mov ah,35h
            mov al,21h
            int 21h
            mov word ptr oldadr21[2],es
            mov word ptr oldadr21[0],bx ; get int 21

            mov ah,35h
            mov al,2fh
            int 21h
            mov word ptr oldadr2f[2],es
            mov word ptr oldadr2f[0],bx ; get int 2f

            mov ah,25h
            mov al,09h
            mov dx,OFFSET $begin09
            int 21h                      ; set int 09

            mov ah,25h
            mov al,21h
            mov dx,OFFSET $begin21
            int 21h                      ; set int 21

            mov ah,25h
            mov al,2fh
            mov dx,OFFSET $begin2f
            int 21h                      ; set int 2f

            mov bx,2
            mov dx,OFFSET resins
            mov cx,l_resins
            mov ah,40h
            int 21h
            
            push cs:[2ch] ; release of the enviroment
            pop  es
            mov  ah,49h
            int  21h
            
            push ds
            pop es
            mov dx,OFFSET $begin
            inc dx
            int 27h  ; terminate and stay resident

ilogo DB 13,10,"REDVIEW - written by Alexandr NOVY, CVUT FJFI Prague 1988,92.",13,10
l_ilogo EQU $ - ilogo
resins DB "Resident part installed.",13,10
l_resins EQU $ - resins
noins DB "Can not be installed.",13,10
l_noins EQU $ - noins
_TEXT       ENDS
            END   $start
