@Echo off
cls
:
: ---- See if required files are here.
:
If Not Exist  Fields.Exe goto FilesNotFound
If Not Exist DBF-ASC.Exe goto FilesNotFound
If Not Exist ASC-DBF.Exe goto FilesNotFound
If Not Exist  Sample.DBF goto FilesNotFound
Goto Start
:
:FilesNotFound
:
Echo I couldn't find one of the following files.  I'm ending . . .
Echo 
Echo Fields.Exe,  DBF-ASC.Exe,  ASC-DBF.Exe,  Sample.DBF
Echo 
Goto End
:
:Start
If Not Exist Sample.!!! Goto Run_Fields
:
Del Sample.!!!
:
: ---- Run FIELDS using Sample.DBF to quickly create Sample.!!!
:
:Run_Fields
Fields Sample.DBF
Echo 
Echo 
:
:
:
Pause
:
: ---- Run DBF-ASC using Sample.DBF to quickly create Sample.ASC
:
cls
Echo I'm about to run DBF-ASC.  As soon as it runs, press F2 and
Echo answer the questions you'll see near the bottom of your screen.
Echo 
Echo BE SURE to answer [Y]es when asked if we should save a DEFINITION FILE.
Echo We'll need that definition file in the next step.
Echo 
Echo 
Pause
If Not Exist Sample.ASC Goto Run_DBF-ASC
:
Del Sample.ASC
:
:Run_DBF-ASC
:
DBF-ASC   Sample.DBF     Sample.ASC
cls
:
:
: ---- Now run ASC-DBF.  Create a NEW .DBF file from Sample.ASC.
:
If Not Exist SAMPLE.ASC goto End
If Not Exist SAMPLE.DEF goto End
Echo I'm now about to run ASC-DBF.  As soon as it runs, press F2 and
Echo answer the questions you'll see near the bottom of your screen.
Echo 
Echo This will create a brand new dBASE file SAMPLE2.DBF based on the
Echo ASCII data you saved in the last step.
Echo 
pause
:
If Not Exist Sample2.DBF Goto Run_ASC-DBF
:
Del Sample2.DBF
:
:Run_ASC-DBF
ASC-DBF   Sample.DEF   Sample.ASC   Sample2.DBF
:
:
: ---- All done.
:
cls
Echo You should find several new files here (if all went according to plan).
Echo 
Echo  1.  Sample.!!! (created by FIELDS) shows the field structure of Sample.DBF.
Echo 
Echo 
Echo  2.  Sample.ASC and Sample.DEF (created by DBF-ASC) are, respectively:
Echo 
Echo      - A comma-delimited ASCII version of the dBase file Sample.DBF.
Echo 
Echo      - A "definition file" that we can use for 2 things:  It can be
Echo        used by ASC-DBF to create a dBase file from Sample.Asc.  And it
Echo        also serves as a record of which fields you saved to Sample.Asc.
Echo 
Echo 
Echo  3.  Sample2.DBF (created by ASC-DBF).
Echo 
Echo  If all this was fast, that's the point.  The Tool Kit programs are
Echo  small, easy-to-use, and very f-a-s-t!   Enjoy them.
Echo 
:End
