// OOSTRING.CPP
//
// Class library for strings
// Version 1.1
//
// Programmer : John Bernstein
//
//  For file notes, see the project notes sheet.

///////////////////////////////////////////////////////////////////////////

#include ".\oostring\oostring.h"
#include <assert.h>

///////////////////////////////////////////////////////////////////////////

string::string(char *str)              // char array constructor
{
  length = strlen(str);                // set the length of the string
  size = length + 1;                   // size includes \0
  string_ptr = new char[size];         // allocate space for the string
  strcpy(string_ptr, str);             // copy the string
}  // end of char array conversion


string::string(char ch)                // character constructor
{
  length = 1;                          // since only 1 character, length is 1
  size = 2;                            // 1 character + null byte
  string_ptr = new char[size];         // allocate space
  string_ptr[0] = ch;                  // put the character in place
  string_ptr[1] = '\0';                // put the null byte on
}  // end of character constructor
///////////////////////////////////////////////////////////////////////////

string::string(const string &src)      // copy constructor
{
  if (src.string_ptr != NULL)          // only copy if there is something
    {
      length = src.length;
      size = length + 1;
      string_ptr = new char[size];
      strcpy(string_ptr, src.string_ptr);
    }
  else
    {
      length = 0;                      // nothing there so set to null
      size = 0;
      string_ptr = NULL;               // and void
    }
}  // end of copy constructor

///////////////////////////////////////////////////////////////////////////

string& string::operator=(const string &src)  // assignment operator
{
  if (this != &src)                    // make sure no self assignment
    {
      if ((src.length + 1) > size)     // if not enough space in current string
        {
          delete string_ptr;           // release old memory
          length = src.length;         // copy length
          size = length + 1;
          string_ptr = new char[size]; // allocate space
        }
      else
        length = src.length;           // enough space, so just re-use
      strcpy(string_ptr, src.string_ptr);  // copy string
    }


//  else   /////// why is this even necessary??????
//    /// a more graceful or error proof way should be found
//    {
//      cout << "Error: Attempted self assignment!\n"
//	   << "       program terminated!"
//	   << endl;
//      exit(-1);
//    }


  return (*this);
}  // end of string::operator=

///////////////////////////////////////////////////////////////////////////

string operator+(const string &str1, const string &str2)
{
  string temp;                         // temporary storage

  temp.length = str1.length + str2.length;      // add the lengths together
  temp.size = temp.length + 1;
  temp.string_ptr = new char[temp.size];        // allocate space
  strcpy(temp.string_ptr, str1.string_ptr);     // copy first string
  strcat(temp.string_ptr, str2.string_ptr);     // append second string
  return (temp);
}  // end of string::operator+


///////////////////////////////////////////////////////////////////////////

string string::operator+=(const string &str)
{
  *this = *this + str;
  return (*this);
}  // end of operator +=

///////////////////////////////////////////////////////////////////////////

string string::operator+()
{
  string temp = *this;                 // allocate new temp space

  for (int i = 0; i < temp.length; i++)
    temp.string_ptr[i] = toupper(temp.string_ptr[i]);
  return (temp);
}  // end of unary operator +

///////////////////////////////////////////////////////////////////////////

string string::operator-()
{
  string temp = *this;                 // allocate new temp space

  for (int i = 0; i < temp.length; i++)
    temp.string_ptr[i] = tolower(temp.string_ptr[i]);
  return (temp);
}  // end of unary operator -


///////////////////////////////////////////////////////////////////////////

string& string::operator++()
{
  for (int i = 0; i < length; i++)
    string_ptr[i] = toupper(string_ptr[i]);
  return (*this);
}  // end of unary operator ++


///////////////////////////////////////////////////////////////////////////

string& string::operator--()
{
  for (int i = 0; i < length; i++)
    string_ptr[i] = tolower(string_ptr[i]);
  return (*this);
}  // end of unary operator --

///////////////////////////////////////////////////////////////////////////

char& string::operator[](const int index)
{
  assert ((index >= 0) && (index < length));  // make sure no range errors
  return (string_ptr[index]);
}

///////////////////////////////////////////////////////////////////////////

ostream& operator<<(ostream &stream, const string &str)
{
  stream << str.string_ptr;
  return (stream);
}  // end of operator <<


ostream& operator<<(ostream &stream, const string *str)
{
  stream << str->string_ptr;
  return (stream);
}  // end of operator <<


///////////////////////////////////////////////////////////////////////////
// WARNING:  As with most stream operator >> functions, care must be
//           taken to pre-allocate enough buffer space.  This function
//           DOES NOT allocate any memory!

istream& operator>>(istream& stream, string& str)
{
  assert(str.size > 0);                // make sure there is a buffer to read into
  stream.width(str.size);              // set the max input size = to buffer size
  stream >> str.string_ptr;
  str.length = strlen(str.string_ptr);
  return (stream);
}  // end of operator >>


int string::setsize(const int newsize)
{
  char* temp;                          // temporary storage for old string

  assert(newsize >= 0);                // size MUST be >= 0
  size = newsize;                      // put in the new size
  if (size == 0)                       // 0 size, so set to null condition
    {
      delete string_ptr;
      length = 0;
    }
  else                                 // positive size so re-allocate space
    {
      temp = new char[size];           // allocate the new space
      strncpy(temp, string_ptr, (size - 1));  // copy as much as possible, leaving one space for null
      temp[size - 1] = '\0';           // set the last byte to null
      delete string_ptr;               // release old memory
      string_ptr = temp;               // make temp the new string
      length = strlen(string_ptr);     // set the new length
    }
  return (size);
}  // end of member function setsize

void string::getline(istream& stream, const int maxlen)
{
  assert(maxlen > 0);                  // get at least one character
  if (size != 0)                       // is there already something in this string?
    delete string_ptr;                 // yeah, so delete it
  string_ptr = new char[maxlen];       // get storage space
  size = maxlen;                       // set buffer size
  stream.getline(string_ptr, maxlen);  // get line from input stream
  length = strlen(string_ptr);         // set string length
}  // end of member function getline