
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

/**************************************************************************
 *                                                                        *
 *  NEWPASS.C  - Generate New Random Passwords for BBS's                  *
 *                                                                        *
 *         Written  December 23, 1990                                     *
 *              by  David A. Scott                                        *
 *                                                                        *
 *  This program will generate random passwords of n length and print     *
 *  them to either a file or the printer.  The user will be asked to      *
 *  enter the length of the passwords and the number to generate.  The    *
 *  program will then ask where to send the passwords to.  Either a       *
 *  printer the screen can be used to display the new passwords.          *
 *                                                                        *
 *  Most BBS's would like for you to use a different password for each    *
 *  BBS you use.  Sometimes this is hard to do.  But if you use a         *
 *  communications program like Qmodem, then you have a place to keep     *
 *  your passwords for each BBS.  So now you can generate a unique and    *
 *  random password for each BBS you use.  This will keep your account    *
 *  safe from those bad folks who figure out your password on one system. *
 *  They might get one, but they'll not get them all!                     *
 *                                                                        *
 *  And now, since I'm in such a great mood, I hearby make this program   *
 *  public domain.  It is offered as is.  I claim no responsibility for   *
 *  any damage done by this program or modifications of it.  You may      *
 *  use the source as you see fit as long as you do not use it in a       *
 *  commercial program.  No money may be collected for this program.      *
 *  It is free and should not cost any more than that.  Enjoy.....        *
 *                                                                        *
 *                                       -David Scott                     *
 *                                                                        *
 **************************************************************************/

#define TRUE  1
#define FALSE 0

void showtitles(void);
void get_parameters(void);
void screen_output();
void printer_output();
int print(int retval);
int quit(int retval);
void cleanup(void);

int no_2_generate,pass_length;

int main()
{
int check;
  showtitles();
  do
  {
  get_parameters();
  } while(quit(check));
cleanup();
}

void cleanup()
{
window(1,1,80,25);
textcolor(LIGHTGRAY);
textbackground(BLACK);
clrscr();
puts("Thanks for using NEWPASS!");
puts("");
}

int quit(retval)
int retval;
{
char ch;
 do
 {
 window(1,1,6,1);
 textcolor(WHITE);
 textbackground(RED);
 cprintf("Quit?");
 ch=getch();
 } while(!strchr("YyNn",ch));
 textcolor(BLACK);
 textbackground(BLACK);
 clrscr();
retval = TRUE;
if(toupper(ch) == 'Y') retval = FALSE;
return retval;
}

int print(retval)
int retval;
{
char ch;
 do
 {
 window(25,10,80,25);
 textbackground(BLACK);
 clrscr();
 window(25,10,43,25);
 textcolor(WHITE);
 textbackground(RED);
 cprintf("Printer or Screen?");
 ch=getch();
 } while(!strchr("PpSs",ch));
 textcolor(BLACK);
 textbackground(BLACK);
 clrscr();
retval = TRUE;
if(toupper(ch) == 'P') retval = FALSE;
return retval;
}

void showtitles()
{
textcolor(LIGHTGRAY);
textbackground(BLACK);
clrscr();
window(53,1,80,5);
textcolor(LIGHTGRAY);
textbackground(MAGENTA);
cprintf("ͻ");
cprintf("                          ");
cprintf("                          ");
cprintf("ͼ");
textcolor(WHITE);
gotoxy(4,2);
cprintf("NEWPASS by David Scott");
gotoxy(3,3);
cprintf("Generate Random Passwords");
}

void get_parameters()
{
 int check;
 window(1,5,40,6);
 textcolor(WHITE);
 textbackground(BLUE);
 clrscr();

	no_2_generate = NULL;
	while(no_2_generate == NULL || no_2_generate > 99)
	{
	gotoxy(1,1);
	cputs("                                      ");
	gotoxy(2,1);
	cputs("number of passwords to generate > ");
	cscanf("%d",&no_2_generate);
	}

	pass_length = NULL;
	while(pass_length == NULL || pass_length > 15)
	{
	gotoxy(1,2);
	cputs("                                      ");
	gotoxy(2,2);
	cputs("        length of each password > ");
	cscanf("%d",&pass_length);
	}
 if(print(check))
	{
	screen_output();
	}
	else
	{
	printer_output();
	}
}


void screen_output()
{
 int rand_number,i,j;
 window(25,10,80,25);
 textbackground(BLACK);
 clrscr();
 window(25,10,39+pass_length,25);
 textcolor(WHITE);
 textbackground(GREEN);
 randomize();
 for(i=0;i<no_2_generate;i++)
	 {
	 cprintf("Password #%2.0d = ",i+1);
		 for(j=0;j<pass_length;j++)
		 {
		 rand_number = random(25) + 65;
		 cprintf("%c",rand_number);
		 }
	 }
}

void printer_output()
{
 int rand_number,i,j;
 FILE *prtr;
 char yn[2];

 prtr = fopen("prn","w");
 while(prtr == NULL)
    {
    window(25,10,38,27);
    textbackground(MAGENTA);
    textcolor(YELLOW);
    clrscr();
    putchar(7);
    cprintf("printer error!");
    cprintf(" retry? (Y/N) ");
	gets(yn);
	if(toupper(yn) == 'N') return;
	prtr = fopen("prn","w");
	}

 fprintf(prtr,"\nNewPass -- by David Scott");
 fprintf(prtr,"\nRandom Passwords\n\n");
 randomize();
 for(i=0;i<no_2_generate;i++)
	 {
	 fprintf(prtr,"\n\tPassword #%2.0d = ",i+1);
		 for(j=0;j<pass_length;j++)
		 {
		 rand_number = random(25) + 65;
		 fprintf(prtr,"%c",rand_number);
		 }
	 }
 fprintf(prtr,"\n\nend of list");
 fprintf(prtr,"%c %c",12,12);
 fclose(prtr);
}
