                                   (* Chapter 13 - Program 8 *)
IMPLEMENTATION MODULE OpaqueType;

FROM Storage IMPORT ALLOCATE;
FROM SYSTEM  IMPORT TSIZE;

   TYPE BoxStyle = RECORD
                      Length : CARDINAL;
                      Width  : CARDINAL;
                      Height : CARDINAL;
                   END;

        BoxType = POINTER TO BoxStyle;

   PROCEDURE MakeBox(Length, Width, Height : CARDINAL) : BoxType;
      VAR TempBox : BoxType;
   BEGIN
      ALLOCATE(TempBox,TSIZE(BoxStyle));
      TempBox^.Length := Length;
      TempBox^.Width  := Width;
      TempBox^.Height := Height;
      RETURN TempBox;
   END MakeBox;


   PROCEDURE Volume(Box : BoxType) : CARDINAL;
   BEGIN
      RETURN Box^.Length * Box^.Width * Box^.Height;
   END Volume;


   PROCEDURE Area(Box : BoxType) : CARDINAL;
   BEGIN
      RETURN 2 * (Box^.Length * Box^.Width  +
                  Box^.Length * Box^.Height +
                  Box^.Width  * Box^.Height);
   END Area;

END OpaqueType.

