*  MATINVC    MATrix INVersion subroutine for Complex numbers
*   Larry G. Hegi          October 5, 1989

*  Note:  This file calls the external procedures:
*            CTBR.FOR     transform Complex to Big Real Matrix
*            MATINV.FOR   Matrix Inversion sub...for Real numbers
*            BRTC.FOR     transform Big Real to Complex Matrix

*  Also:  This subroutine is called by the main program in the file:
*            EQS.FOR

*  This subroutine takes the complex input-matrices ( C & D in Cy=d )
*    and converts them to real matrices ( A & b in Ax=b ).  It then
*    solves the real-matrix equations using the subprogram: MATINV.FOR
*    This subroutine then takes the real solution-vector ( x in Ax=b )
*    and converts it back to a complex solution vector ( y in Cy=d ).
*    Then the y-vector is printed as the answer.

*    Input:  C(N1,N1) = square matrix of COMPLEX coefficients  (N1 x N1)
*            N1 = rank of matrix C
*            D(N1,M1) = a COMPLEX-constant-matrix of M1 column-vectors.
*                        ( d in the equation  C y = d )
*                        For simplicity, M1 can be set equal to 1.
*            M1 = the number of columns in the D-matrix of constants.
*            ND = Dimensioned Number of rows in C(ND,ND)
*               = Dimensioned Number of columns in C(ND,ND)
*               = Dimensioned Number of rows in D(ND,MD)
*            MD = Dimensioned Number of columns in D(ND,MD)

*    Output: C(N1,N1) = inverse of the input matrix C (COMPLEX)
*            D(N1,M1) = solution vector (COMPLEX)       -1
*                             ( y  in the equation y = C  d )
*            DETERM = Determinant of C
*                     ( Actually, DETERM is the determinant of the
*                       real-valued matrix-equivalent of C )
*            ID = Determinant Flag   ID = 1 if Determinant is non-zero
*                  ID = 2 if DETERM = 0  ( singular matrix C )

*  Note:  The arrays, A, B, & INDEX, are included in the list of
*    arguments for MATINVC for only 1 reason:  the size of the
*    arrays is adjusted according to the value of ND.

      SUBROUTINE MATINVC( C,N1,D,M1,DETERM,ID,ND,MD,A,B,INDEX )

      REAL  A( 2*ND, 2*ND ), B( 2*ND, 2*MD )
      INTEGER  INDEX( 2*ND, 3 )
      COMPLEX  C( ND, ND ), D( ND, MD )

         CALL  CTBR( C,ND,ND,N1,N1,A )
         CALL  CTBR( D,ND,MD,N1,M1,B )
         CALL  MATINV( A,2*N1,B,M1,DETERM,ID,2*ND,2*MD,INDEX )
         CALL  BRTC( A,ND,ND,N1,N1,C )
         CALL  BRTC( B,ND,MD,N1,M1,D )

      RETURN
      END
