*  CTBR      transform Complex matrix To a Big Real matrix
*  Larry G. Hegi          October 2, 1989

*  Note:  This subroutine is called by the main program in the file:
*               CND.FOR

*  This subroutine takes a matrix with complex numbers, and returns
*     a new matrix with the complex numbers broken up into real and
*     imaginary parts.  The purpose is to use a Gauss Jordan
*     algorithm for real numbers to solve a set of equations
*     having complex coefficients.

*  Input:  C = Matrix of complex coefficients   C( Irow, Icol )
*          ND = Dimensioned number of rows in Matrix C(ND,MD)
*          MD = Dimensioned number of columns in Matrix C(ND,MD)
*          IROW = Number of rows...( i in Matrix, C(i,j) )
*          ICOL = Number of columns...( j in Matrix, C(i,j) )
*
*  Output: R = Matrix of real coefficients   R( 2*Irow, 2*Icol )
*              ( notice that R(2i,2j) is twice as big as C(i,j) )


      SUBROUTINE  CTBR( C,ND,MD,IROW,ICOL,R )

         COMPLEX  C(ND,MD)
         REAL  R( 2*ND, 2*MD )

         DO 20 I=1,IROW
            DO 10 J=1,ICOL
               R( 2*I-1, 2*J-1 ) =   REAL( C( I,J ) )
               R( 2*I,   2*J   ) =   REAL( C( I,J ) )
               R( 2*I-1, 2*J   ) = -AIMAG( C( I,J ) )
               R( 2*I  , 2*J-1 ) =  AIMAG( C( I,J ) )
  10        CONTINUE
  20     CONTINUE

      RETURN
      END
