*  BRTC     transform a Big Real matrix To a Complex matrix
*  Larry G. Hegi         October 2, 1989

*  Note:  This subroutine is called by the main program in the file:
*                CND.FOR

*  This subroutine takes a matrix with real numbers, and returns
*    a new matrix with the real numbers combined into complex
*    numbers using a 'joining' algorithm.  The purpose is to
*    'un-do' the breaking up which was done by the subroutine:
*                 CTBR.FOR     Complex To Big Real conversion

*  Input:  R = Matrix of real coefficients   R( 2*Irow, 2*Icol )
*          ND = Dimensioned number of rows in Matrix C(ND,MD)
*          MD = Dimensioned number of columns in Matrix C(ND,MD)
*          IROW = Number of rows...( i in Matrix, C(i,j) )
*          ICOL = Number of columns...( j in Matrix, C(i,j) )
*
*  Output: C = Matrix of complex coefficients   C( Irow, Icol )
*              ( notice that R(2i,2j) is twice as big as R(i,j) )

      SUBROUTINE  BRTC( R,ND,MD,IROW,ICOL,C )

         COMPLEX  C(ND,MD)
         REAL  R( 2*ND, 2*MD )

         DO 20 I=1,IROW
            DO 10 J=1,ICOL
               C( I,J ) = CMPLX( R( 2*I-1, 2*J-1 ),  R( 2*I, 2*J-1 ) )
  10        CONTINUE
  20     CONTINUE

      RETURN
      END
