*****************************************
 IDENTIFICATION DIVISION.
*****************************************
 PROGRAM-ID. LL.
 AUTHOR. GOULD.
*PROJECT-LEADER. ALEXANDER.
 INSTALLATION.
 DATE-WRITTEN. 21 JAN, 1985
 DATE-COMPILED.

*****************************************
 ENVIRONMENT DIVISION.
*****************************************
*========================================
  CONFIGURATION SECTION.
*========================================
   SOURCE-COMPUTER.          IBM-PC.
   OBJECT-COMPUTER.          IBM-PC.

*========================================
 INPUT-OUTPUT SECTION.
*========================================
 FILE-CONTROL.

     SELECT PARAMETER-FILE ASSIGN VARYING PARM-LABEL
         STATUS IS SK
         ORGANIZATION IS SEQUENTIAL
         ACCESS IS SEQUENTIAL.

*****************************************
 DATA DIVISION.
*****************************************
 FILE SECTION.
 FD  PARAMETER-FILE LABEL RECORD IS STANDARD.
 01  PARM-RECORD.
     03  EDIT-COMM           PIC X(31).
     03  C-COBOL             PIC X(37).
     03  C-PASCAL            PIC X(37).
     03  C-C                 PIC X(37).
     03  C-BASIC             PIC X(37).
     03  L-COBOL             PIC X(37).
     03  L-PASCAL            PIC X(37).
     03  L-C                 PIC X(37).
     03  L-BASIC             PIC X(37).

*========================================
 WORKING-STORAGE SECTION.
*========================================
** USED FOR ALL DRIVE\DIRECTORY\FILE NAMES FOR CALLS

 01  PARM-LABEL              PIC X(66).

 01  PROG-NAME.
     03  BYTE-1              PIC X.
     03  BYTE-2              PIC X.
     03  FILLER              PIC X(119).
 01  MULTI-PURPOSE           PIC X(121).
 01  DRIVE-ID                PIC X.
 01  SK                      PIC XX.

** DOS-FIND-FIRST

 01  SEARCH-NAME             PIC X(79) VALUE "*.*".
 01  SEARCH-INFO.
     03  SEARCH-STATE        PIC X(26).
     03  FILE-SIZE           PIC S9(9) COMP-5.
     03  FILE-NAME.
         05  FIRST-BYTE      PIC X.
         05  FILLER          PIC X(12).
     03  FILE-DATE-TIME.
         05  FILE-DATE.
             07  YEARS       PIC S9(4) COMP-5.
             07  MONTHS      PIC S9(4) COMP-5.
             07  DAYS        PIC S9(4) COMP-5.
         05  FILE-TIME.
             07  HOURS       PIC S9(4) COMP-5.
             07  MINUTES     PIC S9(4) COMP-5.
             07  SECONDS     PIC S9(4) COMP-5.
     03  FILE-ATTRIBUTE      PIC S9(4) COMP-5.

** GET-DISK-FREE

 01  FREE-SPACE-INFO.
     03  NUM-CLUST-AVAIL     PIC S9(4) COMP-5.
     03  NUM-CLUST-TOTAL     PIC S9(4) COMP-5.
     03  BYTES-PER-SECTOR    PIC S9(4) COMP-5.
     03  SECS-PER-CLUST      PIC S9(4) COMP-5.

** DOS-GET-VERSION

 01  DOS-VERSION.
     03  MAJOR-VERSION       PIC 9.
     03  FILLER              PIC X       VALUE ".".
     03  FILLER              PIC 99.

** DOS-WAIT-RETURN

 01  WAIT-RETURN-CODE.
     03  TERMINATION-TYPE    PIC S9(4) COMP-5.
         88  NORMAL-TERM     VALUE 0.
         88  CTRL-BREAK-TERM VALUE 1.
         88  DEVICE-ERR-TERM VALUE 2.
         88  RESIDENT-TERM   VALUE 3.
     03  PROGRAM-STATUS      PIC S9(4) COMP-5.

** SCREEN SPECS

 01  HEADER-SPEC.
     03  FILLER              PIC X(4)    VALUE "H   ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.

     03  FILLER              PIC X(4)    VALUE "C   ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 1.
     03  FILLER              PIC S9(4) COMP-5 VALUE 1.
     03  FILLER              PIC S9(4) COMP-5 VALUE 78.
     03  FILLER              PIC X(12) VALUE "Directory: \".
     03  CUR-DIREC           PIC X(38).
     03  FILLER              PIC X(18) VALUE
         "  Disk Free Space:".
     03  CUR-FREE            PIC ZZ,ZZZ,ZZ9.

     03  FILLER              PIC X(4)    VALUE "C   ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 2.
     03  FILLER              PIC S9(4) COMP-5 VALUE 1.
     03  FILLER              PIC S9(4) COMP-5 VALUE 78.
     03  FILLER              PIC X(17) VALUE
         "Number of Files: ".
     03  NUMBER-FILES        PIC ZZ9.
     03  FILLER              PIC X(32) VALUE SPACES.
     03  FILLER              PIC X(5) VALUE "Page ".
     03  PAGE-NO             PIC 9.
     03  FILLER              PIC X(4) VALUE " of ".
     03  NBR-PAGES           PIC 9.
     03  FILLER              PIC X(15) VALUE SPACES.

     03  FILLER              PIC X(4) VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 3.
     03  FILLER              PIC S9(4) COMP-5 VALUE 1.
     03  FILLER              PIC S9(4) COMP-5 VALUE 16.
     03  FILLER              PIC X(16) VALUE
         "Operation Codes ".

 01  DISPLAY-SPEC.
     03  DISP-TYPE           PIC X(4)    VALUE "C  L".
     03  D-ROW               PIC S9(4) COMP-5.
     03  D-COL               PIC S9(4) COMP-5.
     03  D-LEN               PIC S9(4) COMP-5 VALUE 24.
     03  D-FILE              PIC X(8).
     03  D-DOT               PIC X       VALUE " ".
     03  D-EXT               PIC X(4).
     03  D-ATT               PIC X.
     03  FILLER              PIC X VALUE SPACE.
     03  D-SIZE              PIC Z,ZZZ,ZZZ.
     03  DIR-ENTRY REDEFINES D-SIZE PIC XXXXXXXXX.

 01  ALT-DISPLAY-SPEC.
     03  ALT-DISP-TYPE       PIC X(4)    VALUE "C  L".
     03  AD-ROW              PIC 9(4) COMP-5.
     03  AD-COL              PIC 9(4) COMP-5.
     03  FILLER              PIC 9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52).

 01  DIREC-OF.
     03  FILLER              PIC X(4)    VALUE "C   ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 8.
     03  FILLER              PIC S9(4) COMP-5 VALUE 1.
     03  FILLER              PIC S9(4) COMP-5 VALUE 80.
     03  FILLER              PIC X(24) VALUE
         "Displayed Directory is: ".
     03  DISP-DIREC          PIC X(56).

 01  INPUT-SPEC.
     03  IO-TYPE             PIC X       VALUE "I".
     03  IO-CONTROL          PIC XXX     VALUE "UA ".
     03  IO-ROW              PIC S9(4) COMP-5.
     03  IO-COL              PIC S9(4) COMP-5.
     03  IO-LEN              PIC S9(4) COMP-5.

 01  INPUT-LINE.
     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 7.
     03  FILLER              PIC S9(4) COMP-5 VALUE 1.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC X(14) VALUE
         "Command Input:".

     03  IL-TYPE             PIC X       VALUE "I".
     03  IL-CONTROL          PIC XXX     VALUE "UA ".
     03  IL-ROW              PIC S9(4) COMP-5 VALUE 7.
     03  IL-COL              PIC S9(4) COMP-5 VALUE 16.
     03  IL-LEN              PIC S9(4) COMP-5 VALUE 64.

 01  OPERATION-SPEC.
     03  OP-TYPE             PIC X(4)    VALUE "C  H".
     03  OP-ROW              PIC S9(4) COMP-5.
     03  OP-COL              PIC S9(4) COMP-5.
     03  OP-LEN              PIC S9(4) COMP-5 VALUE 2.
     03  OP-CODE             PIC XX.

     03  OP-TYPE-1           PIC X(4)    VALUE "C  L".
     03  OP-ROW-1            PIC S9(4) COMP-5.
     03  OP-COL-1            PIC S9(4) COMP-5.
     03  OP-LEN-1            PIC S9(4) COMP-5 VALUE 8.
     03  OP-CODE-1           PIC X(8).

 01  FUNCTION-SPEC.
     03  FU-TYPE             PIC X(4)    VALUE "C  H".
     03  FU-ROW              PIC S9(4) COMP-5.
     03  FU-COL              PIC S9(4) COMP-5.
     03  FU-LEN              PIC S9(4) COMP-5 VALUE 3.
     03  FU-KEY              PIC XXX.

     03  FU-TYPE-1           PIC X(4)    VALUE "C  L".
     03  FU-ROW-1            PIC S9(4) COMP-5.
     03  FU-COL-1            PIC S9(4) COMP-5.
     03  FU-LEN-1            PIC S9(4) COMP-5 VALUE 5.
     03  FU-FUNCTION         PIC X(5).

 01  TRAILER-SPEC.
     03  FILLER              PIC X(4)    VALUE "T   ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.

 01  PARAMETER-SPEC.
     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 7.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "<PARAMETERS>Ŀ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 8.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Edit command :                                 ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 9.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Compile commands                               ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 10.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Cobol  :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 11.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Pascal :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 12.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  C      :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 13.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Basic  :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "                                                 ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 15.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Link commands                                  ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 16.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Cobol  :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 17.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Pascal :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 18.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  C      :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 19.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "  Basic  :                                       ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 20.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "                                                 ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 21.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "                                                 ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 22.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "                                                 ".

     03  FILLER              PIC X(4)    VALUE "C  H".
     03  FILLER              PIC S9(4) COMP-5 VALUE 23.
     03  FILLER              PIC S9(4) COMP-5 VALUE 14.
     03  FILLER              PIC S9(4) COMP-5 VALUE 52.
     03  FILLER              PIC X(52) VALUE
     "".

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 8.
     03  FILLER              PIC S9(4) COMP-5 VALUE 32.
     03  FILLER              PIC S9(4) COMP-5 VALUE 31.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 10.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 11.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 12.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 13.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 16.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 17.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 18.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "IU  ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 19.
     03  FILLER              PIC S9(4) COMP-5 VALUE 26.
     03  FILLER              PIC S9(4) COMP-5 VALUE 37.

     03  FILLER              PIC X(4)    VALUE "T   ".
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.
     03  FILLER              PIC S9(4) COMP-5 VALUE 0.

 01  PROT-AREA               PIC X(1920).
 01  UNPROT-AREA             PIC X(600).
 01  UNPROT-OFFSET           PIC S9(4) COMP-5.
 01  PROT-OFFSET             PIC S9(4) COMP-5.
 01  CURSOR-LOCATION         PIC S9(4) COMP-5.
 01  RTN-CODE                PIC S9(4) COMP-5.
 01  LAST-POS                PIC S9(4) COMP-5.
 01  SCREEN-OFFSET           PIC S9(4) COMP-5.
 01  SPEC-OFFSET             PIC S9(4) COMP-5.
 01  DATA-AREA.
     03  CMD-LINE        PIC X(64).
     03  USER-TABLE      PIC X(45).

 01  ALL-INPUTS.
     03  USER-RESPONSES OCCURS 6 TIMES.
         05  USER-COMMAND OCCURS 45 TIMES PIC X.

 01  OPERATION-TABLE.
     03  FILLER              PIC X(10)    VALUE "B:Browse  ".
     03  FILLER              PIC X(10)    VALUE "M:Move    ".
     03  FILLER              PIC X(10)    VALUE "D:Delete  ".
     03  FILLER              PIC X(10)    VALUE "Y:Copy    ".
     03  FILLER              PIC X(10)    VALUE "P:Print   ".
     03  FILLER              PIC X(10)    VALUE "E:Edit    ".
     03  FILLER              PIC X(10)    VALUE "C:Compile ".
     03  FILLER              PIC X(10)    VALUE "L:Link    ".
     03  FILLER              PIC X(10)    VALUE "X:Execute ".
     03  FILLER              PIC X(10)    VALUE "H:Hide    ".
     03  FILLER              PIC X(10)    VALUE "R:Read    ".
     03  FILLER              PIC X(10)    VALUE "A:Archive ".
     03  FILLER              PIC X(10)    VALUE "T:Type    ".
 01  OP-TABLE REDEFINES OPERATION-TABLE.
     03  TABLE-CHOICE OCCURS 13 TIMES.
         05  OPERATION-CODE  PIC XX.
         05  OPERATION       PIC X(8).

 01  OP-CODE-SWITCHES.
     03  OP-CODE-SW OCCURS 13 TIMES PIC X.

 01  OP-INDEX                PIC 99.

 01  FUNCTION-TABLE.
     03  FILLER              PIC X(8)    VALUE "F1:Help ".
     03  FILLER              PIC X(8)    VALUE "F2:Quit ".
     03  FILLER              PIC X(8)    VALUE "F3:Parms".
     03  FILLER              PIC X(8)    VALUE "F4:Chdir".
     03  FILLER              PIC X(8)    VALUE "F5:Dir  ".
     03  FILLER              PIC X(8)    VALUE "F6:Clear".
     03  FILLER              PIC X(8)    VALUE "F7:Disp ".
     03  FILLER              PIC X(8)    VALUE "F8:     ".
     03  FILLER              PIC X(8)    VALUE "F9:Left ".
     03  FILLER              PIC X(8)    VALUE "F0:Right".
 01  FU-TABLE REDEFINES FUNCTION-TABLE.
     03  FUNC-CHOICE OCCURS 10 TIMES.
         05  FUNCT-KEY       PIC XXX.
         05  FUNCTION        PIC X(5).

 01  FU-KEY-SWITCHES.
     03  FU-KEY-SW OCCURS 10 TIMES PIC X.

 01  FU-INDEX                PIC 99.

** TABLE OF FILE NAMES

 01  FILE-TABLE.
     03  TABLE-INFO OCCURS 512 TIMES.
         05  TI-FILE-SIZE    PIC 9(10).
         05  TI-FILE-NAME.
             07  DIR-DOT     PIC X.
             07  FILLER      PIC X(12).
         05  TI-FILE-ATT     PIC 9(5).

 01  PARTS.
     03  PART-TABLE OCCURS 4 TIMES.
         05  PART                PIC X(38).
         05  P-COUNT             PIC 99.
 01  PART-INDEX              PIC 9.
 01  PART-POINTER            PIC 99.

 01  SORT-TABLE.
     03  SORT-1  OCCURS 140 TIMES.
         05  QSORT OCCURS 2 TIMES PIC S9(4) COMP-5.

 01  QSORT-INDEX-I           PIC S9(4) COMP-5.
 01  QSORT-INDEX-J           PIC S9(4) COMP-5.
 01  QSORT-INDEX-I1          PIC S9(4) COMP-5.
 01  QSORT-INDEX-J1          PIC S9(4) COMP-5.
 01  QSORT-INDEX-P           PIC S9(4) COMP-5.
 01  QSORT-INDEX-S           PIC S9(4) COMP-5.

 01  ARCHIVE-FLAG            PIC X.
 01  SYSTEM-FLAG             PIC X.
 01  HIDDEN-FLAG             PIC X.
 01  READ-FLAG               PIC X.
 01  COUNTER                 PIC 999.
 01  COMMAND                 PIC X.
 01  CURRENT-LOW             PIC 999 VALUE 1.
 01  CURRENT-HIGH            PIC 999 VALUE 60.
 01  DID-SOMETHING           PIC X VALUE "N".
 01  DIR-SW                  PIC X.
 01  DISP-DIR                PIC X.
 01  EXT-SW                  PIC X.
 01  FREE-DISK               PIC 9(10).
 01  FIL-SW                  PIC X.
 01  FILE-ATTR               PIC S9(4) COMP-5.
 01  HOLD-COMMAND            PIC X(121).
 01  HOLD-TABLE              PIC X(28).
 01  FILE-COUNT              PIC 9.
 01  MORE-YN                 PIC X VALUE "N".
 01  NO-CHANGE               PIC X VALUE "N".
 01  NUMBER-DISPLAY          PIC 999.
 01  PAGE-NBR                PIC 9.
 01  PROG-POINTER            PIC 999.
 01  USER-INDEX              PIC 99.
 01  USER-INDEX1             PIC 99.
 01  TABLE-INDEX             PIC 999.
 01  TABLE-INDEX1            PIC 999.
 01  TEMP-ATT                PIC 9999.
 01  TOTAL-PAGES             PIC 99 VALUE 1.
 01  TOTAL-LINES             PIC 999 VALUE 45.
 01  PAGE-COUNT              PIC 99 VALUE 1.
 01  WAIT-BYTE               PIC X.
 01  WORK-FILE               PIC X(8).
 01  WORK-EXT                PIC XXX.

     COPY CONTROL.

*========================================
 LINKAGE SECTION.
*========================================

 01  PARAMETER.
     03  PARAMETER-LENGTH        PIC S9(4) COMP-4.
     03  PARAMETER-CHARS.
         05  PARAMETER-CHAR PIC X OCCURS 1 TO 120 TIMES
             DEPENDING ON PARAMETER-LENGTH.

*****************************************
 PROCEDURE DIVISION USING PARAMETER.
*****************************************

*========================================
 INITIALIZE-PAR.
*========================================

     OPEN INPUT PARAMETER-FILE.

     READ PARAMETER-FILE.

     CLOSE PARAMETER-FILE.

     MOVE LOW-VALUES TO DATA-AREA ALL-INPUTS.

     MOVE 1 TO PAGE-COUNT.

     MOVE "YYYYYYNNYY" TO FU-KEY-SWITCHES.
     MOVE "NYYYYYYYYYYYY" TO OP-CODE-SWITCHES.

     STRING "LLP" DELIMITED BY SIZE
         LOW-VALUE DELIMITED BY SIZE
         INTO PROG-NAME.

     CALL "DOS-GET-ENV-STRING" USING PROG-NAME
         PROG-NAME.

     IF BYTE-1 = LOW-VALUE
         MOVE "PARMS.LL[N]" TO PARM-LABEL
     ELSE
         STRING PROG-NAME DELIMITED BY LOW-VALUE
         "\PARMS.LL[N]" DELIMITED BY SIZE
         LOW-VALUE DELIMITED BY SIZE
         INTO PARM-LABEL
     END-IF.

*========================================
 MAIN-CODE.
*========================================

     MOVE LOW-VALUES TO FILE-TABLE DATA-AREA.
     MOVE 1 TO CURRENT-LOW.
     MOVE TOTAL-LINES TO CURRENT-HIGH.
     MOVE "N" TO MORE-YN.

     MOVE 0 TO TABLE-INDEX.

     MOVE 255 TO FILE-ATTRIBUTE.
     PERFORM GET-DIRECTORY.

     PERFORM SORT-DIRECTORY THRU SD-EXIT.

     IF PAGE-COUNT > TOTAL-PAGES
         MOVE 1 TO PAGE-COUNT
     END-IF.

     COMPUTE CURRENT-LOW = ( PAGE-COUNT - 1 ) * TOTAL-LINES + 1.
     COMPUTE CURRENT-HIGH = PAGE-COUNT * TOTAL-LINES + 1.

     PERFORM BUILD-DISPLAY-INFO.

     IF TABLE-INDEX > TOTAL-LINES
         MOVE "Y" TO MORE-YN
     END-IF.

*----------------------------------------
 DISPLAY-SCREEN.
*----------------------------------------
     MOVE PAGE-COUNT TO PAGE-NO.
     MOVE TOTAL-PAGES TO NBR-PAGES.
     MOVE 9 TO D-ROW IO-ROW.
     MOVE 3 TO D-COL.
     MOVE 1 TO IO-COL IO-LEN.

     IF DISP-DIR = "Y"
         MOVE SPACES TO USER-TABLE
     ELSE
         MOVE USER-RESPONSES (PAGE-COUNT) TO USER-TABLE
     END-IF.

     MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET
         UNPROT-OFFSET LAST-POS.
     PERFORM REC006-CALL-H 4 TIMES.

     MOVE 1 TO OP-INDEX.
     MOVE 21 TO OP-COL.
     MOVE 23 TO OP-COL-1.
     MOVE 3 TO OP-ROW OP-ROW-1.
     PERFORM DISPLAY-OP-CODES 13 TIMES.

     MOVE 1 TO FU-INDEX.
     MOVE 1 TO FU-COL.
     MOVE 3 TO FU-COL-1.
     MOVE 25 TO FU-ROW FU-ROW-1.
     PERFORM DISPLAY-FU-KEYS 10 TIMES.

     MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET.
     PERFORM REC006-CALL-IL 2 TIMES.

     IF DISP-DIR = "Y"
         MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET
         PERFORM REC006-CALL-DD
     END-IF.

     MOVE CURRENT-LOW TO TABLE-INDEX1.
     MOVE 1 TO NUMBER-DISPLAY.

     PERFORM UNTIL TABLE-INDEX1 > TABLE-INDEX
     OR NUMBER-DISPLAY > TOTAL-LINES
         MOVE SPACES TO D-FILE D-EXT

         IF DIR-DOT (TABLE-INDEX1) NOT = "."
             UNSTRING TI-FILE-NAME (TABLE-INDEX1)
                 DELIMITED BY "." INTO D-FILE D-EXT
         ELSE
             MOVE TI-FILE-NAME (TABLE-INDEX1) TO D-FILE
         END-IF

         MOVE TI-FILE-SIZE (TABLE-INDEX1) TO D-SIZE
         PERFORM GET-ATTRIBUTE THRU GA-EXIT

         IF D-ATT = "D"
             MOVE SPACE TO D-ATT
             MOVE "<DIR>     " TO DIR-ENTRY
             MOVE "C  H" TO DISP-TYPE
         ELSE
             MOVE "C  L" TO DISP-TYPE
         END-IF

         MOVE 1 TO SPEC-OFFSET PROT-OFFSET
         PERFORM REC006-CALL-D
         MOVE 1 TO SPEC-OFFSET PROT-OFFSET
         PERFORM REC006-CALL-I
         ADD 1 TO IO-ROW D-ROW TABLE-INDEX1 NUMBER-DISPLAY
         IF IO-ROW > 23
             MOVE 9 TO IO-ROW D-ROW
             ADD 27 TO IO-COL D-COL
         END-IF
     END-PERFORM.

     MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET.
     PERFORM REC006-CALL-T.

     MOVE 2 TO LAST-POS.

 INPUT-AGAIN.

     CALL "REC001" USING CONTROL-REC
         PROT-AREA       UNPROT-AREA
         DATA-AREA       UNPROT-OFFSET
         CURSOR-LOCATION PROT-OFFSET
         RTN-CODE        LAST-POS.

     MOVE USER-TABLE TO USER-RESPONSES (PAGE-COUNT).

     IF RTN-CODE = 60
         CALL "CLS"
         STOP RUN.

     IF RTN-CODE = 61
         PERFORM CHANGE-PARAMETERS THRU CP-EXIT
         GO TO DISPLAY-SCREEN
     END-IF.

     IF RTN-CODE = 62
         PERFORM CHANGE-DIRECTORY THRU CD-EXIT
     END-IF.

     IF RTN-CODE = 63
         PERFORM DIRECTORY THRU D-EXIT
     END-IF.

     IF RTN-CODE = 64
         MOVE SPACES TO DATA-AREA ALL-INPUTS
         GO TO DISPLAY-SCREEN
     END-IF.

     IF RTN-CODE = 67
         IF LAST-POS > CURRENT-LOW
             SUBTRACT 16 FROM LAST-POS
             GO TO INPUT-AGAIN
         END-IF
     END-IF.

     IF RTN-CODE = 68
         IF LAST-POS < CURRENT-HIGH
             ADD 16 TO LAST-POS
             GO TO INPUT-AGAIN
         END-IF
     END-IF.

     IF RTN-CODE = 73
         IF PAGE-COUNT > 1
             SUBTRACT 1 FROM PAGE-COUNT
             SUBTRACT TOTAL-LINES FROM CURRENT-LOW CURRENT-HIGH
             GO TO DISPLAY-SCREEN
         ELSE
         IF PAGE-COUNT NOT > 1
             MOVE TOTAL-PAGES TO PAGE-COUNT
             COMPUTE CURRENT-LOW = ( TOTAL-PAGES - 1 )
                 * TOTAL-LINES + 1
             COMPUTE CURRENT-HIGH = TOTAL-PAGES * TOTAL-LINES + 1
             GO TO DISPLAY-SCREEN
         END-IF
     END-IF.

     IF RTN-CODE = 81
         IF PAGE-COUNT < TOTAL-PAGES
             ADD 1 TO PAGE-COUNT
             ADD TOTAL-LINES TO CURRENT-LOW CURRENT-HIGH
             GO TO DISPLAY-SCREEN
         ELSE
         IF PAGE-COUNT NOT < TOTAL-PAGES
             MOVE 1 TO PAGE-COUNT
             MOVE 1 TO CURRENT-LOW
             MOVE TOTAL-LINES TO CURRENT-HIGH
             GO TO DISPLAY-SCREEN
         END-IF
     END-IF.

     IF RTN-CODE = 1
         PERFORM CHECK-COMMANDS THRU CC-EXIT
         MOVE SPACES TO DATA-AREA ALL-INPUTS
     END-IF.

     IF DID-SOMETHING = "Y"
         GO TO MAIN-CODE
     ELSE
         GO TO INPUT-AGAIN
     END-IF.

*========================================
 CHANGE-PARAMETERS.
*========================================

     OPEN INPUT PARAMETER-FILE.

     READ PARAMETER-FILE.

     CLOSE PARAMETER-FILE.

     OPEN OUTPUT PARAMETER-FILE.

*    MOVE 7 TO UPPER-ROW.
*    MOVE 14 TO UPPER-COL.
*    MOVE 52 TO HORIZONTAL-SIZE.
*    MOVE 17 TO VERTICAL-SIZE.
*    MOVE PROT-AREA TO INPUT-SCREEN.
*    CALL "WINDOW" USING WINDOW-CONTROL.

*    ACCEPT WAIT-BYTE.

     MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET
         UNPROT-OFFSET LAST-POS.
     PERFORM REC006-CALL-CP 27 TIMES.

     MOVE 2 TO LAST-POS.

     CALL "REC001" USING CONTROL-REC
         PROT-AREA       UNPROT-AREA
         PARM-RECORD     UNPROT-OFFSET
         CURSOR-LOCATION PROT-OFFSET
         RTN-CODE        LAST-POS.

     WRITE PARM-RECORD.

     CLOSE PARAMETER-FILE.

 CP-EXIT.        EXIT.

*========================================
 CHANGE-DIRECTORY.
*========================================
     COMPUTE PAGE-NBR = ( CURRENT-HIGH / 45 ) - 1.
     COMPUTE TABLE-INDEX1 = LAST-POS +
         ( PAGE-NBR * 45 ) - 1.

     IF TABLE-INDEX1 > 0
         IF TI-FILE-ATT (TABLE-INDEX1) = 16
             MOVE "D" TO DIR-SW
             MOVE " " TO FIL-SW
         END-IF
     ELSE
         IF CMD-LINE > SPACES
             MOVE "C" TO DIR-SW
             MOVE " " TO FIL-SW
         END-IF
     END-IF.

     PERFORM BUILD-FILE-NAME.

     CALL "DOS-CHDIR" USING PROG-NAME.

     MOVE "Y" TO DID-SOMETHING.

 CD-EXIT.        EXIT.

*========================================
 DIRECTORY.
*========================================
     COMPUTE PAGE-NBR = ( CURRENT-HIGH / 45 ) - 1.
     COMPUTE TABLE-INDEX1 = LAST-POS +
         ( PAGE-NBR * 45 ) - 1.

     IF TI-FILE-ATT (TABLE-INDEX1) = 16
         MOVE "D" TO DIR-SW
         MOVE "Y" TO DISP-DIR
         MOVE "O" TO IO-TYPE
         MOVE ALL "N" TO OP-CODE-SWITCHES
         IF CMD-LINE > SPACES
             MOVE "C" TO FIL-SW
         ELSE
             MOVE "*" TO FIL-SW
         END-IF
     ELSE
         MOVE "N" TO DISP-DIR
         MOVE "I" TO IO-TYPE
         MOVE "NYYYYYYYYYYYY" TO OP-CODE-SWITCHES
     IF CMD-LINE > SPACES
         MOVE " " TO DIR-SW
         MOVE "C" TO FIL-SW
     ELSE
         MOVE "*" TO FIL-SW
         MOVE " " TO DIR-SW
     END-IF.

     PERFORM BUILD-FILE-NAME.

     MOVE PROG-NAME TO SEARCH-NAME.

     IF DISP-DIR = "Y"
         MOVE SEARCH-NAME TO DISP-DIREC
     END-IF.

     MOVE "Y" TO DID-SOMETHING.

 D-EXIT.         EXIT.

*========================================
 CHECK-COMMANDS.
*========================================

     MOVE 1 TO USER-INDEX USER-INDEX1

     IF ALL-INPUTS NOT > SPACES
         IF CMD-LINE > SPACES
             MOVE CMD-LINE TO PROG-NAME
             CALL "CLS"
             CALL "DOS-EXEC-COMMAND" USING PROG-NAME
             DISPLAY "PRESS <ENTER> WHEN READY"
             ACCEPT WAIT-BYTE
             MOVE "Y" TO DID-SOMETHING
             GO TO CC-EXIT
         END-IF
     END-IF.

     PERFORM VARYING USER-INDEX FROM 1 BY 1
         UNTIL USER-INDEX > 6
         AFTER USER-INDEX1 FROM 1 BY 1
         UNTIL USER-INDEX1 > 45
             IF USER-COMMAND (USER-INDEX USER-INDEX1)
                 > SPACE
                 COMPUTE TABLE-INDEX1 =
                     ( ( USER-INDEX - 1 ) * 45 ) + USER-INDEX1
                 PERFORM EXECUTE-COMMAND
             END-IF
     END-PERFORM

     GO TO CC-EXIT.

*----------------------------------------
 EXECUTE-COMMAND.
*----------------------------------------

     MOVE USER-COMMAND (USER-INDEX USER-INDEX1) TO COMMAND.

     IF COMMAND = "H"
         MOVE 2 TO FILE-ATTR
     ELSE
     IF COMMAND = "R"
         MOVE 1 TO FILE-ATTR
     ELSE
     IF COMMAND = "A"
         MOVE 32 TO FILE-ATTR
     END-IF.

     IF COMMAND = "A" OR "R" OR "H"
         MOVE " " TO DIR-SW
         MOVE "D" TO FIL-SW
         PERFORM BUILD-FILE-NAME
         CALL "DOS-SET-FILE-MODE" USING PROG-NAME FILE-ATTR
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "M"
         IF CMD-LINE > SPACES
             MOVE " " TO DIR-SW
             MOVE "D" TO FIL-SW
             PERFORM BUILD-FILE-NAME
             MOVE PROG-NAME TO MULTI-PURPOSE
             MOVE "C" TO DIR-SW
             MOVE "D" TO FIL-SW
             PERFORM BUILD-FILE-NAME
             CALL "DOS-RENAME-FILE" USING MULTI-PURPOSE
                 PROG-NAME
             MOVE "Y" TO DID-SOMETHING
         END-IF
     END-IF.

     IF COMMAND = "D"
         MOVE " " TO DIR-SW
         MOVE "D" TO FIL-SW
         PERFORM BUILD-FILE-NAME
         CALL "DOS-DELETE-FILE" USING PROG-NAME
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "X"
         MOVE LOW-VALUES TO MULTI-PURPOSE
         MOVE " " TO DIR-SW
         MOVE "D" TO FIL-SW
         PERFORM BUILD-FILE-NAME
         CALL "CLS"
         CALL "DOS-EXEC" USING PROG-NAME MULTI-PURPOSE
         DISPLAY "PRESS <ENTER> WHEN READY"
         ACCEPT WAIT-BYTE
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "C"
         PERFORM COMPILE-PROGRAM THRU C-P-EXIT
         MOVE "Y" TO DID-SOMETHING
     END-IF

     IF COMMAND = "L"
         PERFORM LINK-PROGRAM THRU LP-EXIT
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "E"
         PERFORM EDIT-PROGRAM THRU EP-EXIT
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "T"
         MOVE " " TO DIR-SW
         MOVE "D" TO FIL-SW
         PERFORM BUILD-FILE-NAME
         STRING "TYPE " DELIMITED BY SIZE
             PROG-NAME DELIMITED BY SPACE
             INTO MULTI-PURPOSE
         CALL "CLS"
         CALL "DOS-EXEC-COMMAND" USING MULTI-PURPOSE
         DISPLAY "PRESS <ENTER> WHEN READY"
         ACCEPT WAIT-BYTE
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "P"
         MOVE " " TO DIR-SW
         MOVE "D" TO FIL-SW
         PERFORM BUILD-FILE-NAME
         STRING "TYPE " DELIMITED BY SIZE
             PROG-NAME DELIMITED BY LOW-VALUE
             " > PRN" DELIMITED BY SIZE
             LOW-VALUE DELIMITED BY SIZE
             INTO MULTI-PURPOSE
         CALL "DOS-EXEC-COMMAND" USING MULTI-PURPOSE
         MOVE "Y" TO DID-SOMETHING
     END-IF.

     IF COMMAND = "Y"
         IF CMD-LINE > SPACES
             MOVE " " TO DIR-SW
             MOVE "D" TO FIL-SW
             PERFORM BUILD-FILE-NAME
             MOVE PROG-NAME TO MULTI-PURPOSE
             MOVE "C" TO DIR-SW
             MOVE "D" TO FIL-SW
             PERFORM BUILD-FILE-NAME
             STRING "COPY " DELIMITED BY SIZE
                 MULTI-PURPOSE DELIMITED BY LOW-VALUE
                 " " DELIMITED BY SIZE
                 PROG-NAME DELIMITED BY LOW-VALUE
                 " > NUL" DELIMITED BY SIZE
                 LOW-VALUE DELIMITED BY SIZE
                 INTO HOLD-COMMAND
             CALL "DOS-EXEC-COMMAND" USING HOLD-COMMAND
             MOVE "Y" TO DID-SOMETHING
         END-IF
     END-IF.


 CC-EXIT.    EXIT.

*========================================
 GET-DIRECTORY.
*========================================
     MOVE 1 TO TOTAL-PAGES COUNTER.
     CALL "DOS-FIND-FIRST" USING SEARCH-NAME SEARCH-INFO.
     IF RETURN-CODE NOT = 18
         ADD 1 TO TABLE-INDEX
         IF FIRST-BYTE = "."
             STRING "." DELIMITED BY SIZE
                 LOW-VALUE DELIMITED BY SIZE
                 INTO FILE-NAME
         END-IF
         MOVE FILE-SIZE TO TI-FILE-SIZE (TABLE-INDEX)
         MOVE FILE-NAME TO TI-FILE-NAME (TABLE-INDEX)
         MOVE FILE-ATTRIBUTE TO TI-FILE-ATT (TABLE-INDEX)
             TEMP-ATT.

     PERFORM UNTIL RETURN-CODE = 18
         CALL "DOS-FIND-NEXT" USING SEARCH-INFO
         IF RETURN-CODE NOT = 18
             ADD 1 TO TABLE-INDEX COUNTER
             IF FIRST-BYTE = "."
                 STRING ".." DELIMITED BY SIZE
                     LOW-VALUE DELIMITED BY SIZE
                     INTO FILE-NAME
             END-IF
             IF COUNTER > TOTAL-LINES
                 ADD 1 TO TOTAL-PAGES
                 MOVE 1 TO COUNTER
             END-IF
             MOVE FILE-SIZE TO TI-FILE-SIZE (TABLE-INDEX)
             MOVE FILE-NAME TO TI-FILE-NAME (TABLE-INDEX)
             MOVE FILE-ATTRIBUTE TO TI-FILE-ATT (TABLE-INDEX)
                 TEMP-ATT
             MOVE SPACES TO FILE-NAME
         END-IF
     END-PERFORM.

*========================================
 SORT-DIRECTORY.
*========================================

     MOVE TABLE-INDEX TO QSORT-INDEX-J1.
     MOVE 1 TO QSORT-INDEX-I1.

 LOOP-240.
     MOVE QSORT-INDEX-I1 TO QSORT-INDEX-I.
     MOVE QSORT-INDEX-J1 TO QSORT-INDEX-J.
     MOVE -1 TO QSORT-INDEX-S.

 LOOP-250.
     IF TI-FILE-NAME (QSORT-INDEX-I) <
        TI-FILE-NAME (QSORT-INDEX-J)
         GO TO LOOP-290.

     MOVE TABLE-INFO (QSORT-INDEX-I) TO HOLD-TABLE.
     MOVE TABLE-INFO (QSORT-INDEX-J) TO
          TABLE-INFO (QSORT-INDEX-I).
     MOVE HOLD-TABLE TO TABLE-INFO (QSORT-INDEX-J).

     IF QSORT-INDEX-S = -1
         MOVE 1 TO QSORT-INDEX-S
     ELSE
         MOVE -1 TO QSORT-INDEX-S
     END-IF.

 LOOP-290.

     IF QSORT-INDEX-S = 1
         ADD 1 TO QSORT-INDEX-I
     ELSE
         SUBTRACT 1 FROM QSORT-INDEX-J
     END-IF.

     IF QSORT-INDEX-I < QSORT-INDEX-J
         GO TO LOOP-250.

     IF QSORT-INDEX-I + 1 NOT < QSORT-INDEX-J1
         COMPUTE QSORT-INDEX-J1 = QSORT-INDEX-I - 1
     ELSE
         ADD 1 TO QSORT-INDEX-P
         COMPUTE QSORT ( QSORT-INDEX-P, 1 ) =
             QSORT-INDEX-I + 1
         COMPUTE QSORT ( QSORT-INDEX-P, 2 ) =
             QSORT-INDEX-J1
         COMPUTE QSORT-INDEX-J1 = QSORT-INDEX-I - 1.

     IF QSORT-INDEX-I1 < QSORT-INDEX-J1
         GO TO LOOP-240.

     IF QSORT-INDEX-P = 0
         GO TO SD-EXIT.

     MOVE QSORT ( QSORT-INDEX-P, 1 ) TO QSORT-INDEX-I1.
     MOVE QSORT ( QSORT-INDEX-P, 2 ) TO QSORT-INDEX-J1.
     SUBTRACT 1 FROM QSORT-INDEX-P.

     GO TO LOOP-240.

 SD-EXIT.    EXIT.

*========================================
 GET-ATTRIBUTE.
*========================================


     MOVE TI-FILE-ATT (TABLE-INDEX1) TO TEMP-ATT.

     IF TEMP-ATT NOT < 32
         MOVE "Y" TO ARCHIVE-FLAG
         MOVE " " TO D-ATT
         SUBTRACT 32 FROM TEMP-ATT.
     IF TEMP-ATT NOT < 16
         MOVE "D" TO D-ATT
         GO TO GA-EXIT.
     IF TEMP-ATT NOT < 2
         MOVE "Y" TO HIDDEN-FLAG
         MOVE "H" TO D-ATT
         MOVE "N" TO ARCHIVE-FLAG
         SUBTRACT 2 FROM TEMP-ATT
         GO TO GA-EXIT.
     IF TEMP-ATT = 1
         MOVE "R" TO D-ATT
         MOVE "Y" TO READ-FLAG
         MOVE "N" TO ARCHIVE-FLAG
         GO TO GA-EXIT.
     MOVE " " TO D-ATT.

 GA-EXIT.    EXIT.

*========================================
 BUILD-DISPLAY-INFO.
*========================================


     MOVE SPACES TO MULTI-PURPOSE CUR-DIREC PROG-NAME.

     CALL "DOS-GET-DIR" USING MULTI-PURPOSE PROG-NAME

     MOVE PROG-NAME TO CUR-DIREC.

     CALL "DOS-GET-DISK-FREE" USING DRIVE-ID FREE-SPACE-INFO.

     COMPUTE FREE-DISK = ( SECS-PER-CLUST * BYTES-PER-SECTOR )
         * NUM-CLUST-AVAIL.

     MOVE FREE-DISK TO CUR-FREE.
     MOVE TABLE-INDEX TO NUMBER-FILES.
*========================================
 DISPLAY-OP-CODES.
*========================================

     IF OP-CODE-SW (OP-INDEX) = "Y"
         MOVE OPERATION-CODE (OP-INDEX) TO OP-CODE
         MOVE OPERATION (OP-INDEX) TO OP-CODE-1
         MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET
             UNPROT-OFFSET LAST-POS
         PERFORM REC006-CALL-OP 2 TIMES
     END-IF.

     ADD 10 TO OP-COL OP-COL-1
     IF OP-COL > 61
         ADD 1 TO OP-ROW OP-ROW-1
         MOVE 21 TO OP-COL
         MOVE 23 TO OP-COL-1
     END-IF.

     ADD 1 TO OP-INDEX.
*========================================
 DISPLAY-FU-KEYS.
*========================================

     IF FU-KEY-SW (FU-INDEX) = "Y"
         MOVE FUNCT-KEY (FU-INDEX) TO FU-KEY
         MOVE FUNCTION (FU-INDEX) TO FU-FUNCTION
         MOVE 1 TO SPEC-OFFSET SCREEN-OFFSET PROT-OFFSET
             UNPROT-OFFSET LAST-POS
         PERFORM REC006-CALL-FU 2 TIMES
     END-IF.

     ADD 8 TO FU-COL FU-COL-1.

     ADD 1 TO FU-INDEX.

*========================================
 BUILD-FILE-NAME.
*========================================

     MOVE 1 TO PROG-POINTER.
     MOVE LOW-VALUES TO PROG-NAME.

     IF DIR-SW = "D"
         IF CUR-DIREC > SPACES
             STRING "\" DELIMITED BY SIZE
                 CUR-DIREC DELIMITED BY LOW-VALUE
                 INTO PROG-NAME
                 WITH POINTER PROG-POINTER
         END-IF
     END-IF.

     IF DIR-SW = "C"
         STRING CMD-LINE DELIMITED BY LOW-VALUE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     ELSE
     IF  DIR-SW = "D"
         STRING
             "\" DELIMITED BY SIZE
             TI-FILE-NAME (TABLE-INDEX1) DELIMITED BY LOW-VALUE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     ELSE
     IF DIR-SW = "Y"
         STRING "\" DELIMITED BY SIZE
             CUR-DIREC DELIMITED BY LOW-VALUE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     END-IF.

     IF BYTE-2 NOT = LOW-VALUE AND FIL-SW > SPACE
         STRING "\" DELIMITED BY SIZE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     END-IF.

** ADD FILE NAME TO DIRECTORY

     IF FIL-SW = "C"
         STRING CMD-LINE DELIMITED BY LOW-VALUE
             LOW-VALUE DELIMITED BY SIZE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     ELSE
     IF FIL-SW = "D"
         STRING TI-FILE-NAME (TABLE-INDEX1)
             DELIMITED BY LOW-VALUE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     ELSE
     IF FIL-SW = "*"
         STRING "*.*" DELIMITED BY SIZE
             LOW-VALUE DELIMITED BY SIZE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     END-IF.

*========================================
 COMPILE-PROGRAM.
*========================================

     MOVE SPACES TO WORK-FILE WORK-EXT.
     MOVE LOW-VALUES TO PROG-NAME.

     UNSTRING TI-FILE-NAME (TABLE-INDEX1)
         DELIMITED BY "." INTO
             WORK-FILE WORK-EXT.

     IF WORK-EXT = "COB" OR "CBL"
         MOVE C-COBOL TO PROG-NAME
     ELSE
     IF WORK-EXT = "FOR"
         MOVE C-PASCAL TO PROG-NAME
     ELSE
     IF WORK-EXT = "C"
         MOVE C-C TO PROG-NAME
     ELSE
     IF WORK-EXT = "BAS"
         MOVE C-BASIC TO PROG-NAME
     END-IF.

     IF PROG-NAME NOT > SPACES
         GO TO C-P-EXIT
     END-IF.

     PERFORM REPLACE-FILE-NAMES.

     CALL "CLS".
     CALL "DOS-EXEC-COMMAND" USING PROG-NAME.

 C-P-EXIT.    EXIT.

*========================================
 LINK-PROGRAM.
*========================================

     MOVE SPACES TO WORK-FILE WORK-EXT.
     MOVE LOW-VALUES TO PROG-NAME.

     UNSTRING TI-FILE-NAME (TABLE-INDEX1)
         DELIMITED BY "." INTO
             WORK-FILE WORK-EXT.

     IF WORK-EXT = "COB" OR "CBL"
         MOVE L-COBOL TO PROG-NAME
     ELSE
     IF WORK-EXT = "FOR"
         MOVE L-PASCAL TO PROG-NAME
     ELSE
     IF WORK-EXT = "C"
         MOVE L-C TO PROG-NAME
     ELSE
     IF WORK-EXT = "BAS"
         MOVE L-BASIC TO PROG-NAME
     END-IF.

     IF PROG-NAME NOT > SPACES
         GO TO LP-EXIT
     END-IF.

     PERFORM REPLACE-FILE-NAMES.

     CALL "CLS".
     CALL "DOS-EXEC-COMMAND" USING PROG-NAME.

 LP-EXIT.    EXIT.

*========================================
 EDIT-PROGRAM.
*========================================

     MOVE SPACES TO WORK-FILE WORK-EXT.
     MOVE LOW-VALUES TO PROG-NAME.

     UNSTRING TI-FILE-NAME (TABLE-INDEX1)
         DELIMITED BY "." INTO
             WORK-FILE WORK-EXT.

     MOVE EDIT-COMM TO PROG-NAME.

     IF PROG-NAME NOT > SPACES
         GO TO EP-EXIT
     END-IF.

     MOVE "Y" TO EXT-SW.

     PERFORM REPLACE-FILE-NAMES.

     CALL "CLS".
     CALL "DOS-EXEC-COMMAND" USING PROG-NAME.

 EP-EXIT.    EXIT.

*----------------------------------------
 REPLACE-FILE-NAMES.
*----------------------------------------

     MOVE 0 TO FILE-COUNT.
     MOVE 1 TO PROG-POINTER PART-INDEX.
     MOVE LOW-VALUES TO PARTS.

     INSPECT PROG-NAME TALLYING FILE-COUNT
         FOR ALL "%1".

     UNSTRING PROG-NAME
         DELIMITED BY "%1" OR LOW-VALUE INTO
             PART (1) COUNT IN P-COUNT (1)
             PART (2) COUNT IN P-COUNT (2)
             PART (3) COUNT IN P-COUNT (3)
             PART (4) COUNT IN P-COUNT (4).

     MOVE LOW-VALUES TO PROG-NAME.

     PERFORM FILE-COUNT TIMES
         COMPUTE PART-POINTER = P-COUNT (PART-INDEX) + 1

         STRING LOW-VALUE DELIMITED BY SIZE
             INTO PART (PART-INDEX)
             WITH POINTER PART-POINTER

         IF PART (PART-INDEX) > SPACES
             STRING PART (PART-INDEX) DELIMITED BY LOW-VALUE
                 INTO PROG-NAME
                 WITH POINTER PROG-POINTER
         END-IF

         STRING WORK-FILE DELIMITED BY SPACE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER

         IF EXT-SW = "Y"
             STRING "." DELIMITED BY SIZE
                 WORK-EXT DELIMITED BY LOW-VALUE
                 INTO PROG-NAME
                 WITH POINTER PROG-POINTER
         END-IF

         ADD 1 TO PART-INDEX

     END-PERFORM.

     COMPUTE PART-POINTER = P-COUNT (PART-INDEX) + 1.

     STRING LOW-VALUE DELIMITED BY SIZE
         INTO PART (PART-INDEX)
         WITH POINTER PART-POINTER.

     IF PART (PART-INDEX) > SPACES
         STRING PART (PART-INDEX) DELIMITED BY LOW-VALUE
             INTO PROG-NAME
             WITH POINTER PROG-POINTER
     END-IF.
*========================================
 REC006-CALL-H.
*========================================
     CALL "REC006" USING CONTROL-REC
         HEADER-SPEC         SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-D.
*========================================
     CALL "REC006" USING CONTROL-REC
         DISPLAY-SPEC        SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-I.
*========================================
     CALL "REC006" USING CONTROL-REC
         INPUT-SPEC          SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-IL.
*========================================
     CALL "REC006" USING CONTROL-REC
         INPUT-LINE          SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-OP.
*========================================
     CALL "REC006" USING CONTROL-REC
         OPERATION-SPEC      SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-CP.
*========================================
     CALL "REC006" USING CONTROL-REC
         PARAMETER-SPEC      SPEC-OFFSET
         PARM-RECORD         SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-FU.
*========================================
     CALL "REC006" USING CONTROL-REC
         FUNCTION-SPEC       SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-DD.
*========================================
     CALL "REC006" USING CONTROL-REC
         DIREC-OF            SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.

*========================================
 REC006-CALL-T.
*========================================
     CALL "REC006" USING CONTROL-REC
         TRAILER-SPEC        SPEC-OFFSET
         DATA-AREA           SCREEN-OFFSET
         PROT-AREA           PROT-OFFSET
         UNPROT-AREA         UNPROT-OFFSET.
